/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.experimenttracking.mlflowfilter;

import com.dataiku.dip.antlrgrammars.MLflowFilterParser;
import com.dataiku.dip.experimenttracking.ExperimentTrackingInternalDBNoCreate;
import com.dataiku.dip.experimenttracking.ViewType;
import com.dataiku.dip.experimenttracking.mlflowfilter.MLflowSearchTranslator;
import com.dataiku.dip.utils.DKULogger;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class MLflowSearchRunsTranslator
extends MLflowSearchTranslator {
    public static final String RUN_ALIAS = "r";
    private final Pattern EXPERIMENT_ID_REGEXP = Pattern.compile("^\\w+$");
    private final List<String> experimentIds;
    protected static final DKULogger logger = DKULogger.getLogger((String)"com.dataiku.dip.mlflow.mlflowfilter.MLflowSearchRunsTranslator");

    public MLflowSearchRunsTranslator(ExperimentTrackingInternalDBNoCreate experimentTrackingInternalDBNoCreate, String projectKey, List<String> experimentIds, String filterExpression, List<String> orderExpressions, long limit, ViewType runViewType) {
        super(experimentTrackingInternalDBNoCreate, projectKey, orderExpressions, limit, runViewType);
        this.SEARCH_REGEXP = Pattern.compile("(params|tags|metrics|attributes)\\.(?:\\\"|`)?([^\\s\\\"`]+)(?:\\\"|`)?\\s*(ASC|DESC)?");
        logger.trace((Object)"Parsing expression...");
        MLflowFilterParser parser = this.initializeParser(filterExpression);
        this.parseTree = parser.parseRunsFilter();
        this.experimentIds = experimentIds;
        if (CollectionUtils.isNotEmpty(experimentIds)) {
            experimentIds.forEach(eid -> {
                Matcher matcher = this.EXPERIMENT_ID_REGEXP.matcher((CharSequence)eid);
                if (!matcher.matches()) {
                    throw new IllegalArgumentException("Invalid experiment id: `" + eid + "'");
                }
            });
        }
    }

    @Override
    protected String getAliasLabel() {
        return RUN_ALIAS;
    }

    @Override
    protected String getTableLabel() {
        return "RUNS";
    }

    @Override
    protected String getTagTableLabel() {
        return "RUN_TAGS";
    }

    @Override
    protected String getIdFieldLabel() {
        return "RUN_ID";
    }

    @Override
    protected String getProjectKeyLabel() {
        return "RUN_PROJECT_KEY";
    }

    @Override
    protected String getLifeCycleStageFieldLabel() {
        return "RUN_LIFECYCLE_STAGE";
    }

    @Override
    protected String getTagIdFieldLabel() {
        return "TAG_RUN_ID";
    }

    @Override
    protected String getDefaultOrderingLabel() {
        return "RUN_START_TIME";
    }

    @Override
    protected DKULogger getLogger() {
        return logger;
    }

    @Override
    protected String additionalFilters() {
        return this.filterExperiments();
    }

    private String filterExperiments() {
        Object select = "";
        if (CollectionUtils.isNotEmpty(this.experimentIds)) {
            select = (String)select + " and r." + this.sqlDialect.quoteIdentifier("RUN_EXP_ID") + " IN (" + StringUtils.join((Collection)this.experimentIds.stream().map(eid -> this.sqlDialect.quoteString((String)eid)).collect(Collectors.toList()), (String)", ") + ")";
        }
        return select;
    }
}

