/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.graphicsexport;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.analysis.docgen.helpers.UrlUtil;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.export.hooks.FileExportPostprocessingHookHandler;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.graphicsexport.execution.GraphicsExportUtils;
import com.dataiku.dip.graphicsexport.model.BaseExport;
import com.dataiku.dip.graphicsexport.model.EnrichedExport;
import com.dataiku.dip.graphicsexport.model.ExportFormat;
import com.dataiku.dip.graphicsexport.model.ExportResult;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.notifications.HrefContext;
import com.dataiku.dip.server.services.InternalAPIKeysService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.Range;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseExportService<T extends BaseExport, U extends ExportFormat, S extends EnrichedExport> {
    private static final String TMP_EXPORT_DIRECTORY = "graphics-export";
    private static final String RAW_DIRECTORY = "raw";
    private static final String POST_PROCESS_DIRECTORY = "post-process";
    private static final String FINAL_DIRECTORY = "final";
    private static final String EXPORT_DESC_JSON_FILE = "export-desc.json";
    private static final String SANDBOX_DIP_PROPERTY = "dku.exports.chrome.sandbox";
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    protected FutureService futureService;
    @Autowired
    private InternalAPIKeysService internalAPIKeysService;
    @Autowired
    protected GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.export");

    public FutureResponse<ExportResult> export(AuthCtx user, T export) throws Exception {
        return this.futureService.safeRunFuture(this.newFutureThread(user, export), 0L);
    }

    public ExportResult exportAndWait(AuthCtx user, T export) throws Exception {
        return (ExportResult)this.futureService.runAndWait(this.newFutureThread(user, export), (TypeToken)new TypeToken<FutureResponse<ExportResult>>(){});
    }

    public File getExportFile(AuthCtx user, String projectKey, String exportId) throws IOException, DKUSecurityException {
        File finalExportDirectory = new File(BaseExportService.getTmpExportDirectory(projectKey, exportId), FINAL_DIRECTORY);
        File exportDescFile = new File(finalExportDirectory, EXPORT_DESC_JSON_FILE);
        if (!exportDescFile.exists()) {
            throw new IllegalArgumentException("No export data found for specified projectKey and exportId.");
        }
        ExportFileDesc exportFileDesc = (ExportFileDesc)JSON.parseFile((File)exportDescFile, ExportFileDesc.class);
        if (!Objects.equals(exportFileDesc.owner, user.getAssociatedDSSUserOrIdentifier())) {
            throw new DKUSecurityException("You don't have the right retrieve the export for the specified projectKey and exportId.");
        }
        File exportFile = new File(finalExportDirectory, GraphicsExportUtils.sanitize(exportFileDesc.filename));
        if (!exportFile.exists()) {
            throw new IllegalStateException("Found export-desc.json file but associated export data file is missing.");
        }
        return exportFile;
    }

    public void clean(String projectKey, String exportId) throws IOException {
        DKUFileUtils.deleteDirectory((File)BaseExportService.getTmpExportDirectory(projectKey, exportId));
    }

    protected abstract ExportFutureThread newFutureThread(AuthCtx var1, T var2) throws IOException, DKUSecurityException;

    @VisibleForTesting
    public S checkAndEnrichExport(AuthCtx user, T export, Privileges.ProjectLevelPrivilegeType expectedPrivilege) throws IOException, DKUSecurityException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)((BaseExport)export).projectKey), (Object)"Project Key not specified");
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(user, ((BaseExport)export).projectKey, expectedPrivilege);
            GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDAO.read();
            if (!generalSettings.graphicsExportsEnabled) {
                throw new IllegalStateException("Graphics export feature is not enabled");
            }
            String rootUrl = UrlUtil.getDSSInternalRootUrl(generalSettings);
            if (rootUrl.endsWith("/")) {
                rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
            }
            HrefContext hrefContext = new HrefContext(rootUrl);
            String useSandbox = ApplicationConfigurator.getProperty((String)SANDBOX_DIP_PROPERTY, (String)"true");
            boolean browserSandBoxing = !"false".equalsIgnoreCase(useSandbox);
            S s = this.checkAndEnrichExport(export, hrefContext, browserSandBoxing);
            return s;
        }
    }

    protected abstract S checkAndEnrichExport(T var1, HrefContext var2, boolean var3) throws IOException;

    @VisibleForTesting
    public U checkAndEnrichExportFormat(U format, Range<Integer> widthRange, Range<Integer> heightRange) {
        Preconditions.checkNotNull((Object)((Object)((ExportFormat)format).paperSize), (Object)"Paper size must be specified (A4, US_LETTER, SCREEN_16_9, CUSTOM)");
        Preconditions.checkNotNull((Object)((Object)((ExportFormat)format).fileType), (Object)"File type must specified (PDF, JPEG, PNG)");
        U result = this.newExportFormat();
        ((ExportFormat)result).paperSize = ((ExportFormat)format).paperSize;
        ((ExportFormat)result).fileType = ((ExportFormat)format).fileType;
        if (((ExportFormat)format).paperSize.ratio != null) {
            if (((ExportFormat)format).orientation == ExportFormat.Orientation.PORTRAIT) {
                ((ExportFormat)result).orientation = ExportFormat.Orientation.PORTRAIT;
                if (((ExportFormat)format).width == null) {
                    Preconditions.checkArgument((((ExportFormat)format).height == null || widthRange.contains((Object)((ExportFormat)format).height) ? 1 : 0) != 0, (Object)("Specified height is out of range " + String.valueOf(widthRange) + ": " + ((ExportFormat)format).height));
                    ((ExportFormat)result).height = ((ExportFormat)format).height != null ? ((ExportFormat)format).height : 1920;
                    ((ExportFormat)result).width = (int)Math.round((double)((ExportFormat)result).height.intValue() / ((ExportFormat)format).paperSize.ratio);
                } else {
                    Preconditions.checkArgument((boolean)heightRange.contains((Object)((ExportFormat)format).width), (Object)("Specified width is out of range " + String.valueOf(heightRange) + ": " + ((ExportFormat)format).width));
                    ((ExportFormat)result).width = ((ExportFormat)format).width;
                    ((ExportFormat)result).height = (int)Math.round((double)((ExportFormat)result).width.intValue() * ((ExportFormat)format).paperSize.ratio);
                }
            } else {
                ((ExportFormat)result).orientation = ExportFormat.Orientation.LANDSCAPE;
                if (((ExportFormat)format).height == null) {
                    Preconditions.checkArgument((((ExportFormat)format).width == null || widthRange.contains((Object)((ExportFormat)format).width) ? 1 : 0) != 0, (Object)("Specified width is out of range " + String.valueOf(widthRange) + ": " + ((ExportFormat)format).width));
                    ((ExportFormat)result).width = ((ExportFormat)format).width != null ? ((ExportFormat)format).width : 1920;
                    ((ExportFormat)result).height = (int)Math.round((double)((ExportFormat)result).width.intValue() / ((ExportFormat)format).paperSize.ratio);
                } else {
                    Preconditions.checkArgument((boolean)heightRange.contains((Object)((ExportFormat)format).height), (Object)("Specified height is out of range " + String.valueOf(heightRange) + ": " + ((ExportFormat)format).height));
                    ((ExportFormat)result).height = ((ExportFormat)format).height;
                    ((ExportFormat)result).width = (int)Math.round((double)((ExportFormat)result).height.intValue() * ((ExportFormat)format).paperSize.ratio);
                }
            }
        } else {
            Preconditions.checkArgument((((ExportFormat)format).width != null ? 1 : 0) != 0, (Object)"Width must be specified with custom paperSize");
            Preconditions.checkArgument((((ExportFormat)format).height != null ? 1 : 0) != 0, (Object)"Height must be specified with custom paperSize");
            Preconditions.checkArgument((boolean)widthRange.contains((Object)((ExportFormat)format).width), (Object)("Specified width is out of range: " + ((ExportFormat)format).width + ". Acceptable range:" + String.valueOf(widthRange)));
            Preconditions.checkArgument((boolean)heightRange.contains((Object)((ExportFormat)format).height), (Object)("Specified height is out of range: " + ((ExportFormat)format).height + ". Acceptable range:" + String.valueOf(widthRange)));
            ((ExportFormat)result).orientation = null;
            ((ExportFormat)result).width = ((ExportFormat)format).width;
            ((ExportFormat)result).height = ((ExportFormat)format).height;
        }
        return result;
    }

    protected abstract U newExportFormat();

    public static File retrieveTmpExportDirectory(String projectKey, String exportId) {
        return DKUApp.getFile((String[])new String[]{"tmp", "graphics-export/" + projectKey, exportId});
    }

    private static File getTmpExportDirectory(String projectKey, String exportId) throws IOException {
        return DSSTempUtils.getTempFolderWithSpecifiName((String)("graphics-export/" + projectKey), (String)exportId);
    }

    protected abstract class ExportFutureThread
    extends SimpleFutureThread<ExportResult> {
        protected final EnrichedExport export;
        protected final FuturePayload futurePayload;

        public ExportFutureThread(AuthCtx user, EnrichedExport export) {
            super(user);
            this.export = export;
            this.futurePayload = this.buildExportFuturePayload();
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        @Override
        public ExportResult compute() throws Exception {
            InternalAPIKeysService.APIKey key = this.createAPIKey(this.export.projectKey);
            try {
                ExportResult exportResult;
                block9: {
                    FutureProgress.AutocloseableFutureProgressState fp = FutureProgress.pushAutoCloseableState((String)this.getTitle(), (double)this.getExportTargetCount(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);
                    try {
                        exportResult = this.doExport(key, (FutureProgressState)fp);
                        if (fp == null) break block9;
                    }
                    catch (Throwable throwable) {
                        if (fp != null) {
                            try {
                                fp.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    fp.close();
                }
                return exportResult;
            }
            finally {
                this.deleteAPIKey(key);
            }
        }

        protected abstract String getTitle();

        protected abstract int getExportTargetCount();

        protected abstract File postProcessGeneratedFiles(File var1, File var2, File var3) throws Exception;

        protected abstract void executeScript(InternalAPIKeysService.APIKey var1, File var2, FutureProgressState var3) throws IOException, InterruptedException;

        protected abstract FuturePayload buildExportFuturePayload();

        protected FuturePayload buildExportFuturePayload(String exportType, String fileType) {
            FuturePayload fp = new FuturePayload();
            fp.action = "export_" + exportType;
            fp.targets.add(new FuturePayload.FuturePayloadTarget(this.export.projectKey, fileType));
            fp.displayName = String.format("Export %s from %s to %s", exportType, this.export.projectKey, fileType);
            return fp;
        }

        private ExportResult doExport(InternalAPIKeysService.APIKey key, FutureProgressState progressState) throws Exception {
            File tmpDirectory = BaseExportService.getTmpExportDirectory(this.export.projectKey, this.export.exportId);
            File rawExportDirectory = this.createIfMissing(new File(tmpDirectory, BaseExportService.RAW_DIRECTORY));
            File postProcessDirectory = this.createIfMissing(new File(tmpDirectory, BaseExportService.POST_PROCESS_DIRECTORY));
            File finalExportDirectory = this.createIfMissing(new File(tmpDirectory, BaseExportService.FINAL_DIRECTORY));
            logger.info((Object)"Executing headless browser to export the DSS item");
            this.executeScript(key, rawExportDirectory, progressState);
            logger.info((Object)"Post-processing export");
            File exportFile = this.postProcessGeneratedFiles(rawExportDirectory, postProcessDirectory, finalExportDirectory);
            logger.info((Object)"Finalizing export");
            ExportFileDesc exportDescFile = new ExportFileDesc(GraphicsExportUtils.sanitize(exportFile.getName()), this.owner.getAssociatedDSSUserOrIdentifier());
            Files.write((CharSequence)JSON.json((Object)exportDescFile), (File)new File(finalExportDirectory, BaseExportService.EXPORT_DESC_JSON_FILE), (Charset)Charsets.UTF_8);
            DKUFileUtils.deleteDirectory((File)rawExportDirectory);
            DKUFileUtils.deleteDirectory((File)postProcessDirectory);
            FileExportPostprocessingHookHandler.onPostGraphicExport(this.getOwner(), exportFile, this.export);
            return new ExportResult(this.export.projectKey, this.export.exportId, exportFile);
        }

        private File createIfMissing(File directory) throws IOException {
            if (!directory.exists() && !directory.mkdirs()) {
                throw new IOException("Unable to create directory " + String.valueOf(directory));
            }
            return directory;
        }

        private InternalAPIKeysService.APIKey createAPIKey(String projectKey) {
            String associatedUser;
            DSSAuthCtx authCtx = this.getOwner();
            String string = associatedUser = authCtx.getAssociatedDSSUser() != null ? authCtx.getAssociatedDSSUser() : authCtx.getDSSUserForImpersonation();
            if (StringUtils.isBlank((String)associatedUser)) {
                throw new IllegalArgumentException("The provided API key does not impersonate a DSS user. Please use a personal API key or a global API key impersonating a DSS user.");
            }
            InternalAPIKeysService.APIKey apiKey = BaseExportService.this.internalAPIKeysService.createTmpKey((AuthCtx)authCtx);
            BaseExportService.this.auditTrailService.generic("internal-api-key-creation").with("projectKey", projectKey).emit();
            return apiKey;
        }

        private void deleteAPIKey(InternalAPIKeysService.APIKey key) {
            BaseExportService.this.internalAPIKeysService.deleteTmpKey(key);
            BaseExportService.this.auditTrailService.generic("internal-api-key-deletion").with("projectKey", this.export.projectKey).with("exportId", this.export.exportId).emit();
        }
    }

    private static class ExportFileDesc {
        public String filename;
        public String owner;

        public ExportFileDesc(String filename, String owner) {
            this.filename = filename;
            this.owner = owner;
        }
    }
}

