/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.GlueClient;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class GlueMetastoreUtils {
    public static GlueClient getClient(AuthCtx authCtx) throws IOException, DKUSecurityException, CodedException {
        GeneralSettingsDAO.MetastoreCatalogsSettings metastoreCatalogsSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().metastoreCatalogsSettings;
        switch (metastoreCatalogsSettings.synchronizeTo.glueCredentialsMode) {
            case DEFAULT: {
                return (GlueClient)GlueClient.builder().build();
            }
            case FROM_CONNECTION: {
                String connectionName = metastoreCatalogsSettings.synchronizeTo.glueCredentialsBearingConnection;
                if (StringUtils.isBlank((String)connectionName)) {
                    throw new IOException("No connection specified to provide credentials for Glue");
                }
                DSSConnection connection = ConnectionsDAO.get().getMandatoryConnection(authCtx, connectionName);
                if (!(connection instanceof EC2Connection)) {
                    throw new IOException("Connection " + connectionName + " is not an AWS connection");
                }
                return ((EC2Connection)connection).getGlueClient(authCtx);
            }
        }
        throw new Error("unreachable");
    }
}

