/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive;

import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.HiveSettings;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.fs.HDFSDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hadoop.HDFSPathUtils;
import com.dataiku.dip.hadoop.HDFSSafeDataHandler;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.hive.HdfsPathSubstitution;
import com.dataiku.dip.hive.HiveMetastoreTablesHandler;
import com.dataiku.dip.hive.MetastoreInspectionService;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class HiveLocalMetastoreTablesHandler
extends HiveMetastoreTablesHandler {
    private final List<HdfsPathSubstitution> hdfsPathSubsts = Lists.newArrayList();
    private final List<String> commands = Lists.newArrayList();
    private String hdfsPathPrefix = "";
    private String useDatabaseCommand = "";
    private String overrideDbName;
    private static Logger logger = Logger.getLogger((String)"dku.flow.hive.localm");

    public HiveLocalMetastoreTablesHandler(String projectKey, AuthCtx authCtx, boolean canDatabaseOverride, MetastoreInspectionService.MetastoreInspector hiveServer2SchemaHandler) throws IOException, DKUSecurityException {
        super(authCtx, hiveServer2SchemaHandler);
        HiveSettings hiveSettings = new ClusterSelector().selectForProject(authCtx, projectKey).getHiveSettings();
        this.overrideDbName = canDatabaseOverride && hiveSettings.overrideDatabaseInLocalMetastore ? "dataiku" : null;
    }

    @Override
    public void setHDFSPathPrefix(String prefix) {
        if (prefix.endsWith("/")) {
            prefix = StringUtils.chop((String)prefix);
        }
        this.hdfsPathPrefix = prefix;
    }

    @Override
    public void preProcessSource(FlowDataset fds, Dataset dataset, String tableName, List<Partition> sourceParts) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        this.commands.add(this.getUseDatabaseHeader(dataset, true, this.overrideDbName));
        this.commands.add("DROP TABLE " + tableName + ";");
        if (DatasetInspector.canHDFS(dataset)) {
            String tableLocation;
            try (HDFSDatasetHandler handler = (HDFSDatasetHandler)DatasetHandlerFactory.build(this.authCtx, dataset);){
                tableLocation = handler.getFullyQualifiedRootPath();
                this.commands.add(this.getCreateTableHeader(dataset, tableName, tableLocation));
                this.collectedExtraConf.addAll(handler.getFSExtraConf());
            }
            if (dataset.getPartitioningSchema().isPartitioned()) {
                for (Partition partition : sourceParts) {
                    String partitionLocation = HDFSPathUtils.concat(tableLocation, FilePartitioner.computePartitionRelPathAsFolder(partition, dataset.getPartitioningSchema()));
                    this.commands.add(this.getCreatePartition(dataset, tableName, partition, partitionLocation));
                }
            }
        } else if (DatasetInspector.isHiveTable(dataset) || DatasetInspector.isHiveQuery(dataset)) {
            this.commands.add(this.getCreateFakeTableHeader(dataset, tableName));
        } else {
            throw new CodedIOException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_I_O, "Only a HDFS dataset can be used as input when the engine is 'Hive CLI (Isolated metastore)'");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void preProcessTarget(FlowDataset fds, Dataset dataset, String tableName, Partition targetPart) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        if (dataset.getSchema().getColumns().size() == 0) {
            return;
        }
        if (!DatasetInspector.canHDFS(dataset)) throw new CodedIOException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_I_O, "Only a HDFS dataset can be used as output");
        try (HDFSDatasetHandler handler = (HDFSDatasetHandler)DatasetHandlerFactory.build(this.authCtx, dataset);){
            this.collectedExtraConf.addAll(handler.getFSExtraConf());
            Object finalLocation = HDFSPathUtils.concat(handler.getEffectiveDatasetRootWithinAuthority(), FilePartitioner.computePartitionRelPathAsFolder(targetPart, dataset.getPartitioningSchema()));
            Object tmpLocation = HDFSSafeDataHandler.getTmpPath((String)finalLocation);
            if (this.hdfsPathPrefix != null) {
                tmpLocation = this.hdfsPathPrefix + (String)tmpLocation;
                finalLocation = this.hdfsPathPrefix + (String)finalLocation;
            }
            this.hdfsPathSubsts.add(new HdfsPathSubstitution(HadoopLoader.getFS(handler.getConnectionRootSchemeAndAuthority(), handler.getFSExtraConf()), (String)tmpLocation, (String)finalLocation));
            this.commands.add(this.getUseDatabaseHeader(dataset, true, this.overrideDbName));
            this.useDatabaseCommand = this.getUseDatabaseHeader(dataset, false, this.overrideDbName);
            String fqTmpLocation = handler.getFullyQualifiedHDFSPath((String)tmpLocation);
            String createTable = this.getCreateTableHeader(dataset, tableName, fqTmpLocation);
            this.commands.add("DROP TABLE `" + tableName + "`;");
            this.commands.add(createTable);
            if (!dataset.getPartitioningSchema().isPartitioned()) return;
            String createPartition = this.getCreatePartition(dataset, tableName, targetPart, fqTmpLocation);
            this.commands.add(createPartition);
            return;
        }
    }

    @Override
    public String getCreationScript() {
        return Joiner.on((String)"\n").join(this.commands) + "\n" + this.useDatabaseCommand;
    }

    @Override
    public void prepare() throws IOException {
        logger.info((Object)"Removing stale temporary entries");
        HDFSSafeDataHandler.removeTargetTmpEntries(this.hdfsPathSubsts);
    }

    @Override
    public void postProcess() throws IOException {
        logger.info((Object)"Hive script execution complete, moving data to final location");
        HDFSSafeDataHandler.moveToFinalLocations(this.hdfsPathSubsts);
    }

    @Override
    public boolean shouldPrefixWithDbInInsert() {
        return false;
    }
}

