/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.labeling.consensus;

import com.dataiku.dip.labeling.Annotation;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.consensus.ClassificationMajorityConsensusLabelComputer;
import com.dataiku.dip.labeling.consensus.ConsensusLabelComputer;
import com.dataiku.dip.labeling.consensus.FreeTextConsensusLabelComputer;
import com.dataiku.dip.labeling.consensus.NamedEntityExtractionMajorityConsensusLabelComputer;
import com.dataiku.dip.labeling.consensus.ObjectDetectionAverageConsensusLabelComputer;

public class ConsensusLabelComputerFactory {
    public static ConsensusLabelComputer<? extends Annotation> getConsensusComputer(LabelingTask.LabelingTaskType labelingTaskType, LabelingTask.ConsensusStrategy strategy) {
        switch (labelingTaskType) {
            case NAMED_ENTITY_EXTRACTION: {
                if (strategy == LabelingTask.ConsensusStrategy.MAJORITY) {
                    return new NamedEntityExtractionMajorityConsensusLabelComputer();
                }
            }
            case IMAGE_CLASSIFICATION: 
            case RECORD_CLASSIFICATION: 
            case TEXT_CLASSIFICATION: {
                if (strategy == LabelingTask.ConsensusStrategy.MAJORITY) {
                    return new ClassificationMajorityConsensusLabelComputer();
                }
                throw new IllegalStateException("Unsupported strategy: " + String.valueOf((Object)strategy));
            }
            case OBJECT_DETECTION: {
                if (strategy == LabelingTask.ConsensusStrategy.AVERAGE) {
                    return new ObjectDetectionAverageConsensusLabelComputer();
                }
                throw new IllegalStateException("Unsupported strategy: " + String.valueOf((Object)strategy));
            }
            case RECORD_FREETEXT: {
                if (strategy == LabelingTask.ConsensusStrategy.MAJORITY) {
                    return new FreeTextConsensusLabelComputer();
                }
                throw new IllegalStateException("Unsupported strategy: " + String.valueOf((Object)strategy));
            }
        }
        throw new IllegalStateException("Unexpected labeling task type: " + String.valueOf((Object)labelingTaskType));
    }
}

