/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.mistralai.api;

import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import javax.annotation.Nullable;

public class MistralAIChatQuery {
    @Nullable
    public String model;
    public List<Message> messages;
    @Nullable
    @SerializedName(value="max_tokens")
    public Integer maxTokens;
    @Nullable
    public Double temperature;
    @Nullable
    @SerializedName(value="top_p")
    public Double topP;
    @Nullable
    public Boolean stream;
    @Nullable
    @SerializedName(value="tool_choice")
    public ToolChoice toolChoice;
    @Nullable
    public List<FunctionTool> tools;
    @Nullable
    @SerializedName(value="response_format")
    public MistralAIResponseFormat responseFormat;

    public static class FunctionToolDesc {
        public String name;
        @Nullable
        public String description;
        @Nullable
        public JsonObject parameters;
    }

    public static class FunctionTool {
        public final String type = "function";
        public FunctionToolDesc function;
    }

    public static enum ToolChoice {
        none,
        auto,
        any;

    }

    public static class ToolCallFunction {
        public String name;
        public String arguments;
    }

    public static class ToolCall {
        public String id;
        public ToolCallFunction function;
    }

    public static class ToolMessage
    implements Message {
        public final String role = "tool";
        public String content;
        @Nullable
        @SerializedName(value="tool_call_id")
        public String toolCallId;
    }

    public static class AssistantMessage
    implements Message {
        public final String role = "assistant";
        @Nullable
        public String content;
        @Nullable
        @SerializedName(value="tool_calls")
        public List<ToolCall> toolCalls;
    }

    public static class UserMessage
    implements Message {
        public final String role = "user";
        public String content;
    }

    public static class SystemMessage
    implements Message {
        public final String role = "system";
        public String content;
    }

    public static interface Message {
    }

    public static class MistralAIResponseFormatJSONObject
    extends MistralAIResponseFormat {
    }

    public static class MistralAIResponseFormatText
    extends MistralAIResponseFormat {
    }

    @PolyJSON(value={@Mapping(type="text", value=MistralAIResponseFormatText.class), @Mapping(type="json_object", value=MistralAIResponseFormatJSONObject.class)})
    public static abstract class MistralAIResponseFormat {
    }
}

