/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.openai;

import com.dataiku.dip.analysis.ml.llm.LLMSavedModelVersionDeployment;
import com.dataiku.dip.analysis.ml.llm.LLMSavedModelVersionDeploymentWithStatus;
import com.dataiku.dip.externalinfras.azureml.http.AzureMLHttpClient;
import com.dataiku.dip.llm.online.ISavedModelDeployer;
import com.dataiku.dip.utils.DKULogger;
import java.util.Optional;

public class AzureOpenAISavedModelDeployer
implements ISavedModelDeployer {
    private final AzureMLHttpClient azureMLHttpClient;
    private final String subscriptionId;
    private final String resourceGroup;
    private final String resourceName;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.llm.online.azureopenai.model-deployer");

    AzureOpenAISavedModelDeployer(AzureMLHttpClient azureMLHttpClient, String subscriptionId, String resourceGroup, String resourceName) {
        this.azureMLHttpClient = azureMLHttpClient;
        this.subscriptionId = subscriptionId;
        this.resourceGroup = resourceGroup;
        this.resourceName = resourceName;
    }

    @Override
    public LLMSavedModelVersionDeploymentWithStatus getDeployment(LLMSavedModelVersionDeployment deployment) {
        try {
            Optional<AzureMLHttpClient.AzureDeployment> azureDeployment = this.azureMLHttpClient.getDeployment_NT(this.subscriptionId, this.resourceGroup, this.resourceName, deployment.deploymentId);
            return LLMSavedModelVersionDeploymentWithStatus.fromDeployment(deployment, azureDeployment, LLMSavedModelVersionDeploymentWithStatus.DeploymentStatus.NOT_FOUND);
        }
        catch (AzureMLHttpClient.AzureManagementAPIException e) {
            logger.error((Object)e);
            return LLMSavedModelVersionDeploymentWithStatus.fromDeployment(deployment, Optional.empty(), LLMSavedModelVersionDeploymentWithStatus.DeploymentStatus.IN_ERROR);
        }
    }

    @Override
    public void deleteDeployment(LLMSavedModelVersionDeployment deployment) throws AzureMLHttpClient.AzureManagementAPIException {
        this.azureMLHttpClient.deleteDeployment_NT(this.subscriptionId, this.resourceGroup, this.resourceName, deployment.deploymentId);
    }

    @Override
    public LLMSavedModelVersionDeploymentWithStatus createDeployment(LLMSavedModelVersionDeployment deployment, String remoteModelId) throws AzureMLHttpClient.AzureManagementAPIException {
        AzureMLHttpClient.AzureDeployment azureDeployment = this.azureMLHttpClient.createDeployment_NT(this.subscriptionId, this.resourceGroup, this.resourceName, deployment.deploymentId, remoteModelId);
        return LLMSavedModelVersionDeploymentWithStatus.fromDeployment(deployment, Optional.of(azureDeployment), LLMSavedModelVersionDeploymentWithStatus.DeploymentStatus.IN_ERROR);
    }
}

