/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.retrieval;

import com.dataiku.dip.agents.tools.filtering.SimpleFilter;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.util.SetUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import com.dataiku.j2py.annotations.PyModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@PyModel
public class RetrievableKnowledge
extends TaggableObjectsService.TaggableObject
implements ParamsWithSelectableCodeEnv {
    @JSON.FileTransient
    public String projectKey;
    @JSON.FileTransient
    public String id;
    public String name;
    public RetrieverType retrieverType = RetrieverType.VECTOR_STORE_BACKED;
    public SerializedDataset.RebuildBehavior rebuildBehavior = SerializedDataset.RebuildBehavior.EXPLICIT;
    private static final Set<FilterDesc.FilterUiOperator> baseSupportedFilterOperators = Set.of(FilterDesc.FilterUiOperator.EQUALS_STRING, FilterDesc.FilterUiOperator.NOT_EQUALS_STRING, FilterDesc.FilterUiOperator.IN_ANY_OF_STRING, FilterDesc.FilterUiOperator.IN_NONE_OF_STRING, FilterDesc.FilterUiOperator.EQUALS_NUMBER, FilterDesc.FilterUiOperator.NOT_EQUALS_NUMBER, FilterDesc.FilterUiOperator.GREATER_NUMBER, FilterDesc.FilterUiOperator.GREATER_OR_EQUAL_NUMBER, FilterDesc.FilterUiOperator.LESS_NUMBER, FilterDesc.FilterUiOperator.LESS_OR_EQUAL_NUMBER, FilterDesc.FilterUiOperator.IN_ANY_OF_NUMBER, FilterDesc.FilterUiOperator.IN_NONE_OF_NUMBER);
    private static final Set<String> defaultSupportedBooleanOperators = Set.of("&&", "||");
    public VectorStoreType vectorStoreType = VectorStoreType.CHROMA;
    @JSON.FileTransient
    public FilterCapabilities filterCapabilities;
    public String connection;
    public String indexName;
    public String resolvedIndexName;
    public String pineconeIndexName;
    public String embeddingLLMId;
    public String sourceIdColumn;
    public List<SchemaColumn> metadataColumnsSchema;
    public CodeEnvSelection envSelection = CodeEnvSelection.inherit();
    public ContainerExecSelection containerExecSelection = new ContainerExecSelection();
    @Nullable
    public String managedFolderId;
    @Nullable
    public String multimodalColumn;

    @Override
    public CodeEnvSelection getCodeEnvSelection() {
        return this.envSelection;
    }

    @Override
    public void setCodeEnvSelection(CodeEnvSelection envSelection) {
        this.envSelection = envSelection;
    }

    @Override
    public List<CodeEnvModel.CodeEnvUsage> collectCodeEnvUsage(TaggableObjectsService.TaggableObject object) {
        ArrayList usages = Lists.newArrayList();
        if (this.envSelection.envMode == CodeEnvSelection.EnvMode.EXPLICIT_ENV) {
            usages.add(new CodeEnvModel.CodeEnvUsage(CodeEnvModel.EnvLang.PYTHON, this.envSelection.envName, CodeEnvModel.EnvUsage.RETRIEVABLE_KNOWLEDGE, this.projectKey, object.getId()));
        }
        return usages;
    }

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return ITaggingService.TaggableType.RETRIEVABLE_KNOWLEDGE;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    public static enum RetrieverType {
        VECTOR_STORE_BACKED;

    }

    public static enum VectorStoreType {
        FAISS(false, false, false, baseSupportedFilterOperators, defaultSupportedBooleanOperators),
        CHROMA(false, false, false, baseSupportedFilterOperators, defaultSupportedBooleanOperators),
        PINECONE(true, false, false, baseSupportedFilterOperators, defaultSupportedBooleanOperators),
        ELASTICSEARCH(true, true, true, baseSupportedFilterOperators, defaultSupportedBooleanOperators),
        AZURE_AI_SEARCH(true, true, true, baseSupportedFilterOperators, defaultSupportedBooleanOperators),
        VERTEX_AI_GCS_BASED(true, true, false, SetUtils.removeElements(baseSupportedFilterOperators, Set.of(FilterDesc.FilterUiOperator.IN_ANY_OF_NUMBER, FilterDesc.FilterUiOperator.IN_NONE_OF_NUMBER)), Set.of("&&")),
        QDRANT_LOCAL(false, false, false, baseSupportedFilterOperators, defaultSupportedBooleanOperators);

        public final boolean hasConnection;
        public final boolean hasIndex;
        public final boolean supportsHybrid;
        public final Set<FilterDesc.FilterUiOperator> supportedFiltersOperators;
        public final Set<String> supportedBooleanOperators;

        private VectorStoreType(boolean hasConnection, boolean hasIndex, boolean supportsHybrid, Set<FilterDesc.FilterUiOperator> supportedFiltersOperators, Set<String> supportedBooleanOperators) {
            this.hasConnection = hasConnection;
            this.hasIndex = hasIndex;
            this.supportsHybrid = supportsHybrid;
            this.supportedFiltersOperators = supportedFiltersOperators;
            this.supportedBooleanOperators = supportedBooleanOperators;
        }
    }

    public static class RetrievableKnowledgeStatus {
        public Long fileSizeMb;
        public Integer nbDocuments;
        public Integer nbChunks;
    }

    public static class RetrievableKnowledgeVersionInfo {
        public long buildAt;
    }

    public static class RetrievableKnowledgeVersions {
        public String currentVersion;
    }

    public static class RetrievableKnowledgeListItem
    extends TaggableObjectsService.TaggableListItem {
        public RetrievableKnowledgeListItem(RetrievableKnowledge rk) {
            super(rk);
        }

        @Override
        public ITaggingService.TaggableType getTaggableType() {
            return ITaggingService.TaggableType.RETRIEVABLE_KNOWLEDGE;
        }
    }

    public static class FilterCapabilities {
        private List<String> supportedFiltersOperators;
        private List<String> supportedBooleanOperators;

        FilterCapabilities(Set<FilterDesc.FilterUiOperator> supportedFiltersOperators, Set<String> supportedBooleanOperators) {
            this.supportedFiltersOperators = supportedFiltersOperators.stream().map(op -> op.getRepr()).collect(Collectors.toUnmodifiableList());
            this.supportedBooleanOperators = new ArrayList<String>(supportedBooleanOperators);
        }

        public List<String> asStrOperators() {
            ArrayList<String> operators = new ArrayList<String>(this.supportedFiltersOperators.stream().map(c2 -> SimpleFilter.toOperator(c2).name()).collect(Collectors.toSet()));
            operators.addAll(this.supportedBooleanOperators.stream().map(c2 -> SimpleFilter.toOperator(c2).name()).collect(Collectors.toSet()));
            return operators;
        }
    }
}

