/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.engines;

import com.dataiku.dip.connections.HiveConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hive.HiveConfigurator;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.hive.HiveServer2ConnectionPoolService;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.MetricsEngineDesc;
import com.dataiku.dip.metrics.engines.JdbcEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.engines.ProbeQueryBuilder;
import com.dataiku.dip.metrics.probes.MetricBuilder;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.ProbeType;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.recipes.code.hive.HiveConfHelper;
import com.dataiku.dip.security.AuthCtx;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class HiveProbeEngine
extends JdbcEngine
implements ProbeQueryBuilder.ProbeQueryBuilderEngine {
    private final DatasetHandler datasetHandler;
    @Autowired
    private HiveServer2ConnectionPoolService hiveServer2ConnectionPoolService;
    private final JdbcEngine.HiveMetricsEngineConfig config;
    private static Logger logger = Logger.getLogger((String)"dku.datasets.metrics.hive.probe");

    public HiveProbeEngine(Dataset dataset, DatasetHandler datasetHandler, Partition partition, JdbcEngine.HiveMetricsEngineConfig config) {
        super(dataset, partition);
        this.datasetHandler = datasetHandler;
        this.config = config;
    }

    public DatasetHandler getDatasetHandler() {
        return this.datasetHandler;
    }

    @Override
    public void setupConnection(AuthCtx authCtx) throws IOException, DKUSecurityException {
        String database = HiveSchemaHandler.getResolvedHiveDatabaseFromDataset(this.dataset);
        logger.info((Object)("Hive probe engine on database : " + database));
        List<SimpleKeyValue> hiveconf = new HiveConfHelper().getResolvedHiveRuntimeConf(authCtx, this.dataset.getProjectKey(), this.config.extraConf);
        HiveConnection datasetConnection = HiveConfigurator.configureConnectionForDatabase(authCtx, database == null ? "" : database, hiveconf, this.hiveServer2ConnectionPoolService);
        this.connectionData = datasetConnection.getConnectionData_NT(authCtx, this.dataset.getProjectKey());
        this.dialect = this.connectionData.getDialect();
    }

    @Override
    public QueryBunch buildQuery(AuthCtx authCtx, List<MetricComputation> computations, Map<String, String> alreadyComputed) throws Exception {
        MetricComputation primerComputation = computations.get(0);
        MetricComputer.HiveQueryEngineComputer computer = (MetricComputer.HiveQueryEngineComputer)primerComputation.computer;
        ProbeQueryBuilder builder = new ProbeQueryBuilder();
        return builder.buildQuery(authCtx, this, computer.getQuery(primerComputation.probe), computer.getVariables(primerComputation.probe, authCtx, this.dataset.getProjectKey()));
    }

    @Override
    public Map<Metric, String> getAggregates(QueryRunResult res, List<MetricComputation> computations) throws Exception {
        Probe sqlProbe = computations.get((int)0).probe;
        MetricBuilder metricBuilder = (MetricBuilder)((Object)ProbeType.getProbeType(sqlProbe.getType()));
        HashMap metricsValues = Maps.newHashMap();
        if (res.rows != null && res.rows.size() > 0) {
            for (int i = 0; i < res.columns.size(); ++i) {
                SchemaColumn column = HiveSchemaHandler.dssColumnFromHiveColumnDef(res.columns.get((int)i).name, res.columns.get((int)i).type, AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING, AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING);
                String v = res.rows.get(0)[i];
                Metric metric = metricBuilder.build(column.getName(), column.getType(), sqlProbe);
                metricsValues.put(metric, v);
            }
        }
        return metricsValues;
    }

    public static class HiveProbeEngineRun
    extends MetricsEngineRun {
        public HiveProbeEngineRun() {
            super(MetricsEngineDesc.HiveQueryEngine);
        }

        public HiveProbeEngineRun(double cost, List<MetricComputation> computations, int pass) {
            super(MetricsEngineDesc.HiveQueryEngine, cost, computations, pass);
        }

        @Override
        protected MetricsEngineRun subset(double cost, List<MetricComputation> computations) {
            return new HiveProbeEngineRun(cost, computations, this.pass);
        }

        @Override
        public boolean canMergeWith(MetricsEngineRun other) {
            return false;
        }
    }
}

