/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.engines;

import com.dataiku.dip.connections.ImpalaConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.impala.ImpalaConfigurator;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricsEngineDesc;
import com.dataiku.dip.metrics.engines.ColumnMetricsQueryBuilder;
import com.dataiku.dip.metrics.engines.JdbcEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.security.AuthCtx;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ImpalaColumnMetricsEngine
extends JdbcEngine
implements ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderEngine {
    private static Logger logger = Logger.getLogger((String)"dku.datasets.metrics.impala.column_metrics");

    public ImpalaColumnMetricsEngine(Dataset dataset, Partition partition, JdbcEngine.ImpalaMetricsEngineConfig config) {
        super(dataset, partition);
    }

    @Override
    public void setupConnection(AuthCtx authCtx) throws IOException, DKUSecurityException, SQLException {
        String database = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(this.dataset).getSchemaNullIfBlank();
        logger.info((Object)("Impala metrics engine on database : " + database));
        ImpalaConnection datasetConnection = ImpalaConfigurator.configureConnectionForDatabase(authCtx, database == null ? "" : database);
        this.connectionData = datasetConnection.getConnectionData_NT(authCtx, this.dataset.getProjectKey());
        this.dialect = this.connectionData.getDialect();
    }

    @Override
    public QueryBunch buildQuery(AuthCtx authCtx, List<MetricComputation> computations, Map<String, String> alreadyComputed) throws Exception {
        ColumnMetricsQueryBuilder builder = new ColumnMetricsQueryBuilder();
        return builder.buildQuery(authCtx, this, computations);
    }

    @Override
    public Map<Metric, String> getAggregates(QueryRunResult res, List<MetricComputation> computations) throws Exception {
        for (String[] row : res.rows) {
            boolean more = false;
            for (MetricComputation computation : computations) {
                ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderAggregation computer = (ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderAggregation)((Object)computation.computer);
                more |= computer.handleResult(res.columns, row, computation);
            }
            if (more) continue;
            break;
        }
        HashMap metricsValues = Maps.newHashMap();
        for (int i = 0; i < computations.size(); ++i) {
            MetricComputation computation = computations.get(i);
            ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderAggregation computer = (ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderAggregation)((Object)computation.computer);
            metricsValues.put(computation.metric, computer.getAggregate(computation));
        }
        return metricsValues;
    }

    public static class ImpalaColumnMetricsEngineRun
    extends MetricsEngineRun {
        public final String column;

        public ImpalaColumnMetricsEngineRun(String column) {
            super(MetricsEngineDesc.ImpalaColumnMetricsEngine);
            this.column = column;
        }

        public ImpalaColumnMetricsEngineRun(String column, double cost, List<MetricComputation> computations, int pass) {
            super(MetricsEngineDesc.ImpalaColumnMetricsEngine, cost, computations, pass);
            this.column = column;
        }

        @Override
        protected MetricsEngineRun subset(double cost, List<MetricComputation> computations) {
            return new ImpalaColumnMetricsEngineRun(this.column, cost, computations, this.pass);
        }

        @Override
        public boolean canMergeWith(MetricsEngineRun other) {
            return super.canMergeWith(other) && this.column.equals(((ImpalaColumnMetricsEngineRun)other).column);
        }
    }
}

