/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.probes;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.meanings.IBasicMeaningsService;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.MetricMetadata;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.probes.MetricBuilder;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.ProbeConfiguration;
import com.dataiku.dip.metrics.probes.ProbeMetadata;
import com.dataiku.dip.metrics.probes.ProbeType;
import com.google.common.collect.Lists;
import java.util.List;

public class ExternalProbeType
extends ProbeType
implements MetricBuilder {
    public static final String TYPE = "external";

    @Override
    public List<MetricComputer> getComputers(IBasicMeaningsService basicMeaningsService) {
        return Lists.newArrayList();
    }

    public ExternalProbeType() {
        this.type = TYPE;
    }

    @Override
    public List<Metric> getMetricsToCompute(Probe probe, Object object, MetricTargetType objectType, boolean forDisplay) {
        return Lists.newArrayList();
    }

    @Override
    public ProbeConfiguration buildFullConfiguration(List<SchemaColumn> column, Probe probe) {
        return null;
    }

    @Override
    public ProbeType trimForSave() {
        return new ExternalProbeType();
    }

    @Override
    public Class<? extends ProbeConfiguration> getParamsClazz() {
        return ExternalProbeConfiguration.class;
    }

    @Override
    public ProbeMetadata getMeta() {
        return new ProbeMetadata().withLevel(8).withName("External metrics");
    }

    @Override
    public boolean isUserSelectedProbe() {
        return true;
    }

    @Override
    public Metric build(String name, Type dataType, Probe probe) {
        return new ExternalMetric(name, dataType);
    }

    public static class ExternalProbeConfiguration
    implements ProbeConfiguration {
    }

    public static class ExternalMetric
    extends Metric {
        public String name;

        public ExternalMetric(String name, Type resultDataType) {
            super(ExternalProbeType.TYPE, resultDataType);
            this.name = name;
            this.id = Metric.serializeMetric(this);
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getColumn() {
            return null;
        }

        @Override
        public String getColumnInvariantId(String placeholder) {
            return this.getId();
        }

        @Override
        public MetricMetadata getMeta() {
            return new MetricMetadata().withName(this.name + " (External)");
        }

        @Override
        public Probe getMatchingProbe(List<Probe> probes) {
            return new Probe(this.getType()).withConfiguration(new ExternalProbeConfiguration()).withMeta(ProbeType.getProbeType(ExternalProbeType.TYPE).getMeta());
        }
    }

    public static class ExternalMetricSerializer
    implements Metric.MetricIdSerializer {
        @Override
        public String serializeMetric(Metric metric) {
            if (!(metric instanceof ExternalMetric)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metric.getClass().getSimpleName());
            }
            ExternalMetric externalMetric = (ExternalMetric)metric;
            return Metric.buildMetricIdFromParts(ExternalProbeType.TYPE, externalMetric.getName());
        }

        @Override
        public Metric deserializeMetric(String metricId) {
            List<String> parts = Metric.buildPartsFromMetricId(metricId);
            if (parts.size() != 2 || !parts.get(0).equals(ExternalProbeType.TYPE)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metricId);
            }
            return new ExternalMetric(parts.get(1), Type.STRING);
        }
    }
}

