/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.output;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.StorageTypeVerifier;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.output.CSVSerializer;
import com.dataiku.dip.output.StringOutputFormatter;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.RecordContext;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CSVOutputFormatter
extends StringOutputFormatter {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.csv");
    private final CSVSerializer serializer;
    private final CSVFormatConfig config;
    private final char separatorChar;
    private final char quoteChar;
    private final char escapeChar;
    private final boolean printHeaderLine;
    private final boolean prefixHeaderLineWithSharp;
    private final List<Column> headerColumns = new ArrayList<Column>();
    private Schema outputSchema;
    private RecordContext rc = new RecordContext();
    private int nbRecords = 0;
    private StorageTypeVerifier storageTypeVerifier = new StorageTypeVerifier();
    private static final char[] charactersToEscape = new char[]{'\n', '\u000b', '\f', '\r'};

    public CSVOutputFormatter(CSVFormatConfig config) {
        super(config.charset);
        this.config = config;
        this.separatorChar = config.getSeparatorChar();
        this.quoteChar = config.getQuoteChar();
        this.escapeChar = config.getEscapeChar();
        this.printHeaderLine = config.parseHeaderRow;
        this.prefixHeaderLineWithSharp = false;
        this.serializer = new CSVSerializer(config, this.rc);
    }

    private static boolean containsCharToEscape(String v, Character escape, char sep, Character quote) {
        for (char c2 : charactersToEscape) {
            if (!StringUtils.contains((String)v, (char)c2)) continue;
            return true;
        }
        return escape != null && StringUtils.contains((String)v, (char)escape.charValue()) || StringUtils.contains((String)v, (char)sep) || quote != null && StringUtils.contains((String)v, (char)quote.charValue());
    }

    private static String replaceCharToEscape(String v, char escape, Character separator) {
        v = StringUtils.replace((String)v, (String)("" + escape), (String)("" + escape + escape));
        if (separator != null) {
            v = StringUtils.replace((String)v, (String)("" + separator), (String)("" + escape + separator));
        }
        for (char c2 : charactersToEscape) {
            String sc = Character.toString(c2);
            v = StringUtils.replace((String)v, (String)sc, (String)(escape + sc));
        }
        return v;
    }

    private static String eraseCharToEscape(String v, char sep) {
        for (char c2 : charactersToEscape) {
            String sc = Character.toString(c2);
            v = StringUtils.replace((String)v, (String)sc, (String)" ");
        }
        v = StringUtils.replace((String)v, (String)("" + sep), (String)" ");
        return v;
    }

    public static void appendUNIXStyle(Writer wr, String v, char sep, char quote, Character escape) throws IOException {
        if (v != null && v.length() > 0) {
            if (CSVOutputFormatter.containsCharToEscape(v, escape, sep, Character.valueOf(quote))) {
                wr.append(quote);
                if (escape != null) {
                    String e = StringUtils.replace((String)v, (String)("" + escape), (String)("" + escape + escape));
                    e = StringUtils.replace((String)e, (String)("" + quote), (String)("" + escape + quote));
                    wr.append(e);
                } else {
                    wr.append(v);
                }
                wr.append(quote);
            } else {
                wr.append(v);
            }
        }
    }

    public static void appendEscapingOnlyStyle(Writer wr, String v, char sep, Character escape) throws IOException {
        if (v != null && v.length() > 0 && escape != null) {
            if (CSVOutputFormatter.containsCharToEscape(v, escape, sep, null)) {
                String e = v;
                e = CSVOutputFormatter.replaceCharToEscape(e, escape.charValue(), Character.valueOf(sep));
                wr.append(e);
            } else {
                wr.append(v);
            }
        }
    }

    public static void appendRawStyle(Writer wr, String v, char sep) throws IOException {
        if (v != null && v.length() > 0) {
            if (CSVOutputFormatter.containsCharToEscape(v, null, sep, null)) {
                String e = v;
                e = CSVOutputFormatter.eraseCharToEscape(e, sep);
                wr.append(e);
            } else {
                wr.append(v);
            }
        }
    }

    public static void appendExcelStyle(Writer wr, String v, char sep, char quote) throws IOException {
        if (v != null && v.length() > 0) {
            if (CSVOutputFormatter.containsCharToEscape(v, null, sep, Character.valueOf(quote))) {
                wr.append(quote);
                String doubleQuoted = StringUtils.replace((String)v, (String)("" + quote), (String)("" + quote + quote));
                wr.append(doubleQuoted);
                wr.append(quote);
            } else {
                wr.append(v);
            }
        }
    }

    public void setWarningsContext(WarningsContext warningsContext) {
        super.setWarningsContext(warningsContext);
        this.serializer.setWarningsContext(warningsContext);
    }

    public void setOutputSchema(Schema schema) {
        this.outputSchema = schema;
    }

    public void header(ColumnFactory cf, Writer sb) throws IOException {
        if (this.printHeaderLine && this.prefixHeaderLineWithSharp) {
            sb.append("# ");
        }
        if (this.outputSchema != null) {
            for (int i = 0; i < this.outputSchema.getColumns().size(); ++i) {
                String name = ((SchemaColumn)this.outputSchema.getColumns().get(i)).getName();
                this.headerColumns.add(cf.column(name));
                if (!this.printHeaderLine) continue;
                if (i > 0) {
                    sb.append(this.separatorChar);
                }
                this.appendFieldToLine(sb, name);
            }
        } else {
            int i = 0;
            for (Column c2 : cf.columns()) {
                this.headerColumns.add(c2);
                if (i++ > 0 && this.printHeaderLine) {
                    sb.append(this.separatorChar);
                }
                if (!this.printHeaderLine) continue;
                this.appendFieldToLine(sb, c2.getName());
            }
        }
        if (this.printHeaderLine) {
            sb.append('\n');
        }
    }

    public void format(Row row, ColumnFactory cf, Writer sb) throws IOException {
        ++this.nbRecords;
        this.rc.setLine((long)this.nbRecords);
        int i = 0;
        for (Column c2 : this.headerColumns) {
            String v = row.get(c2);
            SchemaColumn sc = this.outputSchema != null ? (SchemaColumn)this.outputSchema.getColumns().get(i) : new SchemaColumn().withType(Type.STRING);
            if (i++ > 0) {
                sb.append(this.separatorChar);
            }
            if (!sc.getType().isPrimitive()) {
                v = this.serializer.writeComplex(v, sc);
                v = this.storageTypeVerifier.verify(v, sc, this.config.writeDataTypeMismatchBehavior, this.warningsContext, this.rc, true);
            } else if (sc.getType() == Type.DATE) {
                v = this.storageTypeVerifier.verify(v, sc, this.config.writeDataTypeMismatchBehavior, this.warningsContext, this.rc, true);
                v = this.serializer.writeDate(v, sc);
            } else if (sc.getType() == Type.DATEONLY) {
                v = this.storageTypeVerifier.verify(v, sc, this.config.writeDataTypeMismatchBehavior, this.warningsContext, this.rc, true);
                v = this.serializer.writeDateonly(v, sc);
            } else if (sc.getType() == Type.BOOLEAN) {
                v = this.serializer.writeBoolean(v, sc);
                v = this.storageTypeVerifier.verify(v, sc, this.config.writeDataTypeMismatchBehavior, this.warningsContext, this.rc, true);
            } else if (sc.getType() == Type.DOUBLE || sc.getType() == Type.FLOAT) {
                v = this.serializer.writeDouble(v, sc);
                v = this.storageTypeVerifier.verify(v, sc, this.config.writeDataTypeMismatchBehavior, this.warningsContext, this.rc, true);
            } else {
                v = this.storageTypeVerifier.verify(v, sc, this.config.writeDataTypeMismatchBehavior, this.warningsContext, this.rc, true);
            }
            this.appendFieldToLine(sb, v);
        }
        sb.append('\n');
    }

    private void appendFieldToLine(Writer sb, String v) throws IOException {
        switch (this.config.style) {
            case ESCAPE_ONLY_NO_QUOTE: {
                CSVOutputFormatter.appendEscapingOnlyStyle(sb, v, this.separatorChar, Character.valueOf(this.escapeChar));
                break;
            }
            case NO_ESCAPE_NO_QUOTE: {
                CSVOutputFormatter.appendRawStyle(sb, v, this.separatorChar);
                break;
            }
            case EXCEL: {
                CSVOutputFormatter.appendExcelStyle(sb, v, this.separatorChar, this.quoteChar);
                break;
            }
            case UNIX: {
                CSVOutputFormatter.appendUNIXStyle(sb, v, this.separatorChar, this.quoteChar, Character.valueOf(this.escapeChar));
            }
        }
    }

    public void footer(ColumnFactory cf, Writer sb) throws IOException {
    }

    public void cancel(OutputStream os) throws Exception {
    }
}

