/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.aggregators;

import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.pivot.backend.dss.AxisHandler;
import com.dataiku.dip.pivot.backend.dss.DataTensor;
import com.dataiku.dip.pivot.backend.dss.LongDataList;
import com.dataiku.dip.pivot.backend.dss.LongDataTensor;
import com.dataiku.dip.pivot.backend.dss.aggregators.AbstractAggregator;
import com.dataiku.dip.pivot.backend.dss.aggregators.GenericAggregator;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorRequest;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.variables.VariablesContext;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.Evaluable;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.expr.WrappedVariables;
import com.google.refine.grel.ast.FunctionCallExpr;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class EvaluateAggregator
extends GenericAggregator<Object> {
    private final AbstractAggregator<?> baseAggregator;
    private final Evaluable evaluable;
    private final boolean formulaValidation;
    public Map<String, ColumnBlock> columnsBlock;
    private final Properties currentRowBindings = new Properties();

    public EvaluateAggregator(AbstractAggregator<?> baseAggregator, Evaluable evaluable, FunctionCallExpr parentReference, VariablesContext variablesContext, boolean formulaValidation) {
        super(baseAggregator.req, null);
        this.baseAggregator = baseAggregator;
        this.evaluable = evaluable;
        this.formulaValidation = formulaValidation;
        this.parentReference = parentReference;
        if (variablesContext != null) {
            this.currentRowBindings.put("variables", new WrappedVariables(variablesContext));
        }
    }

    @Override
    public void handleBlock(ColumnBlock column, int start, int rows, int[] coords, int[] bins, boolean[] filters, boolean fillAxes) throws IOException {
        for (int row = start; row < rows; ++row) {
            int[] destBin;
            if (filters != null && !filters[row] || (destBin = this.extractDestBin(row, coords, bins)) == null) continue;
            this.currentRowBindings.put("UDAF_BINDING_KEY", (Object)row);
            Object result = this.evaluable.evaluate(this.currentRowBindings);
            boolean isInError = ExpressionUtils.isError(result);
            if (isInError && this.formulaValidation) {
                throw new RuntimeException(((EvalError)result).message);
            }
            if (result instanceof Number) {
                this.baseAggregator.handle(((Number)result).doubleValue(), destBin, fillAxes);
                continue;
            }
            if (result == null || isInError) {
                this.baseAggregator.handle(Double.NaN, destBin, fillAxes);
                continue;
            }
            this.baseAggregator.handle(result, destBin, fillAxes);
        }
    }

    @Override
    public void end() throws IOException {
        this.baseAggregator.end();
    }

    @Override
    public AbstractAggregator.OtherCategoryProperties<Object> retrieveOthersCategoryProperties(AxisHandler.Axis axis) {
        AbstractAggregator.OtherCategoryProperties<?> ocp = this.baseAggregator.retrieveOthersCategoryProperties(axis);
        AbstractAggregator.OtherCategoryProperties<Object> ocpO = new AbstractAggregator.OtherCategoryProperties<Object>();
        ocpO.nonNullCountOfOthersColumn = ocp.nonNullCountOfOthersColumn;
        ocpO.aggrOfOthersColumn = ocp.aggrOfOthersColumn;
        return ocpO;
    }

    @Override
    public void close() throws Exception {
        this.baseAggregator.close();
    }

    @Override
    public DataTensor<Object> getMergeDT() {
        return this.baseAggregator.getMergeDT();
    }

    @Override
    public DataTensor<Object> getOutDT() {
        return this.baseAggregator.getOutDT();
    }

    @Override
    public boolean mergeTensorAndAxes(PivotTableTensorRequest request, int[] origCoordinates, int[] targetCoordinates, AxisHandler.Axis[] axes) throws IOException {
        return this.baseAggregator.mergeTensorAndAxes(request, origCoordinates, targetCoordinates, axes);
    }

    @Override
    public void mergeEnd(AxisHandler.Axis[] axes, LongDataTensor countTensor) throws IOException {
        this.baseAggregator.mergeEnd(axes, countTensor);
    }

    @Override
    public Object getValue(int loc, LongDataList countList) {
        return this.baseAggregator.getValue(loc, countList);
    }

    @Override
    public Object getValue(int loc, long[] counts) {
        return this.baseAggregator.getValue(loc, counts);
    }

    @Override
    public Object getValue(int loc, long[] counts, boolean toRealType) {
        return this.baseAggregator.getValue(loc, counts, toRealType);
    }

    @Override
    public Object getAxisValue(int i, int j, long[][] counts) {
        return this.baseAggregator.getAxisValue(i, j, this.baseAggregator.getOutDT().axesNonNullCounts);
    }

    public void updateBindings() {
        this.currentRowBindings.put("UDAF_COLUMNS_BLOCKS_KEY", this.columnsBlock);
    }

    @Override
    public void postProcessEndPhase2() {
        this.baseAggregator.postProcessEndPhase2();
    }

    @Override
    public void initMerge() {
        this.baseAggregator.initMerge();
    }

    @Override
    public void initMerge(int[] axisLengths) {
        this.baseAggregator.initMerge(axisLengths);
    }

    @Override
    public void initMerge(int axisLength) {
        this.baseAggregator.initMerge(axisLength);
    }

    @Override
    public Object mergeValues(Object v1, Object v2) {
        throw new NotImplementedException("Not able to merge values in Evaluate");
    }
}

