/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.queries;

import com.dataiku.dip.pivot.UnsupportedOperation;
import com.dataiku.dip.pivot.backend.dss.PivotUtils;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.AxisSortPrune;
import com.dataiku.dip.pivot.backend.model.DateAxisParams;
import com.dataiku.dip.pivot.backend.model.NumericalAxisParams;
import com.dataiku.dip.pivot.backend.sql.builders.BasicStatsBuilder;
import com.dataiku.dip.pivot.backend.sql.queries.ColumnMapper;
import com.dataiku.dip.pivot.backend.sql.utils.BinUtils;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.sql.NetezzaSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.TeradataSQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import java.util.List;
import java.util.Locale;
import org.python.icu.text.DecimalFormat;
import org.python.icu.text.NumberFormat;

public class BinningToSQL {
    private final ColumnMapper colMapping;
    private final SQLDialect dialect;

    public BinningToSQL(SQLDialect dialect, ColumnMapper colMapping) {
        this.colMapping = colMapping;
        this.dialect = dialect;
    }

    public ColumnMapper.TypedExpr binningExpression(ColumnMapper.TypedExpr sourceExpr, ChartFilter.DateFilterType dateFilterType, ChartFilter.DateFilterPart dateFilterPart) {
        AxisDef def = new AxisDef();
        def.type = AxisDef.Type.DATE;
        def.column = null;
        def.sortPrune = new AxisSortPrune();
        def.sortPrune.sortType = AxisSortPrune.SortType.NATURAL;
        def.sortPrune.maxValues = Long.MAX_VALUE;
        def.dateParams = new DateAxisParams();
        def.dateParams.mode = BinningToSQL.toBinningMode(dateFilterType, dateFilterPart);
        return this.binningExpression(sourceExpr, def, null);
    }

    public static DateAxisParams.BinningMode toBinningMode(ChartFilter.DateFilterType dateFilterType, ChartFilter.DateFilterPart dateFilterPart) {
        if (dateFilterType == null) {
            throw new IllegalArgumentException("Unsupported date facet mode (dateFilterType=null)");
        }
        if (dateFilterType != ChartFilter.DateFilterType.PART) {
            throw new UnsupportedOperation("Unsupported date facet mode (dateFilterType=" + String.valueOf((Object)dateFilterType) + ")");
        }
        return switch (dateFilterPart) {
            case ChartFilter.DateFilterPart.DAY_OF_MONTH -> DateAxisParams.BinningMode.DAY_OF_MONTH;
            case ChartFilter.DateFilterPart.DAY_OF_WEEK -> DateAxisParams.BinningMode.DAY_OF_WEEK;
            case ChartFilter.DateFilterPart.HOUR_OF_DAY -> DateAxisParams.BinningMode.HOUR_OF_DAY;
            case ChartFilter.DateFilterPart.MONTH_OF_YEAR -> DateAxisParams.BinningMode.MONTH_OF_YEAR;
            case ChartFilter.DateFilterPart.QUARTER_OF_YEAR -> DateAxisParams.BinningMode.QUARTER_OF_YEAR;
            case ChartFilter.DateFilterPart.WEEK_OF_YEAR -> DateAxisParams.BinningMode.WEEK_OF_YEAR;
            case ChartFilter.DateFilterPart.YEAR -> DateAxisParams.BinningMode.YEAR;
            default -> throw new UnsupportedOperation("Unsupported date facet mode (dateFilterPart=" + String.valueOf((Object)dateFilterPart) + ")");
        };
    }

    public ColumnMapper.TypedExpr binningExpression(ColumnMapper.TypedExpr sourceExpr, AxisDef axis, BasicStatsBuilder.BasicStats stats) {
        ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
        if (axis.type == AxisDef.Type.NUMERICAL) {
            if (axis.numParams.mode == NumericalAxisParams.BinningMode.NONE) {
                return this.colMapping.getAs(sourceExpr, ColumnMapper.ExprType.NON_NULL_NUMBER);
            }
            if (axis.numParams.mode == NumericalAxisParams.BinningMode.FIXED_NB) {
                String binExpr;
                BasicStatsBuilder.ColStats minmax = stats.columnStats.get(axis.column);
                if (minmax == null) {
                    throw new RuntimeException("A min-max pass is required before building an axis with fixed number of bins");
                }
                BinUtils.HistogramParams histogramParams = BinUtils.getHistogramParams(axis.numParams.niceBounds, axis.numParams.nbBins, minmax.minValue, minmax.maxValue);
                if (Double.isNaN(histogramParams.fixedMin) || Double.isNaN(histogramParams.fixedMax)) {
                    histogramParams.fixedMin = 0.0;
                    histogramParams.fixedMax = 1.0;
                }
                if (histogramParams.fixedMin == histogramParams.fixedMax) {
                    histogramParams.fixedMin -= 1.0;
                    histogramParams.fixedMax += 1.0;
                }
                ColumnMapper.TypedExpr columnExpr = this.colMapping.getAs(sourceExpr, ColumnMapper.ExprType.NUMBER);
                double scale = (double)axis.numParams.nbBins / (histogramParams.fixedMax - histogramParams.fixedMin);
                if (this.dialect instanceof TeradataSQLDialect) {
                    DecimalFormat teradataSucks = (DecimalFormat)NumberFormat.getScientificInstance((Locale)Locale.ENGLISH);
                    teradataSucks.setMaximumFractionDigits(14);
                    binExpr = "FLOOR(cast(" + teradataSucks.format(scale) + " as double precision)*(" + columnExpr.expr;
                } else {
                    binExpr = "FLOOR(" + scale + "*(" + columnExpr.expr;
                }
                if (histogramParams.fixedMin != 0.0) {
                    binExpr = binExpr + "-(" + histogramParams.fixedMin + ")";
                }
                binExpr = binExpr + "))";
                if (this.dialect instanceof NetezzaSQLDialect) {
                    String nbBins = "" + (axis.numParams.nbBins - 1);
                    String expr = String.format("(CASE WHEN %s < %s THEN %s ELSE %s END)", binExpr, nbBins, binExpr, nbBins);
                    return new ColumnMapper.TypedExpr(expr, ColumnMapper.ExprType.NUMBER);
                }
                String leasted = ef.expr(binExpr).castToInt().least(ef.cst(axis.numParams.nbBins - 1).castToInt()).toSQL(this.dialect);
                return new ColumnMapper.TypedExpr(leasted, ColumnMapper.ExprType.NUMBER);
            }
            if (axis.numParams.mode == NumericalAxisParams.BinningMode.FIXED_SIZE) {
                return new ColumnMapper.TypedExpr("FLOOR((" + this.colMapping.getAs((ColumnMapper.TypedExpr)sourceExpr, (ColumnMapper.ExprType)ColumnMapper.ExprType.NUMBER).expr + ")/" + axis.numParams.binSize + ")", ColumnMapper.ExprType.NUMBER);
            }
            if (axis.numParams.mode == NumericalAxisParams.BinningMode.CUSTOM) {
                List<Double> customBins = PivotUtils.getValidatedCustomBins(axis);
                StringBuilder caseExpr = new StringBuilder("CASE ");
                ColumnMapper.TypedExpr columnExpr = this.colMapping.getAs(sourceExpr, ColumnMapper.ExprType.NUMBER);
                String col = columnExpr.expr;
                caseExpr.append("WHEN ").append(col).append(" < ").append(customBins.get(0)).append(" THEN 0 ");
                for (int i = 0; i < customBins.size() - 1; ++i) {
                    caseExpr.append("WHEN ").append(col).append(" >= ").append(customBins.get(i)).append(" AND ").append(col).append(" < ").append(customBins.get(i + 1)).append(" THEN ").append(i + 1).append(" ");
                }
                caseExpr.append("ELSE ").append(customBins.size()).append(" END");
                return new ColumnMapper.TypedExpr(caseExpr.toString(), ColumnMapper.ExprType.NUMBER);
            }
            throw new UnsupportedOperation("Unsupported binning mode");
        }
        if (axis.type == AxisDef.Type.ALPHANUM) {
            return this.colMapping.getAs(sourceExpr, ColumnMapper.ExprType.NON_NULL_STRING);
        }
        if (axis.type == AxisDef.Type.DATE) {
            return axis.dateParams.mode.getDateBinner().binningSqlExpression(sourceExpr.expr, this.dialect);
        }
        throw new UnsupportedOperation("Unsupported axis type");
    }

    public String sortingExpression(String sourceExpr, AxisDef axis) {
        return null;
    }
}

