/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.frontend.excel;

import com.dataiku.dip.pivot.UnsupportedOperation;
import com.dataiku.dip.pivot.frontend.excel.CellStyler;
import com.dataiku.dip.pivot.frontend.excel.xssf.ChartUtils;
import com.dataiku.dip.pivot.frontend.excel.xssf.SheetUtils;
import com.dataiku.dip.pivot.frontend.model.ChartDef;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.CellStyle;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Workbook;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFCell;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFSheet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BaseDataSheetBuilder {
    private static final DateTimeFormatter dateFormat = DateTimeFormat.forPattern((String)"MMMM d, yyyy").withZone(DateTimeZone.UTC);
    private static final String LESS_THAN_OR_EQUAL = "\u2264";
    private static final String LESS_THAN = "<";

    public static void appendFilteringDetails(ChartDef chartDef, XSSFSheet sheet) {
        if (chartDef.filters == null || chartDef.filters.size() == 0) {
            return;
        }
        List activeFilters = chartDef.filters.stream().filter(chartFilter -> BaseDataSheetBuilder.describeFilter(chartFilter) != null).collect(Collectors.toList());
        if (activeFilters.size() == 0) {
            return;
        }
        CellStyler styler = new CellStyler((Workbook)sheet.getWorkbook());
        CellStyle titleStyle = styler.getTitleStyle();
        CellStyle headerStyle = styler.getHeaderStyle();
        int rowIdx = sheet.getLastRowNum() + 2;
        SheetUtils.writeCell(sheet, rowIdx, 0, "Filters").setCellStyle(titleStyle);
        SheetUtils.writeCell(sheet, ++rowIdx, 0, "Column").setCellStyle(headerStyle);
        SheetUtils.writeCell(sheet, rowIdx, 1, "Type").setCellStyle(headerStyle);
        SheetUtils.writeCell(sheet, rowIdx, 2, "").setCellStyle(headerStyle);
        ++rowIdx;
        for (int i = 0; i < activeFilters.size(); ++i) {
            ChartFilter chartFilter2 = (ChartFilter)activeFilters.get(i);
            boolean isLastFilter = i == activeFilters.size() - 1;
            FilterDesc desc = BaseDataSheetBuilder.describeFilter(chartFilter2);
            XSSFCell colCell = SheetUtils.writeCell(sheet, rowIdx, 0, chartFilter2.column);
            colCell.setCellStyle(styler.getValueStyle(false, true));
            XSSFCell descCell = SheetUtils.writeCell(sheet, rowIdx, 1, desc == null ? null : desc.description);
            descCell.setCellStyle(styler.getValueStyle(false, false));
            if (desc != null && desc.values != null) {
                for (int j = 0; j < desc.values.size(); ++j) {
                    boolean isLastVal;
                    boolean bl = isLastVal = j == desc.values.size() - 1;
                    if (j != 0) {
                        SheetUtils.writeCell(sheet, rowIdx, 0, "").setCellStyle(styler.getValueStyle(isLastVal && isLastFilter, true));
                        SheetUtils.writeCell(sheet, rowIdx, 1, "").setCellStyle(styler.getValueStyle(isLastVal && isLastFilter, false));
                    }
                    SheetUtils.writeCell(sheet, rowIdx, 2, ChartUtils.labelify(desc.values.get(j))).setCellStyle(styler.getValueStyle(isLastVal && isLastFilter, false));
                    ++rowIdx;
                }
                if (desc.values.size() != 1) continue;
                colCell.setCellStyle(styler.getValueStyle(isLastFilter, true));
                descCell.setCellStyle(styler.getValueStyle(isLastFilter, false));
                continue;
            }
            SheetUtils.writeCell(sheet, rowIdx, 2, "").setCellStyle(styler.getValueStyle(isLastFilter, false));
            colCell.setCellStyle(styler.getValueStyle(isLastFilter, true));
            descCell.setCellStyle(styler.getValueStyle(isLastFilter, false));
            ++rowIdx;
        }
    }

    private static FilterDesc describeFilter(ChartFilter rf) {
        List<String> excludedVals = BaseDataSheetBuilder.listify(rf.excludedValues);
        switch (rf.filterType) {
            case ALPHANUM_FACET: 
            case INTERACTIVE_DATE_FACET: 
            case DATE_FACET: 
            case NUMERICAL_FACET: {
                switch (rf.columnType) {
                    case ALPHANUM: {
                        if (rf.excludedValues == null) {
                            return null;
                        }
                        if (excludedVals.size() == 0) {
                            return null;
                        }
                        return new FilterDesc("Excluded values", excludedVals);
                    }
                    case NUMERICAL: {
                        if (rf.maxValue == null || rf.minValue == null) {
                            return null;
                        }
                        ArrayList<String> out = new ArrayList<String>();
                        out.add(rf.minValue + " \u2264 " + rf.column);
                        out.add(rf.column + " < " + rf.maxValue);
                        return new FilterDesc("Numerical range", out);
                    }
                    case DATE: {
                        if (rf.dateFilterType == ChartFilter.DateFilterType.RANGE) {
                            if (rf.maxValue == null && rf.minValue == null) {
                                return null;
                            }
                            ArrayList<String> out = new ArrayList<String>();
                            if (rf.minValue != null) {
                                out.add(BaseDataSheetBuilder.formatDate(rf.minValue) + " \u2264 " + rf.column);
                            }
                            if (rf.maxValue != null) {
                                out.add(rf.column + " < " + BaseDataSheetBuilder.formatDate(rf.maxValue));
                            }
                            return new FilterDesc("Date range", out);
                        }
                        if (excludedVals.size() == 0) {
                            return null;
                        }
                        switch (rf.dateFilterPart) {
                            case DAY_OF_MONTH: {
                                return new FilterDesc("Excluded days of month", excludedVals);
                            }
                            case DAY_OF_WEEK: {
                                return new FilterDesc("Excluded days of week", excludedVals);
                            }
                            case HOUR_OF_DAY: {
                                return new FilterDesc("Excluded hours of day", excludedVals);
                            }
                            case MONTH_OF_YEAR: {
                                return new FilterDesc("Excluded month of year", excludedVals);
                            }
                            case QUARTER_OF_YEAR: {
                                return new FilterDesc("Excluded quarter of year", excludedVals);
                            }
                            case WEEK_OF_YEAR: {
                                return new FilterDesc("Excluded weeks of year", excludedVals);
                            }
                            case YEAR: {
                                return new FilterDesc("Excluded years", excludedVals);
                            }
                        }
                        throw new UnsupportedOperation("Unable to describe date filter type : " + String.valueOf((Object)rf.dateFilterPart));
                    }
                }
                throw new UnsupportedOperation("Unable to describe filter type : " + String.valueOf((Object)rf.columnType));
            }
            case EXPLICIT: {
                StringBuilder explicitExcluded = new StringBuilder();
                if (rf.explicitConditions == null || rf.explicitConditions.size() == 0) {
                    return null;
                }
                for (int i = 0; i < rf.explicitConditions.size(); ++i) {
                    ChartFilter.ExplicitCondition ec = rf.explicitConditions.get(i);
                    if (i == 0 && rf.explicitConditions.size() > 1) {
                        explicitExcluded.append("[");
                    }
                    explicitExcluded.append(ec.column).append(": ").append(ec.singleValue);
                    if (i == 0 && rf.explicitConditions.size() > 1) {
                        explicitExcluded.append(", ");
                        continue;
                    }
                    if (i != rf.explicitConditions.size() - 1 || rf.explicitConditions.size() <= 1) continue;
                    explicitExcluded.append("]");
                }
                ArrayList<String> explicitExcludedVals = new ArrayList<String>();
                explicitExcludedVals.add(explicitExcluded.toString());
                return new FilterDesc("Explicit excluded values :", explicitExcludedVals);
            }
        }
        throw new Error("unreachable");
    }

    private static List<String> listify(Map<String, Boolean> values) {
        if (values == null) {
            return Collections.emptyList();
        }
        return values.entrySet().stream().filter(Map.Entry::getValue).map(entry -> {
            String s = (String)entry.getKey();
            if ("".endsWith(s)) {
                s = "(No value)";
            }
            return s;
        }).collect(Collectors.toList());
    }

    private static String formatDate(double ts) {
        return dateFormat.print((long)ts);
    }

    private static class FilterDesc {
        public final List<String> values;
        public final String description;

        public FilterDesc(String description, List<String> values) {
            this.description = description;
            this.values = values;
        }
    }
}

