/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.impala;

import com.dataiku.dip.connections.ImpalaConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.ActivityAbortedException;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.RecipeRunnerWithPayload;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopItemsIterable;
import com.dataiku.dip.datasets.fs.HDFSDatasetHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hive.HiveMetastoreSynchronizer;
import com.dataiku.dip.hive.HiveMetastoreSynchronizerFactory;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.impala.ImpalaConfigurator;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.input.formats.parquet.ParquetFormatMeta;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.recipes.InitializableAbortableRecipeRunner;
import com.dataiku.dip.recipes.code.hive.HiveQLQueryRecipeUtils;
import com.dataiku.dip.recipes.code.impala.ImpalaRecipeExecutionUtils;
import com.dataiku.dip.recipes.code.sql.AbstractSQLQueryLikeRecipeRunner;
import com.dataiku.dip.recipes.code.sql.SQLQueryRecipeUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.ImpalaSQLDialect;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractImpalaRecipeRunner
extends AbstractSQLQueryLikeRecipeRunner
implements FlowRunnable,
InitializableAbortableRecipeRunner,
RecipeRunnerWithPayload {
    @Autowired
    protected JobAuthCtxService authCtxService;
    protected RecipeRunnableSubgraph subgraph;
    protected FlowRecipe recipe;
    protected Dataset outputDataset;
    protected String code;
    protected QueryBunch queryBunch;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.impala");

    public AbstractImpalaRecipeRunner(JobActivity activity) {
        super(((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe().getProjectKey());
        this.activity = activity;
        this.subgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        this.recipe = this.subgraph.getRecipe();
    }

    @Override
    public void setPayload(String payload) {
        this.code = payload;
    }

    protected abstract QueryBunch getQueryBunch(ImpalaSQLDialect var1) throws Exception;

    protected abstract boolean getStreamMode();

    @Override
    public synchronized void init() throws Exception {
        if (this.abortNotified) {
            throw new ActivityAbortedException();
        }
        AuthCtx authCtx = this.authCtxService.getAuthCtx();
        ImpalaSQLDialect dialect = new ImpalaSQLDialect();
        this.mainConnection = HiveQLQueryRecipeUtils.getMainConnection(this.authCtxService.getAuthCtx(), this.subgraph);
        Preconditions.checkArgument((this.subgraph.getTargets().size() == 1 ? 1 : 0) != 0, (Object)"A Impala query recipe can have only one output");
        this.queryBunch = this.getQueryBunch(dialect);
        if (this.queryBunch.query == null) {
            throw new Error("Could not find SQL query for " + this.recipe.getName());
        }
        this.queryBunch.optionalPreQueries = this.queryBunch.optionalPreQueries.stream().map(q -> SQLQueryRecipeUtils.substituteAllAndStripCommentsUnchecked(authCtx, this.recipe.getProjectKey(), this.subgraph, q, dialect, false)).collect(Collectors.toList());
        this.queryBunch.preQueries = this.queryBunch.preQueries.stream().map(q -> SQLQueryRecipeUtils.substituteAllAndStripCommentsUnchecked(authCtx, this.recipe.getProjectKey(), this.subgraph, q, dialect, false)).collect(Collectors.toList());
        this.queryBunch.postQueries = this.queryBunch.postQueries.stream().map(q -> SQLQueryRecipeUtils.substituteAllAndStripCommentsUnchecked(authCtx, this.recipe.getProjectKey(), this.subgraph, q, dialect, false)).collect(Collectors.toList());
        this.queryBunch.query = SQLQueryRecipeUtils.substituteAllAndStripComments(this.authCtxService.getAuthCtx(), this.recipe.getProjectKey(), this.subgraph, this.queryBunch.query, new ImpalaSQLDialect(), false);
        this.outputDataset = this.subgraph.getSingleTargetDataset().getMandatory(this.datasetsDAO);
        for (FlowDataset source : this.subgraph.getSourceDatasets()) {
            Dataset sourceDS = source.getMandatory(this.datasetsDAO);
            if (DatasetInspector.isHive(sourceDS) || !sourceDS.getFormatType().equals(ParquetFormatMeta.META.getType()) || sourceDS.getFormatParamsAs(ParquetFormatConfig.class).parquetCompressionMethod != ParquetFormatConfig.CompressionMethod.LZO) continue;
            throw new Exception("Impala cannot read Lzo-compressed parquet files");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        try {
            FlowDataset target = this.subgraph.getTargetsDatasets().get(0);
            Dataset targetDataset = target.getMandatory(this.datasetsDAO);
            Partition targetPartition = this.subgraph.getTargetPartition(this.subgraph.getTargets().get(0));
            this.mainConnection = "mainconnectiondoesnotmatterforimpala";
            boolean runInStreamMode = this.getStreamMode();
            if (HiveQLQueryRecipeUtils.runsInSQLMode(this.authCtxService.getAuthCtx(), this.mainConnection, this.outputDataset, this.queryBunch.query) == null && !runInStreamMode) {
                SQLConnectionProvider.SQLConnectionData connData = this.getSqlConnectionData(this.outputDataset);
                logger.info((Object)"Running the Impala query recipe in full-SQL mode");
                this.runFullSQL(targetDataset, targetPartition, connData);
            } else {
                FlowDataset firstSource = this.subgraph.getSourceDatasets().get(0);
                Dataset firstSourceDataset = firstSource.getMandatory(this.datasetsDAO);
                SQLConnectionProvider.SQLConnectionData connData = this.getSqlConnectionData(firstSourceDataset);
                logger.info((Object)"Running the Impala query recipe in stream mode");
                this.runRegular(targetDataset, targetPartition, connData);
            }
        }
        finally {
            AbstractImpalaRecipeRunner abstractImpalaRecipeRunner = this;
            synchronized (abstractImpalaRecipeRunner) {
                this.runTerminated = true;
                this.notifyAll();
            }
        }
    }

    protected SQLConnectionProvider.SQLConnectionData getSqlConnectionData(Dataset outputDataset) throws IOException, DKUSecurityException, SQLException {
        String outputImpalaDb = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(outputDataset).getSchemaNullIfBlank();
        ImpalaConnection connection = ImpalaConfigurator.configureConnectionForDatabase(this.authCtxService.getAuthCtx(), outputImpalaDb);
        return connection.getConnectionData_NT(this.authCtxService.getAuthCtx(), this.recipe.getProjectKey());
    }

    private void runFullSQL(Dataset targetDataset, Partition targetPartition, SQLConnectionProvider.SQLConnectionData connData) throws Exception {
        Output.WriteMode writeMode = this.recipe.getModel().getSingleOutput("main").getWriteMode();
        this.initializeTargetTable(targetDataset, targetPartition, writeMode);
        String transformedQuery = this.prepareMainQuery(this.queryBunch.query, targetDataset, targetPartition);
        transformedQuery = SQLQueryRecipeUtils.substituteAllAndStripComments(this.authCtxService.getAuthCtx(), this.recipe.getProjectKey(), this.subgraph, transformedQuery, new ImpalaSQLDialect(), false);
        try (SQLConnectionProvider.SQLConnectionWrapper conn = SQLConnectionProvider.newConnection(connData, this.authCtxService.getAuthCtx(), this.recipeProjectKey);){
            ImpalaRecipeExecutionUtils.executeStatementsChainInImpala(conn, this.outputDataset, transformedQuery, this.queryBunch.optionalPreQueries, this.queryBunch.preQueries, this.queryBunch.postQueries, this);
        }
        catch (SQLException e) {
            logger.error((Object)"Query failed");
            throw e;
        }
    }

    protected abstract String prepareMainQuery(String var1, Dataset var2, Partition var3) throws IOException;

    protected void initializeTargetTable(Dataset targetDataset, Partition targetPartition, Output.WriteMode writeMode) throws Exception {
        try (HiveMetastoreSynchronizer sync = HiveMetastoreSynchronizerFactory.getSynchronizer(this.authCtxService.getAuthCtx());){
            if (writeMode == Output.WriteMode.OVERWRITE) {
                try (HDFSDatasetHandler handler = (HDFSDatasetHandler)DatasetHandlerFactory.build(this.authCtxService.getAuthCtx(), targetDataset);){
                    handler.clearPartitions(Lists.newArrayList((Object[])new Partition[]{targetPartition}));
                }
                if (targetDataset.getPartitioningSchema().isPartitioned()) {
                    sync.dropPartitionIfExistsNoFail(targetDataset, targetPartition);
                } else {
                    sync.dropTableIfExists(targetDataset);
                }
            }
            sync.synchronizeOneDatasetPartition(targetDataset, targetPartition, false, HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason.PRESYNCHRONIZE_WRITE_BY_IMPALA_TARGET, this.activity.warnContext, false);
        }
    }

    private void runRegular(Dataset targetDataset, Partition targetPartition, SQLConnectionProvider.SQLConnectionData connData) throws Exception {
        this.runRegularToDataset(this.authCtxService.getAuthCtx(), targetDataset, targetPartition, connData, this.queryBunch, new VariablesExpansionLoopItemsIterable(this.authCtxService.getAuthCtx(), this.recipeProjectKey, null));
    }
}

