/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.merge_folder;

import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.cde.ContainerizedDSSEngineAble;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.consistency.CDECompatibilityCheckerService;
import com.dataiku.dip.recipes.merge_folder.ContainerizedMergeFolderRecipeExecutor;
import com.dataiku.dip.recipes.merge_folder.MergeFolderRecipeExecutor;
import com.dataiku.dip.recipes.merge_folder.MergeFolderRecipeParams;
import com.dataiku.dip.recipes.merge_folder.MergeFolderRecipeStreamExecutor;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;

public class MergeFolderRecipeRunner
implements RecipeRunner,
AbortableRecipeRunner,
ContainerizedDSSEngineAble {
    @Autowired
    private JobAuthCtxService authCtxService;
    @Autowired
    private CDECompatibilityCheckerService cdeCompatibilityCheckerService;
    private boolean isRunningInContainer;
    private MergeFolderRecipeExecutor executor;
    private final JobActivity activity;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.flow.recipe.runner.merge_folder");

    public MergeFolderRecipeRunner(JobActivity activity) {
        this.activity = activity;
        this.activity.initStatus();
    }

    @Override
    public void init() throws Exception {
        this.activity.setStatusMessage("Initializing");
        FlowRecipe recipe = ((RecipeRunnableSubgraph)this.activity.getSubgraph()).getRecipe();
        MergeFolderRecipeParams params = (MergeFolderRecipeParams)JSON.deepCopy((Object)RecipeRegistry.getParamsAs(this.activity, MergeFolderRecipeParams.class));
        this.executor = this.getExecutor(recipe, params);
    }

    @Override
    public void run() throws Exception {
        this.executor.run();
    }

    private MergeFolderRecipeExecutor getExecutor(FlowRecipe recipe, MergeFolderRecipeParams params) throws IOException, DKUSecurityException {
        JobContext.getCurrentActivitySummary().engineType = "DSS";
        ContainerExecRuntimeConfig containerConfig = this.cdeCompatibilityCheckerService.getContainerConfig(this.isRunningInContainer, this.authCtxService.getAuthCtx(), this.activity.warnContext, params.engineParams.containerSelection, recipe.getModel(), null);
        if (containerConfig != null) {
            logger.info((Object)"Run in container");
            return new ContainerizedMergeFolderRecipeExecutor(recipe, this.activity, containerConfig);
        }
        return new MergeFolderRecipeStreamExecutor(this.activity, params);
    }

    @Override
    public void setIsRunningInContainer() {
        this.isRunningInContainer = true;
    }

    @Override
    public void notifyBeforeAborting() {
        this.executor.notifyBeforeAborting();
    }
}

