/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.streaming.scala;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.code.AbstractCodeBasedRecipeStatusComputer;
import com.dataiku.dip.recipes.code.CodeBasedRecipeStatus;
import com.dataiku.dip.recipes.code.scala.ScalaService;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.server.services.SingleWriteTransactionTransactionService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;

public class StreamingSparkScalaRecipeStatusComputer
extends AbstractCodeBasedRecipeStatusComputer {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ScalaService scalaService;
    @Autowired
    private GenericRecipesValidationService validationService;

    public StreamingSparkScalaRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    @Override
    public RecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) throws Exception {
        CodeBasedRecipeStatus.CodeBasedRecipeStatusRequest request = (CodeBasedRecipeStatus.CodeBasedRecipeStatusRequest)JSON.parse((String)requestData, CodeBasedRecipeStatus.CodeBasedRecipeStatusRequest.class);
        CodeBasedRecipeStatus ret = null;
        RecipeRunnableSubgraph subgraph = null;
        if (request != null) {
            SingleWriteTransactionTransactionService.DetransactionalizedCallable<RecipeRunnableSubgraph> subgraphCallable;
            try (Transaction t = this.transactionService.beginRead();){
                FlowGraph graph = new FlowGraph();
                FlowRecipe fr = graph.buildSingleRecipe(this.recipe);
                subgraphCallable = this.validationService.getValidationRunnableSubgraph(authCtx, fr, request.targetPartitionSpec);
            }
            subgraph = subgraphCallable.call_NT();
        }
        try (Transaction t = this.transactionService.beginRead();){
            authCtx.failIfNoSafeCode("validate a Spark-Scala recipe");
            ret = this.fastStatusIgnorePartitions(authCtx);
            if (ret.topLevelMessages.anyFatal()) {
                CodeBasedRecipeStatus codeBasedRecipeStatus = ret;
                return codeBasedRecipeStatus;
            }
            if (request != null) {
                this.addVariablesSubstitutionWithoutCheck(authCtx, ret, subgraph);
            }
        }
        if (request != null) {
            ScalaService.ScalaRecipeValidationResult res = this.scalaService.checkSyntaxStreaming(authCtx, this.payload, this.recipe, request.targetPartitionSpec);
            ret.topLevelMessages.mergeFrom((InfoMessage.InfoMessages)res.genericCheckResult);
        }
        return ret;
    }

    @Override
    public CodeBasedRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws IOException, DKUSecurityException {
        CodeBasedRecipeStatus ret = new CodeBasedRecipeStatus();
        this.performBasicStructureChecks(ret, authCtx);
        ret.addSingleEngine("SPARK", "Spark", "SPARK_SCALA", "Spark Scala", "Spark");
        return ret;
    }
}

