/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.rpc;

import com.dataiku.common.rpc.InternalAPIClient;
import com.dataiku.dip.remoterun.RemoteRunEnvHelper;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpDelete;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPost;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPut;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpRequestBase;
import org.apache.commons.lang.StringUtils;

public class TicketBasedIntercomAPIClient
extends InternalAPIClient {
    private final String ticket;
    private final String executionSecretId;

    public TicketBasedIntercomAPIClient(String baseURL, String serverCert, String ticket, String executionSecretId) {
        super(baseURL, serverCert, false);
        this.ticket = ticket;
        this.executionSecretId = executionSecretId;
    }

    public TicketBasedIntercomAPIClient(String baseURL, String serverCert, String ticket) {
        this(baseURL, serverCert, ticket, null);
    }

    public static TicketBasedIntercomAPIClient forLocalHost(String secret) {
        int port = Integer.parseInt(RemoteRunEnvHelper.getEnv("DKU_BACKEND_PORT"));
        return new TicketBasedIntercomAPIClient("http://127.0.0.1:" + port, null, secret);
    }

    protected HttpGet newGet(String path) {
        HttpGet get = new HttpGet(this.baseURI + "/" + path);
        get.setHeader("X-DKU-APITicket", this.ticket);
        this.setAdditionalSecrets((HttpRequestBase)get);
        this.setAdditionalHeadersInRequest((HttpRequestBase)get);
        return get;
    }

    protected HttpPost newPost(String path) {
        HttpPost post = new HttpPost(this.baseURI + "/" + path);
        post.setHeader("X-DKU-APITicket", this.ticket);
        this.setAdditionalSecrets((HttpRequestBase)post);
        this.setAdditionalHeadersInRequest((HttpRequestBase)post);
        return post;
    }

    protected HttpPut newPut(String path) {
        HttpPut post = new HttpPut(this.baseURI + "/" + path);
        post.setHeader("X-DKU-APITicket", this.ticket);
        this.setAdditionalSecrets((HttpRequestBase)post);
        this.setAdditionalHeadersInRequest((HttpRequestBase)post);
        return post;
    }

    protected HttpDelete newDelete(String path) {
        HttpDelete post = new HttpDelete(this.baseURI + "/" + path);
        post.setHeader("X-DKU-APITicket", this.ticket);
        this.setAdditionalSecrets((HttpRequestBase)post);
        this.setAdditionalHeadersInRequest((HttpRequestBase)post);
        return post;
    }

    private void setAdditionalSecrets(HttpRequestBase request) {
        if (StringUtils.isNotBlank((String)this.executionSecretId)) {
            request.setHeader("X-DKU-ExecutionSecretId", this.executionSecretId);
        }
    }
}

