/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler;

import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.scheduler.ActiveTriggerLifecycleThread;
import com.dataiku.dip.server.services.ScenarioRunsService;
import com.dataiku.dip.server.services.ScenariosTriggerService;
import com.dataiku.dip.shaker.facet.CountMap;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.mutable.MutableInt;

public class ActiveTriggersListMaintainerThread
extends Thread {
    private static final long SLOW_GET_ACTIVE_TRIGGERS_THRESHOLD_MS = 10000L;
    private final ScenariosTriggerService scenariosTriggerService;
    private final ScenarioRunsService scenarioRunsService;
    private final FutureService futureService;
    private final Map<String, ActiveTriggerLifecycleThread> activeTriggerThreads = Maps.newHashMap();
    private final Map<String, ActiveTriggerLifecycleThread> activeTriggerThreadsForQueueingInfo = Maps.newHashMap();
    private volatile boolean forceTriggerExecution;
    private volatile boolean running;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.scenario.activetriggers.thread");

    public ActiveTriggersListMaintainerThread(ScenariosTriggerService scenariosTriggerService, ScenarioRunsService scenarioRunsService, FutureService futureService) {
        this.setName("ActiveTriggersListMaintainerThread_" + this.getId());
        this.setDaemon(true);
        this.scenariosTriggerService = scenariosTriggerService;
        this.scenarioRunsService = scenarioRunsService;
        this.futureService = futureService;
        this.running = true;
    }

    public void updateList(boolean forceTriggerExecution) {
        logger.info((Object)"Interrupt to update list");
        this.forceTriggerExecution = forceTriggerExecution;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info((Object)"Starting scenario active triggers' list maintainer thread");
        while (this.running) {
            if (Thread.interrupted()) {
                logger.info((Object)"Interrupted while doing the previous loop, skip wait");
            } else {
                DKUtils.unsafeSleep((long)30000L);
            }
            Map<String, ActiveTriggerLifecycleThread> map = this.activeTriggerThreadsForQueueingInfo;
            synchronized (map) {
                this.activeTriggerThreadsForQueueingInfo.clear();
                this.activeTriggerThreadsForQueueingInfo.putAll(this.activeTriggerThreads);
            }
            boolean forceTriggerExecution = this.forceTriggerExecution;
            this.forceTriggerExecution = false;
            try {
                long start = System.currentTimeMillis();
                List<ScenariosTriggerService.ActiveTrigger> activeTriggers = this.scenariosTriggerService.getActiveTriggers_NT();
                long end = System.currentTimeMillis();
                if (logger.isTraceEnabled() || end - start > 10000L) {
                    logger.info((Object)("Done listing active triggers, " + activeTriggers.size() + " found in " + (end - start) + " ms"));
                }
                DSSMetrics.setSettableLongGauge((String)"dku.scenarios.activeTriggers.global", (long)activeTriggers.size());
                CountMap<String> typesMap = new CountMap<String>();
                CountMap<String> usersMap = new CountMap<String>();
                for (ScenariosTriggerService.ActiveTrigger activeTrigger : activeTriggers) {
                    typesMap.inc(activeTrigger.trigger.type);
                    usersMap.inc(activeTrigger.runAsUser.getIdentifier());
                }
                for (Map.Entry entry : typesMap) {
                    DSSMetrics.setSettableLongGauge((String)("dku.scenarios.activeTriggers.byType." + (String)entry.getKey()), (long)((MutableInt)entry.getValue()).longValue());
                }
                for (Map.Entry entry : usersMap) {
                    DSSMetrics.setSettableLongGauge((String)("dku.scenarios.activeTriggers.byUser." + (String)entry.getKey()), (long)((MutableInt)entry.getValue()).longValue());
                }
                HashSet toCreate = Sets.newHashSet();
                HashSet toRemove = Sets.newHashSet(this.activeTriggerThreads.keySet());
                for (ScenariosTriggerService.ActiveTrigger activeTrigger : activeTriggers) {
                    ActiveTriggerLifecycleThread existingThread = this.activeTriggerThreads.get(activeTrigger.id());
                    if (existingThread == null) {
                        toCreate.add(activeTrigger);
                        continue;
                    }
                    if (!existingThread.hasSameDefinition(activeTrigger)) {
                        toCreate.add(activeTrigger);
                        continue;
                    }
                    if (existingThread.hasCrashed()) {
                        toCreate.add(activeTrigger);
                        continue;
                    }
                    toRemove.remove(activeTrigger.id());
                    if (!forceTriggerExecution) continue;
                    existingThread.forceExecution(true);
                }
                if (toRemove.size() != 0 || toCreate.size() != 0) {
                    logger.info((Object)("Found " + activeTriggers.size() + " active triggers to evaluate, toRemove=" + toRemove.size() + " toCreate=" + toCreate.size() + " current=" + this.activeTriggerThreads.size()));
                }
                for (String string : toRemove) {
                    this.activeTriggerThreads.get(string).invalidate();
                    this.activeTriggerThreads.remove(string);
                }
                for (ScenariosTriggerService.ActiveTrigger activeTrigger : toCreate) {
                    String activeTriggerId = activeTrigger.id();
                    if (this.activeTriggerThreads.containsKey(activeTriggerId)) {
                        logger.warn((Object)("Duplicate trigger id '" + activeTriggerId + "', killing previous thread"));
                        this.activeTriggerThreads.get(activeTriggerId).invalidate();
                    }
                    ActiveTriggerLifecycleThread thread = new ActiveTriggerLifecycleThread(activeTrigger, this.scenariosTriggerService, this.scenarioRunsService, this.futureService);
                    if (forceTriggerExecution) {
                        thread.forceExecution(false);
                    }
                    thread.start();
                    this.activeTriggerThreads.put(activeTrigger.id(), thread);
                }
            }
            catch (Throwable e) {
                logger.error((Object)"Error listing active scenarios triggers", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ActiveTriggerLifecycleThread.QueueingInfo> getQueueingInfo() {
        HashMap ret = Maps.newHashMap();
        Map<String, ActiveTriggerLifecycleThread> map = this.activeTriggerThreadsForQueueingInfo;
        synchronized (map) {
            for (Map.Entry<String, ActiveTriggerLifecycleThread> e : this.activeTriggerThreadsForQueueingInfo.entrySet()) {
                ret.put(e.getKey(), e.getValue().getQueueingInfo());
            }
        }
        return ret;
    }

    public void stopGracefully() throws InterruptedException {
        logger.info((Object)"Stopping scenario active triggers' list maintainer thread");
        this.running = false;
        this.interrupt();
        this.join();
        for (ActiveTriggerLifecycleThread lifecycleThread : this.activeTriggerThreads.values()) {
            lifecycleThread.stopGracefully();
        }
        logger.info((Object)"Done stopping scenario active triggers' list maintainer thread");
    }
}

