/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.reports;

import com.dataiku.dip.scheduler.reports.DistillationUnit;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.server.notifications.VariableLookup;
import java.util.HashMap;
import java.util.Map;

public class FirstItemDistillation
implements DistillationUnit {
    private final Class<? extends ReportItem> reportItemClazz;
    private final ReportItem.Outcome outcome;
    private ReportItem first;
    private String prefix;

    public FirstItemDistillation(Class<? extends ReportItem> reportItemClazz, ReportItem.Outcome outcome, String variablePrefix) {
        this.reportItemClazz = reportItemClazz;
        this.outcome = outcome;
        this.prefix = variablePrefix;
    }

    @Override
    public void getResult(VariableLookup lookup) {
        Map<Object, Object> info;
        if (this.first == null) {
            return;
        }
        ReportTargetItem target = this.first.getTargetItem();
        Map<Object, Object> map = info = this.first.info != null ? this.first.info : new HashMap();
        if (target instanceof ReportTargetItem.ScenarioItem) {
            ReportTargetItem.ScenarioItem ct = (ReportTargetItem.ScenarioItem)target;
            lookup.addVariable(this.prefix + "ProjectKey", ct.projectKey);
            lookup.addVariable(this.prefix + "Id", ct.scenarioId);
            if (info.get("deleted") != null) {
                lookup.addVariable(this.prefix + "DisplayName", "deleted scenario " + ct.scenarioId + " in " + ct.projectKey);
            } else {
                lookup.addVariable(this.prefix + "Name", info.get("name"));
                lookup.addVariable(this.prefix + "DisplayName", String.valueOf(info.get("name")) + " in " + ct.projectKey);
            }
        } else if (target instanceof ReportTargetItem.ScenarioStepItem) {
            ReportTargetItem.ScenarioStepItem ct = (ReportTargetItem.ScenarioStepItem)target;
            if (info.get("scenarioDeleted") != null) {
                lookup.addVariable(this.prefix + "DisplayName", "step from deleted scenario " + ct.scenarioId + " in " + ct.projectKey);
            } else {
                Object name = info.get("name");
                name = name != null ? name.toString() : "*unnamed*";
                lookup.addVariable(this.prefix + "Name", name);
                lookup.addVariable(this.prefix + "DisplayName", String.valueOf(name) + " in scenario " + String.valueOf(info.get("scenarioName")) + " in " + ct.projectKey);
            }
            lookup.addVariable(this.prefix, this.first);
        } else if (target instanceof ReportTargetItem.JobsItem) {
            lookup.addVariable(this.prefix + "DisplayName", ((ReportItem.JobExecuted)this.first).jobId);
            lookup.addVariable(this.prefix, this.first);
        }
    }

    @Override
    public void handle(ReportItem item) {
        boolean outcomeOk;
        boolean itemClazzOk = this.reportItemClazz == null || this.reportItemClazz.isInstance(item);
        boolean bl = outcomeOk = this.outcome == null || this.outcome == item.getOutcome();
        if (itemClazzOk && outcomeOk) {
            this.first = item;
        }
    }
}

