/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dao.SessionsDAO;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.remoterun.RemoteRunNetworkingUtils;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppsService;
import com.dataiku.dip.webapps.backend.WebAppBackend;
import com.dataiku.dip.webapps.backend.WebAppBackendsManager;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.Header;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.client.CookieStore;
import com.dataiku.dss.shadelib.org.apache.http.client.config.RequestConfig;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.CloseableHttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPost;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.client.utils.URIBuilder;
import com.dataiku.dss.shadelib.org.apache.http.config.Registry;
import com.dataiku.dss.shadelib.org.apache.http.config.RegistryBuilder;
import com.dataiku.dss.shadelib.org.apache.http.conn.HttpClientConnectionManager;
import com.dataiku.dss.shadelib.org.apache.http.conn.socket.ConnectionSocketFactory;
import com.dataiku.dss.shadelib.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import com.dataiku.dss.shadelib.org.apache.http.conn.ssl.NoopHostnameVerifier;
import com.dataiku.dss.shadelib.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.dataiku.dss.shadelib.org.apache.http.entity.StringEntity;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.BasicCookieStore;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.CloseableHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.HttpClientBuilder;
import com.dataiku.dss.shadelib.org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import com.dataiku.dss.shadelib.org.apache.http.impl.cookie.BasicClientCookie;
import com.dataiku.dss.shadelib.org.apache.http.message.BasicHeader;
import com.dataiku.dss.shadelib.org.apache.http.ssl.SSLContexts;
import com.dataiku.dss.shadelib.org.apache.http.ssl.TrustStrategy;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import jakarta.servlet.http.Cookie;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class WebappTestStepRunner
implements StepRunner {
    @Autowired
    private WebAppsService webAppsService;
    @Autowired
    private WebAppBackendsManager backendsManager;
    @Autowired
    private FutureService futureService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    @Autowired
    private UIAuthService uiAuthService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private SessionsDAO sessionsDAO;
    private final Step step;
    private final WebappTestStepParams params;
    public static final StepMeta META = new StepMeta(){
        public final String WEBAPP_TEST = "webapp_test";

        @Override
        public String getType() {
            return "webapp_test";
        }

        @Override
        public Class<? extends StepParams> paramsClass() {
            return WebappTestStepParams.class;
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new WebappTestStepRunner(step, step.getParamsAs(WebappTestStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            return "webapp_test";
        }

        @Override
        public String buildId(Step step) {
            WebappTestStepParams stepParams = step.getParamsAs(WebappTestStepParams.class);
            StringBuilder sb = new StringBuilder("webapp_test");
            if (stepParams != null && StringUtils.isNotBlank((CharSequence)stepParams.webAppId)) {
                sb.append("_").append(stepParams.webAppId);
            }
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario scenario, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.webappTestStepRunner");

    public WebappTestStepRunner(Step step, WebappTestStepParams params) {
        this.step = step;
        this.params = params;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run(StepRun stepRun, ReportItem.StepDone reportItem) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[CATCHBLOCK], 16[CATCHBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ReportItem runTestQuery(StepRun stepRun, WebappTestStepParams.QueryReponseTestParams qrtParams, WebAppBackend backend, ReportItem.QueriedWebApp reportItem, VariablesContext variablesContext) throws IOException, URISyntaxException {
        String user = qrtParams.anonymousRequest ? null : (StringUtils.isNotBlank((CharSequence)qrtParams.requestUser) ? qrtParams.requestUser : stepRun.getScenarioRun().runAsUser.getIdentifier());
        reportItem.withAnonymousRequest(qrtParams.anonymousRequest);
        reportItem.withRequestUser(user);
        try (CloseableHttpClient client = this.getClient(user);){
            HttpGet request;
            String hostBase = RemoteRunNetworkingUtils.getStudioExternalURL();
            String expandedRequestPath = variablesContext.expandAllowUnresolved(qrtParams.requestPath);
            String uriStr = hostBase + backend.getBackendUrl() + expandedRequestPath;
            reportItem.withRequestPath(expandedRequestPath);
            URIBuilder uriBuilder = new URIBuilder(uriStr);
            List<SimpleKeyValue> expandedRequestParams = qrtParams.requestParams.stream().map(kv -> new SimpleKeyValue(kv.key, variablesContext.expandAllowUnresolved(kv.value))).collect(Collectors.toList());
            reportItem.withRequestParams(expandedRequestParams);
            for (SimpleKeyValue param : expandedRequestParams) {
                uriBuilder.setParameter(param.key, param.value);
            }
            logger.debugV("Will test-query the webapp at %s with request parameters %s and method %s", new Object[]{uriStr, expandedRequestParams, qrtParams.requestMethod});
            URI uri = uriBuilder.build();
            reportItem.withRequestMethod(qrtParams.requestMethod.name());
            switch (qrtParams.requestMethod) {
                case GET: {
                    request = new HttpGet(uri);
                    break;
                }
                case POST: {
                    request = new HttpPost(uri);
                    String expandedBody = variablesContext.expandAllowUnresolved(qrtParams.requestBody);
                    if (!StringUtils.isNotBlank((CharSequence)expandedBody)) break;
                    reportItem.withHasRequestBody(true);
                    logger.debugV("Query will include body %s", new Object[]{expandedBody});
                    StringEntity stringEntity = new StringEntity(expandedBody);
                    if (StringUtils.isNotBlank((CharSequence)qrtParams.requestContentType)) {
                        reportItem.withRequestContentType(qrtParams.requestContentType);
                        logger.debugV("Query will have content type %s", new Object[]{qrtParams.requestContentType});
                        stringEntity.setContentType(qrtParams.requestContentType);
                    }
                    ((HttpPost)request).setEntity((HttpEntity)stringEntity);
                    break;
                }
                default: {
                    throw new Error("Unreachable");
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)qrtParams.expectedResponseType)) {
                reportItem.withExpectedResponseType(qrtParams.expectedResponseType);
                logger.debugV("Setting %s header of query to %s", new Object[]{"Accept", qrtParams.expectedResponseType});
                request.setHeader("Accept", qrtParams.expectedResponseType);
            }
            logger.debug((Object)"Running test query");
            try (CloseableHttpResponse resp = client.execute((HttpUriRequest)request);){
                Object contentLengthValue;
                HttpEntity entity = resp.getEntity();
                if (null == entity) {
                    logger.info((Object)"Response contains no entity");
                } else {
                    logger.infoV("Response content type is %s", new Object[]{null != entity.getContentType() ? entity.getContentType().getValue() : "undefined"});
                    if (null != entity.getContentType() && StringUtils.isNotBlank((CharSequence)qrtParams.expectedResponseType) && !StringUtils.startsWithIgnoreCase((CharSequence)entity.getContentType().getValue(), (CharSequence)qrtParams.expectedResponseType)) {
                        logger.warnV("Indicated accepted response type %s, got %s", new Object[]{qrtParams.expectedResponseType, entity.getContentType().getValue()});
                    }
                }
                Header contentLengthHeader = resp.getFirstHeader("Content-Length");
                if (contentLengthHeader != null) {
                    contentLengthValue = contentLengthHeader.getValue();
                    try {
                        Long contentLength = Long.parseLong((String)contentLengthValue);
                        logger.infoV("%s header indicates length of %d", new Object[]{"Content-Length", contentLength});
                    }
                    catch (NumberFormatException nfe) {
                        logger.warnV("Exception while parsing content length header having value %s: %s", new Object[]{contentLengthValue, nfe.getLocalizedMessage()});
                    }
                } else {
                    logger.infoV("No %s header in response", new Object[]{"Content-Length"});
                }
                reportItem.withExpectedResponseStatus(qrtParams.expectedResponseStatus);
                if (resp.getStatusLine().getStatusCode() != qrtParams.expectedResponseStatus) {
                    logger.errorV("Expected response status code %d ; got %d", new Object[]{qrtParams.expectedResponseStatus, resp.getStatusLine().getStatusCode()});
                    contentLengthValue = reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED);
                    return contentLengthValue;
                }
                logger.infoV("Got expected response status code %d", new Object[]{qrtParams.expectedResponseStatus});
                boolean jsonPathDefined = StringUtils.isNotBlank((CharSequence)qrtParams.responseJSONPath);
                if (!StringUtils.isNotBlank((CharSequence)qrtParams.expectedResponseBody)) {
                    if (!jsonPathDefined) return reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.SUCCESS);
                }
                if (null == (entity = resp.getEntity())) {
                    logger.errorV("Response contains no entity. Can not check it.", new Object[0]);
                    ReportItem nfe = reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED);
                    return nfe;
                }
                String ret = IOUtils.toString((InputStream)entity.getContent(), (Charset)StandardCharsets.UTF_8);
                if (jsonPathDefined) {
                    logger.infoV("JSON Path expression defined. Considering the reply as JSON and extracting information", new Object[0]);
                    try {
                        Object extractedValue = JsonPath.compile((String)qrtParams.responseJSONPath, (Predicate[])new Predicate[0]).read(ret);
                        ObjectMapper mapper = new ObjectMapper();
                        ret = mapper.writeValueAsString(extractedValue);
                        logger.infoV("Extracted: %s", new Object[]{ret});
                    }
                    catch (Exception e) {
                        logger.errorV((Throwable)e, "Error applying JSON Path expression %s to response body %s and converting it to string representation", new Object[]{qrtParams.responseJSONPath, ret});
                        ReportItem reportItem2 = reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED);
                        if (resp != null) {
                            resp.close();
                        }
                        if (client == null) return reportItem2;
                        client.close();
                        return reportItem2;
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)qrtParams.expectedResponseBody)) {
                    logger.infoV("Non empty response body defined. Checking it.", new Object[0]);
                    reportItem.withHasExpectedResponseBody(true);
                    String expandedResponseBody = variablesContext.expandAllowUnresolved(qrtParams.expectedResponseBody);
                    if (!StringUtils.equals((CharSequence)ret, (CharSequence)expandedResponseBody)) {
                        logger.errorV("Expected response %s ; got %s", new Object[]{qrtParams.expectedResponseBody, ret});
                        ReportItem reportItem3 = reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED);
                        return reportItem3;
                    }
                    logger.infoV("Got expected response body", new Object[0]);
                    return reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.SUCCESS);
                }
                if (!jsonPathDefined) return reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.SUCCESS);
                reportItem.withHasExpectedResponseBody(true);
                logger.infoV("Expected response body blank or not defined. Checking only existence of %s in reply and not its value.", new Object[]{qrtParams.responseJSONPath});
                return reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.SUCCESS);
            }
        }
    }

    private CloseableHttpClient getClient(String user) throws IOException, URISyntaxException {
        Registry registry;
        ArrayList headers;
        BasicCookieStore cookieStore = new BasicCookieStore();
        if (StringUtils.isNotBlank((CharSequence)user)) {
            logger.infoV("Creating HTTP client for UI user %s", new Object[]{user});
            List<Cookie> cookies = this.uiAuthService.createSession(user);
            URI dssURI = new URI(RemoteRunNetworkingUtils.getStudioExternalURL());
            String domain = dssURI.getHost();
            BasicHeader header = new BasicHeader("Host", domain);
            headers = Lists.newArrayList((Object[])new Header[]{header});
            for (Cookie c2 : cookies) {
                BasicClientCookie toAdd = new BasicClientCookie(c2.getName(), c2.getValue());
                toAdd.setDomain(domain);
                toAdd.setPath("/");
                cookieStore.addCookie((com.dataiku.dss.shadelib.org.apache.http.cookie.Cookie)toAdd);
            }
        } else {
            logger.infoV("Creating HTTP client for anonymous, non logged user", new Object[0]);
            headers = new ArrayList();
        }
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.addInterceptorFirst(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR);
        ProxySettings proxySettings = this.params.useGlobalProxy ? ApplicationConfigurator.getProxySettings() : null;
        ProxyUtils.applyProxySettings((ProxySettings)proxySettings, (HttpClientBuilder)builder);
        RequestConfig rc = RequestConfig.custom().setConnectTimeout(this.params.timeoutS * 1000).setConnectionRequestTimeout(this.params.timeoutS * 1000).setSocketTimeout(this.params.timeoutS * 1000).setCookieSpec("standard").build();
        builder.setDefaultRequestConfig(rc);
        builder.setDefaultCookieStore((CookieStore)cookieStore);
        try {
            logger.infoV("Setting up trusting all certificates", new Object[0]);
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build();
        }
        catch (Exception e) {
            logger.warnV((Throwable)e, "Failed to trust all certificates", new Object[0]);
            registry = null;
        }
        SessionClosingBasicHttpClientConnectionManager connManager = null == registry ? new SessionClosingBasicHttpClientConnectionManager((CookieStore)cookieStore, user) : new SessionClosingBasicHttpClientConnectionManager(registry, (CookieStore)cookieStore, user);
        builder.setConnectionManager((HttpClientConnectionManager)connManager);
        builder.setDefaultHeaders((Collection)headers);
        builder.disableContentCompression();
        builder.addInterceptorFirst(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBackend(WebApp webApp, ReportTargetItem.WebAppItem target, AnyLoc webAppLoc, StepRun stepRun) {
        logger.infoV("Backend of webapp %s was started for test. Stopping.", new Object[]{this.params.webAppId});
        ReportItem.StoppedWebApp stopReportItem = (ReportItem.StoppedWebApp)new ReportItem.StoppedWebApp(target).withStart(DateTime.now().getMillis());
        try {
            if (!this.webAppsService.stopBackend(webApp)) {
                logger.warnV("Failed to stop backend of webapp %s started for test", new Object[]{this.params.webAppId});
                stopReportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED);
            } else {
                logger.infoV("Backend of webapp %s stopped.", new Object[]{this.params.webAppId});
                stopReportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.SUCCESS);
            }
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Failed stopping backend of webapp %s", new Object[]{this.params.webAppId});
            stopReportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED).withThrown(e);
        }
        finally {
            this.jobsDatabaseService.tryRegisterFlowObjectEvent(webAppLoc, null, null, stepRun.getScenarioRun(), stepRun, stopReportItem);
        }
    }

    public static class WebappTestStepParams
    extends NonFatalStepParams
    implements StepParams {
        public String webAppId;
        public boolean startIfNeeded = true;
        public int timeoutS = 5;
        public boolean useGlobalProxy;
        public List<QueryReponseTestParams> queryResponseTestParams = new ArrayList<QueryReponseTestParams>();

        public static class QueryReponseTestParams {
            public String id;
            @Nullable
            public String label;
            public boolean anonymousRequest = false;
            @Nullable
            public String requestUser;
            public RequestMethod requestMethod;
            @Nullable
            public String requestPath;
            public List<SimpleKeyValue> requestParams = new ArrayList<SimpleKeyValue>();
            @Nullable
            public String requestBody;
            @Nullable
            public String requestContentType = "application/json";
            @Nullable
            public String expectedResponseType;
            public int expectedResponseStatus = 200;
            @Nullable
            public String responseJSONPath;
            @Nullable
            public String expectedResponseBody;

            public String toString() {
                String responseBody;
                String body = StringUtils.isNotBlank((CharSequence)this.requestBody) ? "with body " + this.requestBody : "with no body";
                String contentType = StringUtils.isNotBlank((CharSequence)this.requestBody) && StringUtils.isNotBlank((CharSequence)this.requestContentType) ? "with request content type " + this.requestContentType : "";
                String string = responseBody = StringUtils.isNotBlank((CharSequence)this.expectedResponseBody) ? "expected response body " + this.expectedResponseBody : "no check on response body";
                String runAsUser = this.anonymousRequest ? "Anonymous (non logged in DSS)" : (StringUtils.isNotBlank((CharSequence)this.requestUser) ? " Will force run as user " + this.requestUser : " Will run as scenario run as user");
                return String.format("'%s', querying %s using method %s and parameters %s %s %s expecting response status code %d and %s. %s", new Object[]{this.label, this.requestPath, this.requestMethod, this.requestParams, body, contentType, this.expectedResponseStatus, responseBody, runAsUser});
            }

            public static enum RequestMethod {
                GET,
                POST;

            }
        }
    }

    private class SessionClosingBasicHttpClientConnectionManager
    extends BasicHttpClientConnectionManager {
        private final CookieStore cookieStore;
        private final String user;

        public SessionClosingBasicHttpClientConnectionManager(CookieStore cookieStore, String user) {
            this.cookieStore = cookieStore;
            this.user = user;
        }

        public SessionClosingBasicHttpClientConnectionManager(Registry<ConnectionSocketFactory> registry, CookieStore cookieStore, String user) {
            super(registry);
            this.cookieStore = cookieStore;
            this.user = user;
        }

        public void shutdown() {
            super.shutdown();
            Optional<com.dataiku.dss.shadelib.org.apache.http.cookie.Cookie> accessCookie = this.cookieStore.getCookies().stream().filter(cookie -> cookie.getName().equals(UIAuthService.getAccessCookieName())).findFirst();
            if (accessCookie.isPresent()) {
                try {
                    logger.debugV("Removing session for user %s opened for webapp test", new Object[]{this.user});
                    WebappTestStepRunner.this.sessionsDAO.removeSession(accessCookie.get().getValue());
                }
                catch (IOException e) {
                    logger.errorV((Throwable)e, "Could not remove session", new Object[0]);
                }
            }
        }
    }
}

