/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.triggers;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dao.HashesModel;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dao.impl.FlowStateInternalDB;
import com.dataiku.dip.dataflow.ComputableHashComputer;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetReadiness;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.FlowComputableSpecification;
import com.dataiku.dip.scheduler.triggers.Trigger;
import com.dataiku.dip.scheduler.triggers.TriggerFire;
import com.dataiku.dip.scheduler.triggers.TriggerMeta;
import com.dataiku.dip.scheduler.triggers.TriggerParams;
import com.dataiku.dip.scheduler.triggers.TriggerRunner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.services.ScenariosTriggerService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.Seconds;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DatasetModifiedTriggerRunner
implements TriggerRunner {
    private static final String HASH_TIMESTAMP_PREFIX = ".timestamp.";
    private static final DateTimeFormatter HASH_TIMESTAMP_FORMATTER = DKUtils.getISODateFormatter();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.scenarios.triggers");
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private FlowStateInternalDB flowStateInternalDB;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private ModelEvaluationStoresDAO modelEvaluationStoresDAO;
    @Autowired
    private TransactionService transactionService;
    public static final TriggerMeta META = new TriggerMeta(){

        @Override
        public Class<? extends TriggerParams> paramsClass() {
            return DatasetModifiedTriggerParams.class;
        }

        @Override
        public String getType() {
            return "ds_modified";
        }

        @Override
        public TriggerRunner buildRunner(Scenario scenario, Trigger trigger) {
            return new DatasetModifiedTriggerRunner(scenario, trigger, trigger.getParamsAs(DatasetModifiedTriggerParams.class));
        }

        @Override
        public boolean delayIfScenarioAlreadyRuns() {
            return true;
        }

        @Override
        public String getDigest(Trigger trigger) {
            DatasetModifiedTriggerParams params = trigger.getParamsAs(DatasetModifiedTriggerParams.class);
            ArrayList itemNames = Lists.newArrayList();
            for (FlowComputableSpecification item : params.watches) {
                itemNames.add(item.getItemName());
            }
            if (itemNames.size() == 0) {
                return "Never";
            }
            return "When " + Joiner.on((String)" or ").join((Iterable)itemNames) + " changes";
        }

        @Override
        public DateTime getExpectedNextRun(Trigger trigger, String stateString) {
            return null;
        }

        @Override
        public int getForcedTriggerLoopDelay(Trigger trigger, String currentState, boolean loopStarting) {
            return trigger.getDelay();
        }
    };
    private final DatasetModifiedTriggerParams params;
    private final Trigger trigger;
    private final Scenario scenario;

    public DatasetModifiedTriggerRunner(Scenario scenario, Trigger trigger, DatasetModifiedTriggerParams params) {
        this.trigger = trigger;
        this.params = params;
        this.scenario = scenario;
    }

    @Override
    public TriggerFire run(ScenariosTriggerService triggerService, AuthCtx authCtx) throws Exception {
        List<Object> filteredModifiedComputableIds;
        Map<String, String> currentHashesRaw;
        String stateString = triggerService.getTriggerState(this.scenario, this.trigger);
        Map lastRunHashesEncoded = stateString == null ? Collections.emptyMap() : (Map)JSON.parse((String)stateString, (TypeToken)new TypeToken<Map<String, String>>(){});
        Map<String, DatedComputableHash> lastRunHashes = DatasetModifiedTriggerRunner.decodeHashes(lastRunHashesEncoded);
        try (DSSDBConnection conn = this.flowStateInternalDB.acquireConnection();){
            currentHashesRaw = this.computeCurrentComputablesHash(authCtx, conn);
        }
        Map<Object, Object> currentHashes = Maps.newHashMap();
        for (Map.Entry<String, String> e : currentHashesRaw.entrySet()) {
            currentHashes.put(e.getKey(), new DatedComputableHash(e.getValue()));
        }
        currentHashes = this.updateHashesWithDetectionDates(lastRunHashes, (Map<String, DatedComputableHash>)currentHashes);
        TriggerFire triggerFire = new TriggerFire().withProjectKey(this.scenario.getProjectKey()).withScenarioId(this.scenario.getId()).withTrigger(this.trigger);
        if (!Sets.difference(currentHashes.keySet(), lastRunHashes.keySet()).isEmpty()) {
            triggerFire = triggerFire.withTriggerState(JSON.json(DatasetModifiedTriggerRunner.encodeHashes(currentHashes)));
            triggerService.recordState(triggerFire);
            return null;
        }
        List<String> modifiedComputableIds = this.getModifiedComputableIds(currentHashes);
        if (this.params.triggerWhenAllFire && this.params.monitorWindowSeconds != null) {
            filteredModifiedComputableIds = this.filterComputableIdsByModificationDate(currentHashes, modifiedComputableIds, this.params.monitorWindowSeconds);
            logger.infoV("From %s computables found %s changes, filtered to %s", new Object[]{currentHashes.size(), modifiedComputableIds.size(), filteredModifiedComputableIds.size()});
        } else {
            filteredModifiedComputableIds = Lists.newArrayList(modifiedComputableIds);
            logger.infoV("From %s computables found %s changes", new Object[]{currentHashes.size(), modifiedComputableIds.size()});
        }
        if (this.params.triggerWhenAllFire) {
            if (filteredModifiedComputableIds.size() == currentHashes.size()) {
                triggerFire = triggerFire.withParam("modified", JSON.json(modifiedComputableIds));
                triggerFire = triggerFire.withTriggerState(JSON.json(currentHashesRaw));
                logger.info((Object)"Firing a trigger");
                return triggerFire;
            }
            Object message = String.format("Trigger '%s.%s.%s' not fired because only %d of %d dependencies are changed", this.scenario.projectKey, this.scenario.id, this.trigger.name, filteredModifiedComputableIds.size(), currentHashes.size());
            if (!filteredModifiedComputableIds.isEmpty()) {
                message = (String)message + ": " + StringUtils.join(filteredModifiedComputableIds, (String)",");
            }
            if (this.params.monitorWindowSeconds != null) {
                message = (String)message + String.format(" (within the %d seconds(s) period)", this.params.monitorWindowSeconds);
            }
            logger.info(message);
        } else if (!filteredModifiedComputableIds.isEmpty()) {
            triggerFire = triggerFire.withParam("modified", JSON.json(modifiedComputableIds));
            triggerFire = triggerFire.withTriggerState(JSON.json(currentHashesRaw));
            logger.info((Object)"Firing a trigger");
            return triggerFire;
        }
        boolean needToUpdateState = !Sets.difference(lastRunHashes.keySet(), currentHashes.keySet()).isEmpty();
        for (String string : currentHashes.keySet()) {
            needToUpdateState = needToUpdateState || !StringUtils.equals((String)lastRunHashes.get((Object)string).hash, (String)((DatedComputableHash)currentHashes.get((Object)string)).hash);
            needToUpdateState = needToUpdateState || !StringUtils.equals((String)StringUtils.defaultIfBlank((String)lastRunHashes.get((Object)string).date, (String)""), (String)StringUtils.defaultIfBlank((String)((DatedComputableHash)currentHashes.get((Object)string)).date, (String)""));
        }
        if (needToUpdateState) {
            triggerFire = triggerFire.withTriggerState(JSON.json(DatasetModifiedTriggerRunner.encodeHashes(currentHashes)));
            triggerService.recordState(triggerFire);
        }
        return null;
    }

    public static Map<String, DatedComputableHash> decodeHashes(Map<String, String> hashes) {
        TreeMap ret = Maps.newTreeMap();
        for (String k : hashes.keySet()) {
            if (k.startsWith(HASH_TIMESTAMP_PREFIX)) continue;
            String hash = hashes.get(k);
            String timestampPrefix = HASH_TIMESTAMP_PREFIX + k;
            if (hashes.containsKey(timestampPrefix)) {
                String t = hashes.get(timestampPrefix);
                ret.put(k, new DatedComputableHash(hash, t));
                continue;
            }
            ret.put(k, new DatedComputableHash(hash, ""));
        }
        return ret;
    }

    public static Map<String, String> encodeHashes(Map<String, DatedComputableHash> hashes) {
        TreeMap ret = Maps.newTreeMap();
        for (String k : hashes.keySet()) {
            DatedComputableHash hash = hashes.get(k);
            ret.put(k, hash.hash);
            if (!StringUtils.isNotBlank((String)hash.date)) continue;
            ret.put(HASH_TIMESTAMP_PREFIX + k, hash.date);
        }
        return ret;
    }

    Map<String, String> computeCurrentComputablesHash(AuthCtx authCtx, DSSDBConnection conn) throws Exception {
        ComputableHashComputer computableHashComputer = new ComputableHashComputer(authCtx);
        HashMap currentHashes = Maps.newHashMap();
        for (FlowComputableSpecification watch : this.params.watches) {
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(this.scenario.getProjectKey(), (String)(watch.projectKey != null ? watch.projectKey + "." : "") + watch.itemId);
            if (watch.type == FlowComputable.FCType.DATASET) {
                this.collectHashForDataset(authCtx, conn, computableHashComputer, currentHashes, watch, loc);
                continue;
            }
            if (watch.type == FlowComputable.FCType.MANAGED_FOLDER) {
                this.collectHashForMf(authCtx, computableHashComputer, currentHashes, watch, loc);
                continue;
            }
            if (watch.type == FlowComputable.FCType.SAVED_MODEL) {
                this.collectHashForSm(computableHashComputer, currentHashes, loc);
                continue;
            }
            if (watch.type != FlowComputable.FCType.MODEL_EVALUATION_STORE) continue;
            this.collectHashForMes(computableHashComputer, currentHashes, loc);
        }
        return currentHashes;
    }

    private List<String> getModifiedComputableIds(Map<String, DatedComputableHash> currentHashes) {
        ArrayList modifiedComputableIds = Lists.newArrayList();
        for (Map.Entry<String, DatedComputableHash> hash : currentHashes.entrySet()) {
            if (!StringUtils.isNotBlank((String)hash.getValue().date)) continue;
            modifiedComputableIds.add(hash.getKey());
        }
        return modifiedComputableIds;
    }

    private List<String> filterComputableIdsByModificationDate(final Map<String, DatedComputableHash> datedComputableHashes, List<String> modifiedComputableIds, final Integer monitorWindowSeconds) {
        return Lists.newArrayList((Iterable)Collections2.filter(modifiedComputableIds, (Predicate)new Predicate<String>(){

            public boolean apply(@Nullable String computableId) {
                if (!datedComputableHashes.containsKey(computableId)) {
                    return false;
                }
                DatedComputableHash datedHash = (DatedComputableHash)datedComputableHashes.get(computableId);
                if (StringUtils.isBlank((String)datedHash.date)) {
                    return false;
                }
                int age = Seconds.secondsBetween((ReadableInstant)HASH_TIMESTAMP_FORMATTER.parseDateTime(datedHash.date), (ReadableInstant)DateTime.now()).getSeconds();
                return age < monitorWindowSeconds;
            }
        }));
    }

    private Map<String, DatedComputableHash> updateHashesWithDetectionDates(Map<String, DatedComputableHash> lastRunHashes, Map<String, DatedComputableHash> hashes) {
        HashMap<String, DatedComputableHash> newHashes = new HashMap<String, DatedComputableHash>();
        for (Map.Entry<String, DatedComputableHash> e : hashes.entrySet()) {
            String computableId = e.getKey();
            DatedComputableHash hash = e.getValue();
            if (!lastRunHashes.containsKey(computableId)) {
                newHashes.put(computableId, hash);
                continue;
            }
            DatedComputableHash old = lastRunHashes.get(computableId);
            if (!StringUtils.equals((String)hash.hash, (String)old.hash)) {
                newHashes.put(computableId, new DatedComputableHash(hash.hash, HASH_TIMESTAMP_FORMATTER.print((ReadableInstant)DateTime.now())));
                continue;
            }
            newHashes.put(computableId, old);
        }
        return newHashes;
    }

    private void collectHashForSm(ComputableHashComputer computableHashComputer, Map<String, String> hashes, DatasetLocUtils.DatasetLoc loc) throws IOException {
        SavedModel sm;
        try (Transaction t = this.transactionService.beginRead();){
            sm = (SavedModel)this.savedModelsDAO.getMandatory(loc.getProjectKey(), loc.getName());
        }
        DatasetReadiness hash = computableHashComputer.getCurrentContentHash(sm);
        hashes.put(loc.getFullName(), hash.hash);
    }

    private void collectHashForMes(ComputableHashComputer computableHashComputer, Map<String, String> hashes, DatasetLocUtils.DatasetLoc loc) throws Exception {
        ModelEvaluationStore mes;
        try (Transaction t = this.transactionService.beginRead();){
            mes = (ModelEvaluationStore)this.modelEvaluationStoresDAO.getMandatory(loc.getProjectKey(), loc.getName());
        }
        DatasetReadiness hash = computableHashComputer.getCurrentContentHash(mes);
        hashes.put(loc.getFullName(), hash.hash);
    }

    private void collectHashForMf(AuthCtx authCtx, ComputableHashComputer computableHashComputer, Map<String, String> hashes, FlowComputableSpecification watch, DatasetLocUtils.DatasetLoc loc) throws Exception {
        List<Partition> partitions;
        String partitionId;
        ManagedFolder mf;
        try (Transaction t = this.transactionService.beginRead();){
            mf = (ManagedFolder)this.managedFolderDAO.getMandatory(loc.getProjectKey(), loc.getName());
        }
        String string = partitionId = StringUtils.isBlank((String)watch.partitionsSpec) ? "NP" : watch.partitionsSpec;
        if ("ALL".equals(partitionId)) {
            try (ManagedFolderHandler handler = (ManagedFolderHandler)mf.buildHandler(authCtx);){
                partitions = handler.listPartitions();
            }
        } else {
            partitions = PartitionFactory.fromPartitionSpec(mf.getPartitioningSchema(), partitionId);
        }
        for (Partition partition : partitions) {
            DatasetReadiness hash = computableHashComputer.getCurrentContentHash(mf, partition);
            hashes.put(loc.getFullName() + "." + partition.id(), hash.hash);
        }
    }

    private void collectHashForDataset(AuthCtx authCtx, DSSDBConnection conn, ComputableHashComputer computableHashComputer, Map<String, String> hashes, FlowComputableSpecification watch, DatasetLocUtils.DatasetLoc loc) throws Exception {
        List<Partition> partitions;
        String partitionId;
        Dataset dataset;
        try (Transaction t = this.transactionService.beginRead();){
            dataset = this.datasetAccessService.getMandatory(loc);
        }
        String string = partitionId = StringUtils.isBlank((String)watch.partitionsSpec) ? "NP" : watch.partitionsSpec;
        if ("ALL".equals(partitionId)) {
            try (DatasetHandler handler = DatasetHandlerFactory.build(authCtx, dataset);){
                partitions = handler.listPartitions();
            }
        } else {
            partitions = PartitionFactory.fromPartitionSpec(dataset.getPartitioningSchema(), partitionId);
        }
        if (dataset.isManaged() && !DatasetInspector.isEditable(dataset)) {
            String datasetSettingsHash = ComputableHashComputer.getDatasetSettingsHash(dataset);
            for (Partition partition : partitions) {
                StringBuilder fullHash = new StringBuilder();
                fullHash.append(datasetSettingsHash);
                for (HashesModel.PropagatedHashInfo propagated : this.flowStateInternalDB.getAllPropagatedFor(conn, dataset.getFullName(), partition.id())) {
                    fullHash.append('-');
                    fullHash.append(propagated.propagatedHash);
                    fullHash.append('-');
                    fullHash.append(propagated.propagatedOn);
                }
                hashes.put(dataset.getFullName() + "." + partition.id(), fullHash.toString());
            }
        } else {
            for (Partition partition : partitions) {
                DatasetReadiness hash = computableHashComputer.getCurrentContentHash(conn, dataset, partition);
                hashes.put(dataset.getFullName() + "." + partition.id(), hash.hash);
            }
        }
    }

    public static class DatasetModifiedTriggerParams
    implements TriggerParams {
        public List<FlowComputableSpecification> watches = Lists.newArrayList();
        public boolean triggerWhenAllFire = false;
        public Integer monitorWindowSeconds;
    }

    public static class DatedComputableHash {
        public String date;
        public String hash;

        public DatedComputableHash(String hash) {
            this.date = "";
            this.hash = hash;
        }

        public DatedComputableHash(String hash, String date) {
            this.date = date;
            this.hash = hash;
        }
    }
}

