/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.model;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSStartedEvent;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ImpalaSettings;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.ConnectionWithPerUserOAuth2Credentials;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.RemoteMCPConnection;
import com.dataiku.dip.connections.SQLServerConnection;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.plugins.RegularPluginsRegistryService;
import com.dataiku.dip.plugins.model.InstalledPluginDesc;
import com.dataiku.dip.plugins.model.PluginSettings;
import com.dataiku.dip.plugins.presets.LoadedParameterSet;
import com.dataiku.dip.plugins.presets.PluginPreset;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.security.model.OAuth2Client;
import com.dataiku.dip.security.model.PluginCredentialRequestService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.device.DeviceAuthorizationSuccessResponse;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.device.DeviceCode;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.device.UserCode;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Lists;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;

@Service
public class ConnectionCredentialsCRUDService
implements ApplicationListener<DSSStartedEvent> {
    private static final String CALLBACK_ENDPOINT_PATH = "dip/api/oauth2-callback";
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private UsersDAO usersDAO;
    @Autowired
    private RegularPluginsRegistryService pluginsRegistryService;
    @Autowired
    private PluginCredentialRequestService pluginCredentialRequestService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PasswordEncryptionService cryptoService;
    @Autowired
    private UIAuthService authService;
    private Map<String, DeviceCode> lastReceivedDeviceCodeByUser = new HashMap<String, DeviceCode>();
    private Map<String, OAuth2AuthorizationRequestInfo> oauth2StateMap = new HashMap<String, OAuth2AuthorizationRequestInfo>();
    private DelayedCredentialsStoringThread storingThread = new DelayedCredentialsStoringThread();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.oauth");

    public void onApplicationEvent(DSSStartedEvent dssStartedEvent) {
        this.storingThread.setDaemon(true);
        this.storingThread.start();
    }

    public UserCode runAzureOAuthDeviceCodeDanceStep1_NT(AuthCtx authCtx, OAuth2AuthorizationRequestInfo authorizationRequestInfo) throws Exception {
        OAuth2Client oAuth2Client = this.getOAuth2Client(authCtx, authorizationRequestInfo);
        DeviceAuthorizationSuccessResponse result = oAuth2Client.acquireDeviceCode();
        this.lastReceivedDeviceCodeByUser.put(authCtx.getIdentifier(), result.getDeviceCode());
        return result.getUserCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAzureOAuthDeviceCodeDanceStep2_NT(AuthCtx authCtx, OAuth2AuthorizationRequestInfo authorizationRequestInfo) throws Exception {
        DeviceCode deviceCode = this.lastReceivedDeviceCodeByUser.get(authCtx.getIdentifier());
        if (deviceCode == null) {
            throw new IllegalArgumentException("No DeviceCode known for this user");
        }
        this.lastReceivedDeviceCodeByUser.remove(authCtx.getIdentifier());
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        OAuth2Client oAuth2Client = this.getOAuth2Client(authCtx, authorizationRequestInfo);
        OAuth2Client.AccessTokenResult accessTokenResult = oAuth2Client.acquireAccessTokenResultWithDeviceCode(deviceCode);
        try {
            ICredentialsService.StoredCredential bcc = new ICredentialsService.StoredCredential();
            bcc.type = ICredentialsService.CredentialType.AZURE_OAUTH_DEVICECODE;
            bcc.refreshToken = accessTokenResult.getRefreshToken();
            bcc.lastUpdate = System.currentTimeMillis();
            try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
                UsersDAO.User u = this.usersDAO.getMandatoryUnsafe(authCtx.getAssociatedDSSUserMand());
                if (authorizationRequestInfo.credential.requestSource == CredentialRequestSource.CONNECTION) {
                    u.credentials.put(authorizationRequestInfo.credential.connection, bcc);
                }
                UsersService.UserSaveContext usc = UsersService.UserSaveContext.buildDefaultWithoutPassword();
                ((UsersService)SpringUtils.getBean(UsersService.class)).saveUser(u, false, usc, authCtx);
                t.commit("Update Azure OAuth token for connection= " + authorizationRequestInfo.credential.connection + " user=" + String.valueOf(authCtx));
            }
        }
        finally {
            executorService.shutdown();
        }
    }

    public void storeUserCredentialForConnection(AuthCtx authCtx, String connection, String user, String password) throws IOException, DKUSecurityException, CodedException {
        if (!connection.equals("@virtual(databricks-api)") && !connection.startsWith("@virtual(impala-jdbc)")) {
            DSSConnection c2 = this.connectionsDAO.getMandatoryConnectionUnsafeUnexpanded(authCtx, connection);
            if (c2.credentialsMode != DSSConnection.CredentialsMode.PER_USER) {
                throw new DKUSecurityException("Connection '" + connection + "' does not accept user credentials");
            }
        }
        this.storeUserCredential(authCtx, connection, user, password);
    }

    public void storeUserCredentialForPlugin(AuthCtx authCtx, PluginCredentialRequestService.PluginCredentialRequestInfo pluginRequestInfo, String user, String password) throws IOException, DKUSecurityException, CodedException {
        this.storeUserCredential(authCtx, pluginRequestInfo.getNameForCredentialMap(), user, password);
    }

    private void storeUserCredential(AuthCtx authCtx, String credentialKey, String user, String password) throws DKUSecurityException, IOException, CodedException {
        UsersDAO.User u = this.usersDAO.getMandatoryUnsafe(authCtx.getAssociatedDSSUserMand());
        if (StringUtils.isBlank((String)user) && StringUtils.isBlank((String)password)) {
            u.credentials.remove(credentialKey);
        } else {
            ICredentialsService.StoredCredential bcc = new ICredentialsService.StoredCredential();
            if (StringUtils.isBlank((String)user)) {
                bcc.type = ICredentialsService.CredentialType.SINGLE_FIELD;
            } else {
                bcc.type = ICredentialsService.CredentialType.BASIC;
                bcc.user = user;
            }
            bcc.lastUpdate = System.currentTimeMillis();
            bcc.password = this.cryptoService.encrypt(password);
            u.credentials.put(credentialKey, bcc);
        }
        UsersService.UserSaveContext usc = UsersService.UserSaveContext.buildDefaultWithoutPassword();
        ((UsersService)SpringUtils.getBean(UsersService.class)).saveUser(u, false, usc, authCtx);
    }

    public String buildCallbackEndpoint(String dssExternalUrl) {
        Object endpoint = dssExternalUrl;
        if (!((String)endpoint).endsWith("/")) {
            endpoint = (String)endpoint + "/";
        }
        return (String)endpoint + CALLBACK_ENDPOINT_PATH;
    }

    public OAuth2Client getOAuth2Client(AuthCtx authCtx, OAuth2AuthorizationRequestInfo authorizationRequestInfo) throws DKUSecurityException, IOException, URISyntaxException {
        switch (authorizationRequestInfo.credential.requestSource) {
            case PLUGIN: {
                return this.pluginCredentialRequestService.buildOAuth2AuthorizationClient(authorizationRequestInfo.credential.pluginCredentialRequestInfo);
            }
            case CONNECTION: {
                DSSConnection dssConnection;
                try (Transaction ignored = this.transactionService.beginRead();){
                    dssConnection = this.connectionsDAO.getMandatoryConnection(authCtx, authorizationRequestInfo.credential.connection);
                }
                if (dssConnection instanceof ConnectionWithEncryptedFields) {
                    ((ConnectionWithEncryptedFields)((Object)dssConnection)).decryptFields(this.cryptoService);
                }
                if (dssConnection instanceof ConnectionWithPerUserOAuth2Credentials && ((ConnectionWithPerUserOAuth2Credentials)((Object)dssConnection)).actuallyHasPerUserOAuth2Credential()) {
                    ProxySettings proxySettings = ApplicationConfigurator.getProxySettings(this.cryptoService);
                    return ((ConnectionWithPerUserOAuth2Credentials)((Object)dssConnection)).buildOAuth2Client(proxySettings, authCtx);
                }
                throw new DKUSecurityException("OAuth2 credentials not available for " + authorizationRequestInfo.credential.connection);
            }
        }
        throw new DKUSecurityException("OAuth2 credentials not available for " + String.valueOf((Object)authorizationRequestInfo.credential.requestSource));
    }

    public String getOAuth2AuthorizationEndpoint(HttpServletResponse resp, AuthCtx authCtx, OAuth2AuthorizationRequestInfo authorizationRequestInfo) throws IOException, DKUSecurityException, URISyntaxException {
        String codeVerifier;
        OAuth2Client oAuth2Client = this.getOAuth2Client(authCtx, authorizationRequestInfo);
        if (oAuth2Client.usePkce()) {
            codeVerifier = OAuth2Client.generatePkceCodeVerifier();
            this.authService.createPKCECodeVerifierCookie(resp, codeVerifier);
        } else {
            codeVerifier = null;
        }
        String state = OAuth2Client.generateAStateValue();
        this.oauth2StateMap.put(state, authorizationRequestInfo);
        return oAuth2Client.getAuthorizationUrl(this.buildCallbackEndpoint(authorizationRequestInfo.dssProtocolHost), state, codeVerifier);
    }

    public OAuth2AuthorizationRequestInfo confirmOAuth2State(String state) throws DKUSecurityException {
        return this.oauth2StateMap.remove(state);
    }

    public void storeOAuth2RefreshToken_NT(AuthCtx authCtx, String refreshToken, String clientId, String credentialKey) throws DKUSecurityException, IOException, CodedException {
        ICredentialsService.StoredCredential storedCredential = new ICredentialsService.StoredCredential();
        storedCredential.type = ICredentialsService.CredentialType.OAUTH_REFRESH_TOKEN;
        storedCredential.refreshToken = this.cryptoService.encrypt(refreshToken);
        storedCredential.lastUpdate = System.currentTimeMillis();
        storedCredential.clientId = clientId;
        this.storingThread.store(authCtx, credentialKey, storedCredential);
    }

    private UIUserCredential buildUIUserCredentialForConnection(DSSConnection connection, ICredentialsService.CredentialType credentialType) {
        UIUserCredential ui = new UIUserCredential();
        ui.type = credentialType;
        ui.connection = connection.getNameForCredentials();
        ui.connectionType = connection.type;
        ui.requestSource = CredentialRequestSource.CONNECTION;
        ui.credentialEntered = false;
        return ui;
    }

    private void updateUIUserCredentialForConnection(UIUserCredential uiCredential, ICredentialsService.CredentialType credentialType, String connectionType) {
        uiCredential.type = credentialType;
        uiCredential.connectionType = connectionType;
        uiCredential.requestSource = CredentialRequestSource.CONNECTION;
    }

    public UIUserCredentials getUserCredentials(AuthCtx authCtx) throws IOException, DKUSecurityException {
        Object ui;
        HashMap<String, Object> map = new HashMap<String, Object>();
        UsersDAO.User u = this.usersDAO.getMandatoryUnsafe(authCtx.getAssociatedDSSUserMand());
        for (Map.Entry<String, ICredentialsService.StoredCredential> storedCred : u.credentials.entrySet()) {
            ui = new UIUserCredential();
            ((UIUserCredential)ui).connection = storedCred.getKey();
            ((UIUserCredential)ui).type = storedCred.getValue().type;
            ((UIUserCredential)ui).user = storedCred.getValue().user;
            ((UIUserCredential)ui).credentialEntered = true;
            ((UIUserCredential)ui).lastUpdate = storedCred.getValue().lastUpdate;
            map.put(storedCred.getKey(), ui);
        }
        for (DSSConnection c2 : this.connectionsDAO.listUnsafe().values()) {
            SQLServerConnection sqlServerConnection;
            if (c2.credentialsMode != DSSConnection.CredentialsMode.PER_USER) continue;
            ICredentialsService.CredentialType credentialType = c2 instanceof SQLServerConnection ? (!(sqlServerConnection = (SQLServerConnection)c2).isOAuthLoginEnabled() ? ICredentialsService.CredentialType.BASIC : (sqlServerConnection.getGrantType() == SQLServerConnection.GrantType.DEVICE_CODE ? ICredentialsService.CredentialType.AZURE_OAUTH_DEVICECODE : ICredentialsService.CredentialType.OAUTH_REFRESH_TOKEN)) : (c2 instanceof ConnectionWithPerUserOAuth2Credentials && ((ConnectionWithPerUserOAuth2Credentials)((Object)c2)).actuallyHasPerUserOAuth2Credential() ? ICredentialsService.CredentialType.OAUTH_REFRESH_TOKEN : (c2 instanceof RemoteMCPConnection && ((RemoteMCPConnection)c2).actuallyHasPerUserBearerCredential() ? ICredentialsService.CredentialType.SINGLE_FIELD : ICredentialsService.CredentialType.BASIC));
            if (!map.containsKey(c2.getNameForCredentials())) {
                map.put(c2.getNameForCredentials(), this.buildUIUserCredentialForConnection(c2, credentialType));
                continue;
            }
            this.updateUIUserCredentialForConnection((UIUserCredential)map.get(c2.getNameForCredentials()), credentialType, c2.type);
        }
        ImpalaSettings impalaSettings = new ClusterSelector().selectGlobal().getImpalaSettings();
        if (impalaSettings.enabled && impalaSettings.credentialsMode == DSSConnection.CredentialsMode.PER_USER) {
            DSSConnection c2;
            c2 = this.connectionsDAO.getConnection(authCtx, "@virtual(impala-jdbc):default");
            if (!map.containsKey(c2.getNameForCredentials())) {
                ui = new UIUserCredential();
                ((UIUserCredential)ui).connection = c2.getNameForCredentials();
                ((UIUserCredential)ui).type = ICredentialsService.CredentialType.BASIC;
                ((UIUserCredential)ui).connectionType = c2.type;
                ((UIUserCredential)ui).requestSource = CredentialRequestSource.VIRTUAL_CONNECTION;
                ((UIUserCredential)ui).credentialEntered = false;
                map.put(c2.getNameForCredentials(), ui);
            } else {
                ((UIUserCredential)map.get((Object)c2.getNameForCredentials())).connectionType = c2.type;
                ((UIUserCredential)map.get((Object)c2.getNameForCredentials())).requestSource = CredentialRequestSource.VIRTUAL_CONNECTION;
            }
        }
        Collection<String> loadedPluginIds = this.pluginsRegistryService.getLoadedPluginIds();
        for (String pluginId : loadedPluginIds) {
            InstalledPluginDesc desc = this.pluginsRegistryService.getInstalledDesc(pluginId);
            PluginSettings pluginSettings = this.pluginsRegistryService.getSettings(pluginId);
            for (LoadedParameterSet paramSet : desc.customParameterSets) {
                if (paramSet.desc == null) continue;
                block9: for (ParamDesc paramDesc : paramSet.desc.params) {
                    ICredentialsService.CredentialType type;
                    if (paramDesc == null || paramDesc.type != ParamDesc.Type.CREDENTIAL_REQUEST || paramDesc.credentialRequestSettings == null) continue;
                    if (paramDesc.credentialRequestSettings.type == null) {
                        logger.warnV("Type of parameter set credential request '%s' is null", new Object[]{paramDesc.name});
                        continue;
                    }
                    switch (paramDesc.credentialRequestSettings.type) {
                        case SINGLE_FIELD: {
                            type = ICredentialsService.CredentialType.SINGLE_FIELD;
                            break;
                        }
                        case BASIC: {
                            type = ICredentialsService.CredentialType.BASIC;
                            break;
                        }
                        case OAUTH2: {
                            type = ICredentialsService.CredentialType.OAUTH_REFRESH_TOKEN;
                            break;
                        }
                        default: {
                            logger.warnV("Parameter set credential request '%s' has unknown type '%s'", new Object[]{paramDesc.name, paramDesc.credentialRequestSettings.type});
                            continue block9;
                        }
                    }
                    String presetType = "parameter-set-" + pluginId + "-" + paramSet.id;
                    for (PluginPreset preset : pluginSettings.presets) {
                        PluginCredentialRequestService.PluginCredentialRequestInfo credentialRequestInfo = new PluginCredentialRequestService.PluginCredentialRequestInfo();
                        credentialRequestInfo.pluginId = pluginId;
                        credentialRequestInfo.pluginIcon = desc.desc.meta.icon;
                        credentialRequestInfo.pluginLabel = StringUtils.isBlank((String)desc.desc.meta.label) ? pluginId : desc.desc.meta.label;
                        credentialRequestInfo.paramSetId = paramSet.id;
                        credentialRequestInfo.paramSetLabel = desc.customParameterSets.stream().filter(ps2 -> Objects.equals(ps2.id, paramSet.id)).filter(ps2 -> ps2.desc != null).map(ps2 -> ps2.desc.meta.label).findFirst().orElse(paramSet.id);
                        credentialRequestInfo.presetId = preset.name;
                        credentialRequestInfo.paramName = paramDesc.name;
                        credentialRequestInfo.paramLabel = StringUtils.isBlank((String)paramDesc.label) ? paramDesc.name : paramDesc.label;
                        credentialRequestInfo.refreshTokenRotation = paramDesc.credentialRequestSettings != null && paramDesc.credentialRequestSettings.refreshTokenRotation != null && paramDesc.credentialRequestSettings.refreshTokenRotation != false;
                        String keyInMap = credentialRequestInfo.getNameForCredentialMap();
                        if (map.containsKey(keyInMap)) {
                            ((UIUserCredential)map.get((Object)keyInMap)).requestSource = CredentialRequestSource.PLUGIN;
                            ((UIUserCredential)map.get((Object)keyInMap)).pluginCredentialRequestInfo = credentialRequestInfo;
                            continue;
                        }
                        if (!presetType.equals(preset.type)) continue;
                        UIUserCredential ui2 = new UIUserCredential();
                        ui2.type = type;
                        ui2.requestSource = CredentialRequestSource.PLUGIN;
                        ui2.pluginCredentialRequestInfo = credentialRequestInfo;
                        ui2.credentialEntered = false;
                        map.put(keyInMap, ui2);
                    }
                }
            }
        }
        UIUserCredentials ret = new UIUserCredentials();
        ret.credentials = Lists.newArrayList(map.values());
        return ret;
    }

    private class DelayedCredentialsStoringThread
    extends Thread {
        private LinkedBlockingQueue<CredentialsToStore> queue = new LinkedBlockingQueue();

        private DelayedCredentialsStoringThread() {
        }

        public void store(AuthCtx authCtx, String key, ICredentialsService.StoredCredential creds) throws DKUSecurityException {
            CredentialsToStore addition = new CredentialsToStore();
            addition.authCtx = authCtx;
            addition.login = authCtx.getAssociatedDSSUserMand();
            addition.key = key;
            addition.creds = creds;
            this.queue.add(addition);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (true) {
                try {
                    block10: while (true) {
                        batch = new ArrayList<CredentialsToStore>();
                        batch.add(this.queue.take());
                        this.queue.drainTo(batch);
                        ConnectionCredentialsCRUDService.logger.info((Object)("Received " + batch.size() + " credentials to store"));
                        if (batch.isEmpty()) continue;
                        batchByLogin = new HashMap<String, List>();
                        for (CredentialsToStore addition : batch) {
                            login = addition.login;
                            if (StringUtils.isBlank((String)login)) {
                                ConnectionCredentialsCRUDService.logger.warn((Object)("Empty login in refresh token to save. Skipping. (authCtx=" + String.valueOf(addition.authCtx) + ")"));
                                continue;
                            }
                            list = batchByLogin.computeIfAbsent(login, (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$run$0(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)());
                            list.add(addition);
                        }
                        ConnectionCredentialsCRUDService.logger.info((Object)("Save credentials for users " + batchByLogin.keySet().stream().collect(Collectors.joining(", "))));
                        usersService = (UsersService)SpringUtils.getBean(UsersService.class);
                        var4_5 = batchByLogin.values().iterator();
                        while (true) {
                            if (var4_5.hasNext()) ** break;
                            continue block10;
                            list = (List)var4_5.next();
                            if (list.isEmpty()) continue;
                            authCtx = ((CredentialsToStore)list.get((int)0)).authCtx;
                            login = ((CredentialsToStore)list.get((int)0)).login;
                            try {
                                t = ConnectionCredentialsCRUDService.this.transactionService.beginWriteAsLoggedInUser(authCtx);
                                try {
                                    keys = new HashSet<String>();
                                    for (CredentialsToStore addition : batch) {
                                        keys.add(addition.key);
                                        u = ConnectionCredentialsCRUDService.this.usersDAO.getMandatoryUnsafe(login);
                                        u.credentials.put(addition.key, addition.creds);
                                        usc = UsersService.UserSaveContext.buildDefaultWithoutPassword();
                                        usersService.saveUser(u, false, usc, authCtx);
                                    }
                                    t.commit("Updated OAuth tokens for " + keys.stream().collect(Collectors.joining(",")) + " user=" + login);
                                }
                                finally {
                                    if (t != null) {
                                        t.close();
                                    }
                                }
                            }
                            catch (Exception e) {
                                ConnectionCredentialsCRUDService.logger.error((Object)("Failed to store credentials for " + login), (Throwable)e);
                            }
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    ConnectionCredentialsCRUDService.logger.error((Object)"Failed to store credentials", (Throwable)e);
                    continue;
                }
                break;
            }
        }

        private static /* synthetic */ List lambda$run$0(String l) {
            return new ArrayList();
        }

        private class CredentialsToStore {
            AuthCtx authCtx;
            String login;
            String key;
            ICredentialsService.StoredCredential creds;

            private CredentialsToStore() {
            }
        }
    }

    public static class OAuth2AuthorizationRequestInfo {
        public String dssProtocolHost;
        public String userCurrentState;
        public UIUserCredential credential;
        public String userIdentifier;

        public String getCredentialKey() throws DKUSecurityException {
            switch (this.credential.requestSource) {
                case CONNECTION: {
                    return this.credential.connection;
                }
                case PLUGIN: {
                    return this.credential.pluginCredentialRequestInfo.getNameForCredentialMap();
                }
            }
            throw new DKUSecurityException("OAuth2 credentials not available for " + String.valueOf((Object)this.credential.requestSource));
        }

        public String toString() {
            return "OAuth2AuthorizationRequestInfo{dssProtocolHost='" + this.dssProtocolHost + "', userCurrentState='" + this.userCurrentState + "', credential=" + String.valueOf(this.credential) + ", userIdentifier='" + this.userIdentifier + "'}";
        }
    }

    @UIModel
    public static class UIUserCredential {
        public CredentialRequestSource requestSource;
        public ICredentialsService.CredentialType type;
        public String connectionType;
        public String connection;
        public PluginCredentialRequestService.PluginCredentialRequestInfo pluginCredentialRequestInfo;
        public String user;
        public boolean credentialEntered;
        public Long lastUpdate;

        public String toString() {
            return "UIUserCredential{requestSource=" + String.valueOf((Object)this.requestSource) + ", type=" + String.valueOf((Object)this.type) + ", connectionType='" + this.connectionType + "', connection='" + this.connection + "', pluginCredentialRequestInfo=" + String.valueOf(this.pluginCredentialRequestInfo) + ", user='" + this.user + "', credentialEntered=" + this.credentialEntered + ", lastUpdate=" + this.lastUpdate + "}";
        }
    }

    public static enum CredentialRequestSource {
        CONNECTION,
        VIRTUAL_CONNECTION,
        DATABRICKS_INTEGRATION,
        PLUGIN,
        EXPLICIT;

    }

    @UIModel
    static class UIUserCredentials {
        List<UIUserCredential> credentials = new ArrayList<UIUserCredential>();

        UIUserCredentials() {
        }
    }
}

