/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.projectstandards.ProjectStandardsCheck;
import com.dataiku.dip.projectstandards.ProjectStandardsCheckSpecInfo;
import com.dataiku.dip.projectstandards.ProjectStandardsGeneralParameters;
import com.dataiku.dip.projectstandards.ProjectStandardsRunReport;
import com.dataiku.dip.projectstandards.ProjectStandardsScope;
import com.dataiku.dip.projectstandards.ProjectStandardsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ProjectStandardsController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ProjectStandardsService projectStandardsService;
    @Autowired
    private ProjectsService projectsService;

    @AuditedCall(value={"msgType", "project-standards-list-check-specs"})
    @RequestMapping(value={"/api/project-standards/check-specs"})
    @ResponseBody
    public List<ProjectStandardsCheckSpecInfo> listCheckSpecs(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            List<ProjectStandardsCheckSpecInfo> list = this.projectStandardsService.listSpecsInfo();
            return list;
        }
    }

    @AuditedCall(value={"msgType", "project-standards-checks-import"})
    @RequestMapping(value={"/api/project-standards/checks/import"}, method={RequestMethod.POST})
    @ResponseBody
    public List<ProjectStandardsCheck> importChecksByElementTypes(HttpServletRequest req, HttpServletResponse resp, @RequestParam List<String> checkTemplateIds) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.authService.failIfNotAdmin(req);
            List<ProjectStandardsCheck> newChecks = this.projectStandardsService.importChecksFromCheckSpecs(checkTemplateIds);
            t.commitV("%d project standards checks have been created from ids %s", new Object[]{newChecks.size(), checkTemplateIds});
            List<ProjectStandardsCheck> list = newChecks;
            return list;
        }
    }

    @AuditedCall(value={"msgType", "project-standards-check-save"})
    @RequestMapping(value={"/api/project-standards/checks/{checkId}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ProjectStandardsCheck save(HttpServletRequest req, HttpServletResponse resp, @PathVariable String checkId, @RequestParam ProjectStandardsCheck check) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)check.id) && !check.id.equals(checkId)) {
            throw new IllegalArgumentException(String.format("Id of the check '%s' should be null or equal to the id in the URL path '%s'", check.id, checkId));
        }
        check.id = checkId;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.authService.failIfNotAdmin(req);
            this.projectStandardsService.saveCheck(check);
            t.commitV("Project standards check with id '%s' has been saved", new Object[]{check.id});
            ProjectStandardsCheck projectStandardsCheck = check;
            return projectStandardsCheck;
        }
    }

    @AuditedCall(value={"msgType", "project-standards-check-delete"})
    @RequestMapping(value={"/api/project-standards/checks/{checkId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteCheck(HttpServletRequest req, HttpServletResponse resp, @PathVariable String checkId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.authService.failIfNotAdmin(req);
            this.projectStandardsService.deleteCheck(checkId);
            t.commitV("Project standards check with id '%s' has been deleted", new Object[]{checkId});
        }
    }

    @AuditedCall(value={"msgType", "project-standards-check-batch-delete"})
    @RequestMapping(value={"/api/project-standards/checks-batch-delete"}, method={RequestMethod.POST})
    @ResponseBody
    public void deleteChecks(HttpServletRequest req, HttpServletResponse resp, @RequestParam List<String> checkIds) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.authService.failIfNotAdmin(req);
            HashSet<String> checkIdsSet = new HashSet<String>(checkIds);
            this.projectStandardsService.deleteChecks(checkIdsSet);
            t.commitV("Project standards checks with ids '%s' has been deleted", new Object[]{checkIds});
        }
    }

    @AuditedCall(value={"msgType", "project-standards-checks-get"})
    @RequestMapping(value={"/api/project-standards/checks"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ProjectStandardsCheck> getChecks(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            List<ProjectStandardsCheck> list = this.projectStandardsService.getChecksUnsafe();
            return list;
        }
    }

    @AuditedCall(value={"msgType", "project-standards-scopes-get"})
    @RequestMapping(value={"/api/project-standards/scopes"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ProjectStandardsScope> getScopes(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            List<ProjectStandardsScope> list = this.projectStandardsService.getScopesUnsafe();
            return list;
        }
    }

    @AuditedCall(value={"msgType", "project-standards-scope-create"})
    @RequestMapping(value={"/api/project-standards/scopes/{scopeName}"}, method={RequestMethod.POST})
    @ResponseBody
    public ProjectStandardsScope createScope(HttpServletRequest req, HttpServletResponse resp, @PathVariable String scopeName, @RequestParam ProjectStandardsScope newScope) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)newScope.name) && !newScope.name.equals(scopeName)) {
            throw new IllegalArgumentException(String.format("Name of the scope '%s' should be null or equal to the name in the URL path '%s'", newScope.name, scopeName));
        }
        newScope.name = scopeName;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.authService.failIfNotAdmin(req);
            this.projectStandardsService.createScope(newScope);
            t.commitV("One project standards scope with name '%s' has been created", new Object[]{newScope.name});
            ProjectStandardsScope projectStandardsScope = newScope;
            return projectStandardsScope;
        }
    }

    @AuditedCall(value={"msgType", "project-standards-scope-save"})
    @RequestMapping(value={"/api/project-standards/scopes/{scopeName}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ProjectStandardsScope saveScope(HttpServletRequest req, HttpServletResponse resp, @PathVariable String scopeName, @RequestParam ProjectStandardsScope updatedScope) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)updatedScope.name) && !updatedScope.name.equals(scopeName)) {
            throw new IllegalArgumentException(String.format("Name of the scope '%s' should be null or equal to the name in the URL path '%s'", updatedScope.name, scopeName));
        }
        updatedScope.name = scopeName;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.authService.failIfNotAdmin(req);
            ProjectStandardsScope savedScope = this.projectStandardsService.saveScope(updatedScope);
            t.commitV("Project standards scope with name '%s' has been saved", new Object[]{updatedScope.name});
            ProjectStandardsScope projectStandardsScope = savedScope;
            return projectStandardsScope;
        }
    }

    @AuditedCall(value={"msgType", "project-standards-scope-delete"})
    @RequestMapping(value={"/api/project-standards/scopes/{scopeName}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteScope(HttpServletRequest req, HttpServletResponse resp, @PathVariable String scopeName) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.authService.failIfNotAdmin(req);
            this.projectStandardsService.deleteScope(scopeName);
            t.commitV("Project standards scope with name '%s' has been deleted", new Object[]{scopeName});
        }
    }

    @AuditedCall(value={"msgType", "project-standards-scope-reorder"})
    @RequestMapping(value={"/api/project-standards/scopes/{scopeName}/reorder"}, method={RequestMethod.POST})
    @ResponseBody
    public void reorderScope(HttpServletRequest req, HttpServletResponse resp, @PathVariable String scopeName, @RequestParam int index) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.authService.failIfNotAdmin(req);
            this.projectStandardsService.reorderScope(scopeName, index);
            t.commitV("Project standards scope with name '%s' has been moved at index %s", new Object[]{scopeName, index});
        }
    }

    @AuditedCall(value={"msgType", "project-standards-scope-for-project", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/project-standards/scope-for-project"})
    @ResponseBody
    public ProjectStandardsScope getScopeForProject(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return this.projectStandardsService.getScopeForProject(projectKey);
    }

    @AuditedCall(value={"msgType", "project-standards-run", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/project-standards/run"})
    @ResponseBody
    public FutureResponse<ProjectStandardsRunReport> run(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(required=false) String bundleId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        return this.projectStandardsService.run_NT(authCtx, projectKey, null, bundleId);
    }

    @AuditedCall(value={"msgType", "project-standards-last-report", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/project-standards/last-report"}, method={RequestMethod.GET})
    @ResponseBody
    public ProjectStandardsRunReport getLastReport(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return this.projectStandardsService.getLastReport(projectKey);
    }

    @AuditedCall(value={"msgType", "project-standards-list-tags"})
    @RequestMapping(value={"/api/project-standards/list-all-tags"})
    @ResponseBody
    public Set<String> listAllTags(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            Set<String> set = this.projectStandardsService.listAllTags();
            return set;
        }
    }

    @AuditedCall(value={"msgType", "project-standards-general-parameters-get"})
    @RequestMapping(value={"/api/project-standards/general-parameters"}, method={RequestMethod.GET})
    @ResponseBody
    public ProjectStandardsGeneralParameters getGeneralParameters(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            ProjectStandardsGeneralParameters projectStandardsGeneralParameters = this.projectStandardsService.getGeneralParametersUnsafe();
            return projectStandardsGeneralParameters;
        }
    }

    @AuditedCall(value={"msgType", "project-standards-general-parameters-set"})
    @RequestMapping(value={"/api/project-standards/general-parameters"}, method={RequestMethod.POST})
    public void setGeneralParameters(HttpServletRequest req, HttpServletResponse resp, @RequestParam ProjectStandardsGeneralParameters generalParameters) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.authService.failIfNotAdmin(req);
            this.projectStandardsService.setGeneralParameters(generalParameters);
            t.commit("Project standards general parameters were updated");
        }
    }
}

