/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.common.server.APIError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.aigenerations.AIRecipeGenerationService;
import com.dataiku.dip.aigenerations.AISQLQueryGenerationService;
import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.HiveConnection;
import com.dataiku.dip.connections.ImpalaConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SparkConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SQLNotebooksDAO;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.export.ExportParams;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.export.ExportStatus;
import com.dataiku.dip.export.input.ExportInput;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureServiceBase;
import com.dataiku.dip.hive.MetastoreInspectionService;
import com.dataiku.dip.impala.ImpalaConfigurator;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.queries.ExecutionPlanService;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.TagFilterUtils;
import com.dataiku.dip.server.connections.ConnectionsImportController;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ConnectionsService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.SQLNotebooksService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.spark.SparkConfigurator;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sqlnotebooks.SQLNotebook;
import com.dataiku.dip.sqlnotebooks.SQLNotebookQuery;
import com.dataiku.dip.sqlnotebooks.SQLNotebookResultExploreParams;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.transactions.exceptions.TransactionBadlyFailedError;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.Id;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Lists;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public class SQLNotebooksController
extends DIPInternalControllerBase {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private SQLNotebooksService sqlNotebooksService;
    @Autowired
    private ExportService exportService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ConnectionsService connectionsService;
    @Autowired
    private TimelinesService timelinesService;
    @Autowired
    private MetastoreInspectionService metastoreInspectionService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private ExecutionPlanService executionPlanService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private SQLNotebooksDAO sqlNotebooksDAO;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private AISQLQueryGenerationService aiSqlQueryGenerationService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private LicenseStatusService licenseStatusService;
    private static final DKULogger logger = DKULogger.getLogger(SQLNotebooksController.class);

    @AuditedCall(value={"msgType", "notebooks-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/sql-notebooks/list-heads"})
    public void listHeads(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(required=false) String tagFilter) throws Exception {
        AuthCtx u;
        TagFilterUtils.TagFilter tf = (TagFilterUtils.TagFilter)JSON.parse((String)tagFilter, TagFilterUtils.TagFilter.class);
        TaggableObjectsService.FilteredTaggableItems heads = new TaggableObjectsService.FilteredTaggableItems();
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            u = this.authService.getMandatoryUser(req);
            for (SQLNotebook nbk : this.sqlNotebooksService.listWithRunningStatus(projectKey)) {
                if (!TagFilterUtils.matches(tf, nbk.tags)) {
                    ++heads.filteredOut;
                    continue;
                }
                SQLNotebook.SQLNotebookListItem head = new SQLNotebook.SQLNotebookListItem(nbk);
                this.taggableObjectsService.setEditionInfoFromTags(nbk, head);
                heads.items.add(head);
            }
        }
        this.interestsService.enrichListItems(u.getAssociatedDSSUser(), projectKey, heads.items);
        SQLNotebooksController.writeJSON((HttpServletResponse)resp, heads);
    }

    @AuditedCall(value={"msgType", "connections-list", "for", "notebooks"})
    @RequestMapping(value={"/api/sql-notebooks/list-connections"})
    public void listConnections(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        AuthCtx authCtx;
        NotebookConnectionListing ret = new NotebookConnectionListing();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkReadProjectContentAllowed(authCtx);
            for (Map.Entry<String, DSSConnection> entry : this.connectionsService.listUnsafe().entrySet()) {
                DSSConnection conn = entry.getValue();
                try {
                    if (!(conn instanceof AbstractSQLConnection) || !conn.isFreelyUsableBy(authCtx)) continue;
                    AbstractSQLConnection sqlConn = (AbstractSQLConnection)conn;
                    NotebookConnection nconn = new NotebookConnection();
                    nconn.name = entry.getKey();
                    nconn.type = sqlConn.getType();
                    AbstractSQLConnection.AbstractSQLParams params = sqlConn.getParams();
                    if (params instanceof AbstractSQLConnection.AbstractSQLParamsWithStdFields) {
                        nconn.hostname = ((AbstractSQLConnection.AbstractSQLParamsWithStdFields)params).host;
                        nconn.database = ((AbstractSQLConnection.AbstractSQLParamsWithStdFields)params).db;
                    } else if (sqlConn instanceof HiveConnection) {
                        nconn.database = ((HiveConnection)sqlConn).getDatabaseName();
                    } else if (sqlConn instanceof ImpalaConnection) {
                        nconn.database = ((ImpalaConnection)sqlConn).getDatabaseName();
                    } else if (sqlConn instanceof SparkConnection) {
                        nconn.database = ((SparkConnection)sqlConn).getDatabaseName();
                    }
                    nconn.label = nconn.name;
                    Params p = sqlConn.getDkuPropertiesAsParams();
                    if (!p.getBoolParam("dku.connection.sql.allowCatalogAndSchemaDropdownInput", true)) {
                        nconn.defaultCatalogAndSchemaInputMode = ConnectionsImportController.CatalogAndSchemaInputMode.FREE_TEXT;
                        nconn.allowCatalogAndSchemaFreeTextInput = true;
                        nconn.allowCatalogAndSchemaDropdownInput = false;
                    }
                    if (p.getBoolParam("dku.connection.sql.allowCatalogAndSchemaFreeTextInput", false)) {
                        nconn.allowCatalogAndSchemaFreeTextInput = true;
                    }
                    nconn.defaultCatalog = p.getParam("dku.connection.sql.defaultCatalogForTablesListing");
                    nconn.defaultSchema = p.getParam("dku.connection.sql.defaultSchemaForTablesListing");
                    ret.nconns.add(nconn);
                }
                catch (IllegalArgumentException e) {
                    logger.error((Object)("Failed to read connection during list-connections: " + conn.name), (Throwable)e);
                }
            }
        }
        MetastoreInspectionService.MetastoreKind metastoreKind = this.metastoreInspectionService.getMetastoreKind(authCtx, projectKey);
        AbstractSparkRecipeParams.SparkExecutionEngine interactiveSparkExecutionEngine = SparkConfigurator.interactiveSparkSQLExecutionEngine(authCtx, projectKey);
        if (metastoreKind != null) {
            String clusterId = new ClusterSelector().getClusterForProject(projectKey, Cluster.ClusterArchitecture.HADOOP);
            try {
                for (String db : this.metastoreInspectionService.newInspector(metastoreKind).listHiveDatabase(clusterId, "default", authCtx, projectKey)) {
                    if (interactiveSparkExecutionEngine != null) {
                        NotebookConnection nconnSpark = new NotebookConnection();
                        switch (interactiveSparkExecutionEngine) {
                            case SPARK_SUBMIT: {
                                nconnSpark.name = "@virtual(spark-livy):" + db;
                                break;
                            }
                            default: {
                                throw new Error("Unsupported execution engine: " + String.valueOf((Object)interactiveSparkExecutionEngine));
                            }
                        }
                        nconnSpark.type = "SparkSQL";
                        nconnSpark.label = db;
                        nconnSpark.database = db;
                        ret.nconns.add(nconnSpark);
                    }
                    if (metastoreKind == MetastoreInspectionService.MetastoreKind.HIVE_VIA_HS2 && ImpalaConfigurator.impalaAvailable(authCtx, projectKey)) {
                        NotebookConnection nconnImpala = new NotebookConnection();
                        nconnImpala.name = "@virtual(impala-jdbc):" + db;
                        nconnImpala.type = "Impala";
                        nconnImpala.label = db;
                        nconnImpala.database = db;
                        ret.nconns.add(nconnImpala);
                    }
                    if (metastoreKind != MetastoreInspectionService.MetastoreKind.HIVE_VIA_HS2 && metastoreKind != MetastoreInspectionService.MetastoreKind.AWS_GLUE) continue;
                    NotebookConnection nconnHive = new NotebookConnection();
                    nconnHive.name = "@virtual(hive-jdbc):" + db;
                    nconnHive.type = "HiveServer2";
                    nconnHive.database = db;
                    nconnHive.label = db;
                    ret.nconns.add(nconnHive);
                }
            }
            catch (Exception e) {
                ret.hiveError = new APIError((Throwable)e, true);
                logger.error((Object)"Failed to list hive databases", (Throwable)e);
            }
        }
        if (interactiveSparkExecutionEngine == AbstractSparkRecipeParams.SparkExecutionEngine.SPARK_SUBMIT && ApplicationConfigurator.getParams().getBoolParam("dku.sparksqlnotebook_with_dsscatalog.enabled", false) && SparkConfigurator.interactiveSparkSQLSparkVersion(authCtx, projectKey).startsWith("3.")) {
            String db = "default";
            NotebookConnection nconnSpark = new NotebookConnection();
            nconnSpark.name = "@virtual(spark-livy):" + db;
            nconnSpark.type = "SparkSQL";
            nconnSpark.label = db;
            nconnSpark.database = db;
            ret.nconns.add(nconnSpark);
        }
        SQLNotebooksController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "notebook-read-meta", "projectKey", "${projectKey}", "notebookId", "${id}"})
    @RequestMapping(value={"/api/sql-notebooks/get"})
    public void get(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        SQLNotebook notebook;
        ErrorContext.checkNotEmpty((String)id, (String)"notebook id");
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            notebook = this.sqlNotebooksService.getOrNullUnsafe(projectKey, id);
        }
        SQLNotebooksController.writeJSON((HttpServletResponse)resp, (Object)notebook);
    }

    @AuditedCall(value={"msgType", "generate-sql-query", "projectKey", "${projectKey}", "query", "${id}"})
    @RequestMapping(value={"/api/sql-notebooks/generate-query"})
    @ResponseBody
    public FutureResponse<AISQLQueryGenerationService.AISqlQueryGenerationFrontendResponse> generateSQLQuery(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String query, @RequestParam String name) throws Exception {
        List datasets;
        AbstractSQLConnection sqlConnection;
        AuthCtx liu;
        ArrayList<String> sqlTableSchemas = new ArrayList<String>();
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            DSSConnection conn = this.connectionsDAO.getMandatoryConnection(liu, name);
            if (!conn.isFreelyUsableBy(liu)) {
                throw new SecurityException("You may not list tables on connection " + name);
            }
            this.aiSqlQueryGenerationService.checkUserCanUseAISQLGeneration();
            sqlConnection = SQLConnectionProvider.getDSSConnection(liu, name);
            datasets = this.datasetsDAO.listUnsafe(projectKey);
        }
        SQLDialect dialect = sqlConnection.getDialect();
        sqlConnection.getConnectionData_NT(liu, projectKey);
        for (SerializedDataset sds : datasets) {
            if (!(sds.getParams() instanceof AbstractSQLDatasetHandler.AbstractSQLConfig)) continue;
            AbstractSQLDatasetHandler.AbstractSQLConfig config = ((AbstractSQLDatasetHandler.AbstractSQLConfig)sds.getParams()).getResolved(projectKey);
            if (config.connection == null || !config.connection.equals(name) || StringUtils.isBlank((String)config.table)) continue;
            try {
                sqlTableSchemas.add(dialect.getCreateTableStatementSQL(sqlConnection, Dataset.fromSerialized(sds), new InfoMessage.InfoMessages(), false));
            }
            catch (IllegalArgumentException e) {
                logger.warn((Object)e);
            }
        }
        NotebookAISqlQueryGenerationFutureThread futureThread = new NotebookAISqlQueryGenerationFutureThread(liu, projectKey, sqlTableSchemas, query, sqlConnection);
        return this.aiSqlQueryGenerationService.startGeneration(futureThread);
    }

    @AuditedCall(value={"msgType", "notebook-read-meta", "projectKey", "${projectKey}", "notebookId", "${id}"})
    @RequestMapping(value={"/api/sql-notebooks/get-summary"})
    public void getSummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        AuthCtx authCtx;
        TaggableObjectsService.TaggableObjectSummary summ = new TaggableObjectsService.TaggableObjectSummary();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            summ.object = this.sqlNotebooksService.getMandatoryUnsafe(projectKey, id);
        }
        summ.timeline = this.timelinesService.getObjectTimeline_NT(summ.object.getTaggableType(), projectKey, id, summ.object.creationTag, summ.object.versionTag, 0, 100);
        summ.interest = this.interestsService.getObjectAndUserInterest_noFail(authCtx, summ.object.getTaggableType(), projectKey, id);
        SQLNotebooksController.writeJSON((HttpServletResponse)resp, (Object)summ);
    }

    @AuditedCall(value={"msgType", "notebook-result-read-explore-script", "projectKey", "${projectKey}", "notebookId", "${id}"})
    @RequestMapping(value={"/api/sql-notebooks/get-explore-script"})
    @ResponseBody
    public SerializedShakerScript getExploreParams(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String notebookId, @RequestParam String cellId) throws Exception {
        SerializedShakerScript cellExploreScript;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            cellExploreScript = this.sqlNotebooksService.getExploreScript(projectKey, notebookId, cellId);
        }
        return cellExploreScript;
    }

    @AuditedCall(value={"msgType", "notebook-result-save-explore-script", "projectKey", "${projectKey}", "notebookId", "${id}"})
    @RequestMapping(value={"/api/sql-notebooks/save-explore-script"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public void saveExploreParams(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String notebookId, @RequestParam String cellId, @RequestParam SerializedShakerScript exploreScript) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.sqlNotebooksService.saveExploreScript(projectKey, notebookId, cellId, exploreScript);
            t.commit("Saved explore script for SQL notebook " + notebookId + " in project " + projectKey);
        }
    }

    @AuditedCall(value={"msgType", "notebook-result-read-explore-chart", "projectKey", "${projectKey}", "notebookId", "${id}"})
    @RequestMapping(value={"/api/sql-notebooks/get-explore-chart"})
    @ResponseBody
    public SQLNotebookResultExploreParams.ChartParams getExploreChart(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String notebookId, @RequestParam String cellId) throws Exception {
        SQLNotebookResultExploreParams.ChartParams chartParams;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            chartParams = this.sqlNotebooksService.getExploreChart(projectKey, notebookId, cellId);
        }
        return chartParams;
    }

    @AuditedCall(value={"msgType", "notebook-result-save-explore-chart", "projectKey", "${projectKey}", "notebookId", "${id}"})
    @RequestMapping(value={"/api/sql-notebooks/save-explore-chart"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public void saveExploreChart(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String notebookId, @RequestParam String cellId, @RequestParam SQLNotebookResultExploreParams.ChartParams exploreChart) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.sqlNotebooksService.saveExploreChart(projectKey, notebookId, cellId, exploreChart);
            t.commit("Saved explore charts for SQL notebook " + notebookId + " in project " + projectKey);
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/sql-notebooks/copy"})
    public void copy(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String notebookId, @RequestParam String newNotebookName) throws Exception {
        Id newId;
        ErrorContext.checkNotEmpty((String)notebookId, (String)"notebook id");
        ErrorContext.checkNotEmpty((String)newNotebookName, (String)"new notebook name");
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            newId = new Id(this.sqlNotebooksService.copy(user, projectKey, notebookId, newNotebookName));
            t.commit("Copied SQL notebook to " + projectKey + "." + newId.id);
            this.auditTrailService.generic("sql-notebook-copy").with("projectKey", projectKey).with("sourceId", notebookId).with("newId", newId.id).emit();
        }
        SQLNotebooksController.writeJSON((HttpServletResponse)resp, (Object)newId);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/sql-notebooks/test-streamed-export"})
    public void testStreamedExport(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String notebookId, @RequestParam String cellId, @RequestParam String qid) throws Exception {
        HashMap<String, Boolean> rv = new HashMap<String, Boolean>();
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            rv.put("streamedExportAvailable", this.sqlNotebooksService.testStreamedExport(t, projectKey, notebookId, cellId, qid));
        }
        SQLNotebooksController.writeJSON((HttpServletResponse)resp, rv);
    }

    @AuditInline
    @RequestMapping(value={"/api/sql-notebooks/save"})
    public void save(HttpServletRequest req, HttpServletResponse resp, @RequestParam String notebook, @RequestParam(required=false) String saveInfo) throws TransactionBadlyFailedError, Exception {
        SQLNotebook newNotebook;
        ErrorContext.checkNotEmpty((String)notebook, (String)"notebook data");
        TaggableObjectsService.TaggableObjectSaveInfo si = TaggableObjectsService.TaggableObjectSaveInfo.parse(saveInfo);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            SQLNotebook snb = (SQLNotebook)JSON.parse((String)notebook, SQLNotebook.class);
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(u, snb.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.connectionsService.checkUserForConnection(u, snb.connection);
            newNotebook = this.sqlNotebooksService.save(snb, si.summaryOnly);
            if (si.summaryOnly) {
                t.commit("Updated summary for SQL notebook " + snb.projectKey + "." + snb.name + " (id: " + snb.id + ")", 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
            } else {
                t.commit("Saved settings for SQL notebook " + snb.projectKey + "." + snb.name + " (id: " + snb.id + ")");
            }
            this.auditTrailService.generic("sql-notebook-save").with("projectKey", snb.projectKey).with("notebookId", snb.id).emit();
        }
        SQLNotebooksController.writeJSON((HttpServletResponse)resp, (Object)newNotebook);
    }

    @AuditedCall(value={"msgType", "notebook-read-history", "projectKey", "${projectKey}", "notebookId", "${notebookId}"})
    @RequestMapping(value={"/api/sql-notebooks/get-history"})
    public void getHistory(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String notebookId) throws Exception {
        Map<String, List<SQLNotebookQuery>> history;
        ErrorContext.checkNotEmpty((String)notebookId, (String)"notebook id");
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            boolean keepFutureIdInResponse = false;
            if (this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF)) {
                keepFutureIdInResponse = true;
            } else {
                this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            }
            history = this.sqlNotebooksService.getHistory(projectKey, notebookId, keepFutureIdInResponse);
        }
        SQLNotebooksController.writeJSON((HttpServletResponse)resp, history);
    }

    @AuditedCall(value={"msgType", "notebook-read-history", "projectKey", "${projectKey}", "notebookId", "${notebookId}"})
    @RequestMapping(value={"/api/sql-notebooks/get-cell-history"})
    public void getCellHistory(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String notebookId, @RequestParam String cellId) throws Exception {
        ArrayList cellHistory;
        ErrorContext.checkNotEmpty((String)notebookId, (String)"notebook id");
        ErrorContext.checkNotEmpty((String)cellId, (String)"cell id");
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            boolean keepFutureIdInResponse = false;
            if (this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF)) {
                keepFutureIdInResponse = true;
            } else {
                this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            }
            Map<String, List<SQLNotebookQuery>> notebookHistory = this.sqlNotebooksService.getHistory(projectKey, notebookId, keepFutureIdInResponse);
            cellHistory = notebookHistory.get(cellId);
            if (cellHistory == null) {
                cellHistory = Lists.newArrayList();
            }
        }
        SQLNotebooksController.writeJSON((HttpServletResponse)resp, (Object)cellHistory);
    }

    @AuditedCall(value={"msgType", "notebook-save", "projectKey", "${projectKey}", "notebookId", "${notebookId}"})
    @RequestMapping(value={"/api/sql-notebooks/remove-query"})
    public void removeQuery(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String notebookId, @RequestParam String cellId, @RequestParam String qid) throws Exception {
        ErrorContext.checkNotEmpty((String)notebookId, (String)"notebook id");
        ErrorContext.checkNotEmpty((String)qid, (String)"query id");
        AuthCtx liu = null;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        this.sqlNotebooksService.removeQuery_NT(liu, projectKey, notebookId, cellId, qid);
    }

    @AuditedCall(value={"msgType", "notebook-save", "projectKey", "${projectKey}", "notebookId", "${notebookId}"})
    @RequestMapping(value={"/api/sql-notebooks/clear-history"})
    public void clearHistory(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String notebookId, @RequestParam String cellId) throws Exception {
        ErrorContext.checkNotEmpty((String)notebookId, (String)"notebook id");
        ErrorContext.checkNotEmpty((String)cellId, (String)"cell id");
        AuthCtx liu = null;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        this.sqlNotebooksService.clearHistory_NT(liu, projectKey, notebookId, cellId);
    }

    @AuditInline
    @RequestMapping(value={"/api/sql-notebooks/create"})
    public void create(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String connection, @RequestParam String name) throws Exception {
        Id newId;
        ErrorContext.checkNotEmpty((String)connection, (String)"connection name");
        ErrorContext.checkNotEmpty((String)name, (String)"notebook name");
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            newId = new Id(this.sqlNotebooksService.create(user, projectKey, connection, name, null));
            t.commit("Created SQL notebook " + projectKey + "." + newId.id);
            this.auditTrailService.generic("sql-notebook-create").with("projectKey", projectKey).with("connection", connection).with("notebookId", newId.id).emit();
        }
        SQLNotebooksController.writeJSON((HttpServletResponse)resp, (Object)newId);
    }

    @AuditInline
    @RequestMapping(value={"/api/sql-notebooks/create-for-dataset"})
    public void createForDataset(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetSmartName, @RequestParam(required=false) String type, @RequestParam(required=false) String name) throws Exception {
        Id newId;
        ConnectionsDAO.VirtualConnectionType connType = null;
        if (StringUtils.isNotBlank((String)type)) {
            for (ConnectionsDAO.VirtualConnectionType t : ConnectionsDAO.VirtualConnectionType.values()) {
                if (!t.getId().equals(type)) continue;
                connType = t;
                break;
            }
        }
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            newId = new Id(this.sqlNotebooksService.createForDataset(user, projectKey, datasetSmartName, connType, name));
            t.commit("Created SQL notebook " + projectKey + "." + newId.id + " for dataset " + datasetSmartName);
            this.auditTrailService.generic("sql-notebook-create").with("projectKey", projectKey).with("dataset", datasetSmartName).with("notebookId", newId.id).emit();
        }
        SQLNotebooksController.writeJSON((HttpServletResponse)resp, (Object)newId);
    }

    @AuditInline
    @RequestMapping(value={"/api/sql-notebooks/run"}, method={RequestMethod.POST})
    public void run(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String notebookId, @RequestParam String cellId, @RequestParam String queryData, @RequestParam boolean fullCount) throws TransactionBadlyFailedError, Exception {
        SQLNotebooksDAO.StartedQuery startedQuery;
        ErrorContext.checkNotEmpty((String)notebookId, (String)"notebook id");
        ErrorContext.checkNotEmpty((String)cellId, (String)"cell id");
        ErrorContext.checkNotEmpty((String)queryData, (String)"query data");
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            ErrorContext.checkNotEmpty((String)notebookId, (String)"query id");
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkSQLAllowed(user);
            SQLNotebookQuery q = (SQLNotebookQuery)JSON.parse((String)queryData, SQLNotebookQuery.class);
            startedQuery = this.sqlNotebooksService.run(projectKey, notebookId, cellId, q, fullCount, user);
            t.commit("Execute a new query in SQL notebook " + projectKey + "." + notebookId, 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
            this.auditTrailService.generic("sql-notebook-execute").with("projectKey", projectKey).with("notebookId", notebookId).with("connection", startedQuery.toAddtoHistory.connection).with("query", startedQuery.toAddtoHistory.getUnexpandedSQL()).emit();
        }
        SQLNotebooksController.writeJSON((HttpServletResponse)resp, (Object)startedQuery);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/sql-notebooks/full-count"}, method={RequestMethod.POST})
    public void fullCount(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String notebookId, @RequestParam String cellId, @RequestParam String qid) throws Exception {
        SQLNotebooksDAO.StartedQuery startedQuery;
        ErrorContext.checkNotEmpty((String)notebookId, (String)"notebook id");
        ErrorContext.checkNotEmpty((String)cellId, (String)"cell id");
        ErrorContext.checkNotEmpty((String)qid, (String)"query id");
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            startedQuery = this.sqlNotebooksService.computeFullCount(projectKey, notebookId, cellId, qid, this.authService.getMandatoryUser(req));
            t.commit("Compute full count of query in SQL notebook " + projectKey + "." + notebookId, 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
        }
        SQLNotebooksController.writeJSON((HttpServletResponse)resp, (Object)startedQuery);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/sql-notebooks/get-execution-plan"}, method={RequestMethod.POST})
    public void executionPlan(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String queryData) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        SQLNotebooksService.SQLQueryExecutionPlanResult results = this.sqlNotebooksService.getExecutionPlan(projectKey, queryData, authCtx);
        SQLNotebooksController.writeJSON((HttpServletResponse)resp, (Object)results);
    }

    @AuditedCall(value={"msgType", "notebook-read-history", "projectKey", "${projectKey}", "notebookId", "${notebookId}"})
    @RequestMapping(value={"/api/sql-notebooks/get-history-result"})
    public void getHistoryResult(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String notebookId, @RequestParam String qid) throws Exception {
        QueryRunResult qrr;
        ErrorContext.checkNotEmpty((String)notebookId, (String)"notebook id");
        ErrorContext.checkNotEmpty((String)qid, (String)"query id");
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            qrr = this.sqlNotebooksService.getHistoryResult(projectKey, notebookId, qid);
            if (qrr == null) {
                qrr = new QueryRunResult();
                qrr.success = false;
                qrr.errorMessage = "No results available for query " + qid;
            }
        }
        SQLNotebooksController.writeJSON((HttpServletResponse)resp, (Object)qrr);
    }

    @AuditedCall(value={"msgType", "notebook-query-abort", "projectKey", "${projectKey}", "notebookId", "${notebookId}"})
    @RequestMapping(value={"/api/sql-notebooks/abort"})
    public void abort(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String notebookId, @RequestParam String cellId, @RequestParam String qid) throws Exception {
        ErrorContext.checkNotEmpty((String)notebookId, (String)"notebook id");
        ErrorContext.checkNotEmpty((String)cellId, (String)"cell id");
        ErrorContext.checkNotEmpty((String)qid, (String)"query id");
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        try {
            this.sqlNotebooksService.abort_NT(projectKey, notebookId, cellId, qid);
        }
        catch (FutureServiceBase.JobNotFoundException e) {
            logger.warn((Object)"Failed to abort job", (Throwable)e);
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/sql-notebooks/get-progress"})
    public void getProgress(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String notebookId, @RequestParam String cellId, @RequestParam String qid) throws Exception {
        ErrorContext.checkNotEmpty((String)notebookId, (String)"notebook id");
        ErrorContext.checkNotEmpty((String)cellId, (String)"cell id");
        ErrorContext.checkNotEmpty((String)qid, (String)"query id");
        boolean keepFutureIdInResponse = false;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            if (this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF)) {
                keepFutureIdInResponse = true;
            } else {
                this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            }
        }
        SQLNotebooksDAO.ProgressStatus progressStatusNt = this.sqlNotebooksService.getProgressStatus_NT(projectKey, notebookId, cellId, qid);
        if (!keepFutureIdInResponse && progressStatusNt.query != null) {
            progressStatusNt.query.futureId = null;
        }
        SQLNotebooksController.writeJSON((HttpServletResponse)resp, (Object)progressStatusNt);
    }

    @AuditedCall(value={"msgType", "sql-notebook-export-results", "projectKey", "${projectKey}", "notebookId", "${notebookId}"})
    @RequestMapping(value={"/api/sql-notebooks/export-results"})
    public void export(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String notebookId, @RequestParam String cellId, @RequestParam String qid, @RequestParam String params) throws Exception {
        ExportStatus ret;
        ErrorContext.checkNotEmpty((String)notebookId, (String)"notebook id");
        ErrorContext.checkNotEmpty((String)cellId, (String)"cell id");
        ErrorContext.checkNotEmpty((String)qid, (String)"query id");
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF, Privileges.ProjectLevelPrivilegeType.EXPORT_DATASETS_DATA);
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            ExportInput data = this.sqlNotebooksService.createExporter(t, projectKey, notebookId, cellId, qid, authCtx);
            ExportParams exportParams = (ExportParams)JSON.parse((String)params, ExportParams.class);
            exportParams.contextProjectKey = projectKey;
            exportParams.filenameBase = "sql_notebook_results_" + qid;
            ret = this.exportService.handleExportRequest(this.authService.getUser(req), data, exportParams);
        }
        SQLNotebooksController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditInline
    @RequestMapping(value={"/api/sql-notebooks/save-back-to-recipe"}, method={RequestMethod.POST})
    public void saveBackToRecipe(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String notebookId, @RequestParam String sql) throws IOException, DKUSecurityException {
        AnyLoc recipeLoc;
        ErrorContext.checkNotEmpty((String)projectKey, (String)"project id");
        ErrorContext.checkNotEmpty((String)notebookId, (String)"notebook id");
        ErrorContext.checkNotNull((Object)sql, (String)"sql");
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(u, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            SQLNotebook sqlNotebook = this.sqlNotebooksService.getMandatory(projectKey, notebookId);
            recipeLoc = AnyLoc.resolveSmart(projectKey, sqlNotebook.recipeId);
            SerializedRecipe sqlQueryRecipe = (SerializedRecipe)this.recipesDAO.getOrNull(recipeLoc);
            if (sqlQueryRecipe == null) {
                logger.warnV("Cannot save query from SQL notebook '%s' back to recipe '%s' as it does not exist", new Object[]{notebookId, sqlNotebook.recipeId});
                recipeLoc = new AnyLoc(projectKey, null);
            } else {
                ErrorContext.check((boolean)Objects.equals(sqlQueryRecipe.type, "sql_query"), (String)"Recipe is not a SQL query recipe");
                if (!Objects.equals(StringUtils.trim((String)this.recipesDAO.getPayloadOrNull(projectKey, sqlNotebook.recipeId)), StringUtils.trim((String)sql))) {
                    this.recipesDAO.save(projectKey, sqlNotebook.recipeId, sqlQueryRecipe, StringUtils.trim((String)sql));
                    t.commitV("SQL query recipe '%s' saved through notebook '%s'", new Object[]{recipeLoc, notebookId});
                    this.auditTrailService.generic("save-back-to-recipe").with("projectKey", projectKey).with("notebookId", notebookId).with("recipeName", sqlQueryRecipe.name).emit();
                }
            }
        }
        SQLNotebooksController.writeJSON((HttpServletResponse)resp, (Object)recipeLoc);
    }

    public static class NotebookConnectionListing {
        List<NotebookConnection> nconns = new ArrayList<NotebookConnection>();
        public APIError hiveError;
    }

    @UIModel
    public static class NotebookConnection {
        public String name;
        public String type;
        public String database;
        public String hostname;
        public String label;
        public ConnectionsImportController.CatalogAndSchemaInputMode defaultCatalogAndSchemaInputMode = ConnectionsImportController.CatalogAndSchemaInputMode.DROPDOWN;
        public boolean allowCatalogAndSchemaFreeTextInput = false;
        public boolean allowCatalogAndSchemaDropdownInput = true;
        public String defaultCatalog;
        public String defaultSchema;
    }

    private class NotebookAISqlQueryGenerationFutureThread
    extends AISQLQueryGenerationService.AbstractAISqlQueryGenerationFutureThread {
        public NotebookAISqlQueryGenerationFutureThread(AuthCtx owner, String projectKey, List<String> sqlTableSchemas, String query, AbstractSQLConnection connection) {
            super(owner, projectKey, sqlTableSchemas, query, connection, SQLNotebooksController.this.licenseStatusService.getLicensingStatus(), AISQLQueryGenerationService.QueryOrigin.SQL_NOTEBOOK);
        }

        @Override
        protected void validateQuery(AISQLQueryGenerationService.AISqlQueryGenerationFrontendResponse response) throws AISQLQueryGenerationService.QueryValidationError {
            try {
                SQLNotebookQuery sqlNotebookQuery = new SQLNotebookQuery();
                sqlNotebookQuery.id = "bla";
                sqlNotebookQuery.connection = this.connection.name;
                sqlNotebookQuery.updateUnexpandedSQL(response.sqlQuery);
                SQLNotebooksService.SQLQueryExecutionPlanResult results = SQLNotebooksController.this.sqlNotebooksService.getExecutionPlan(this.projectKey, JSON.gson().toJson((Object)sqlNotebookQuery), this.authCtx);
                if (results.failedToComputeExecutionPlan) {
                    throw new AISQLQueryGenerationService.QueryValidationError("Failed to compute execution plan", response.sqlQuery, response.queryName, response.reasoning, AIRecipeGenerationService.CreationMessage.Level.ERROR);
                }
            }
            catch (Exception e) {
                throw new AISQLQueryGenerationService.QueryValidationError(e.getMessage(), response.sqlQuery, response.queryName, response.reasoning, AIRecipeGenerationService.CreationMessage.Level.ERROR);
            }
        }
    }
}

