/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers.analysis;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.interactivemodel.InteractiveModelParams;
import com.dataiku.dip.analysis.ml.interactivemodel.InteractiveModelResponse;
import com.dataiku.dip.analysis.ml.interactivemodel.InteractiveModelService;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class InteractiveModelController
extends DIPInternalControllerBase {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private InteractiveModelService interactiveModelService;

    @AuditedCall(value={"msgType", "ml-interactive-model-compute", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/interactive-model/compute"})
    @ResponseBody
    public FutureResponse<InteractiveModelResponse.InteractiveModelResult[]> compute(HttpServletRequest req, @RequestParam String fullModelId, @RequestParam InteractiveModelParams.ComputationParams computationParams, @RequestParam List<JsonObject> records, @RequestParam boolean computeEvenIfCached) throws Exception {
        AuthCtx user;
        FullModelId fmi = FullModelId.parse(fullModelId);
        try (Transaction ignored = this.transactionService.beginRead();){
            if (fmi.getType().equals((Object)FullModelId.Type.ANALYSIS)) {
                this.projectsService.checkPerm(req, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
            } else {
                SmartObjectRef smartObjectRef = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.SAVED_MODEL, fmi.getId());
                this.projectsService.failIfNoDashboardReadPermission(req, smartObjectRef, fmi.getProjectKey());
            }
            user = this.authService.getUser(req);
        }
        return this.interactiveModelService.compute_NT(user, fmi, computationParams, records, computeEvenIfCached);
    }
}

