/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.t;

import com.dataiku.dip.analysis.ml.MLPluginsService;
import com.dataiku.dip.analysis.model.core.PreTrainModelingParams;
import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.cluster.ClusterRegistry;
import com.dataiku.dip.cluster.PythonPluginClusterHandler;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.AbstractElementLoadedDesc;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.model.InstalledPluginDesc;
import com.dataiku.dip.scheduler.runnables.DSSRunnableRegistry;
import com.dataiku.dip.scheduler.runnables.DSSRunnableThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.AuthCtxCreationService;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.PublicAPIKeyAuthService;
import com.dataiku.dip.security.auth.TicketAuthService;
import com.dataiku.dip.security.model.ProjectScopePublicAPIKey;
import com.dataiku.dip.security.model.PublicAPIKey;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.PluginsController;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppMeta;
import com.dataiku.dip.webapps.WebAppRegistry;
import com.dataiku.dip.webapps.WebAppsService;
import com.dataiku.dip.webapps.backend.WebAppBackendRunner;
import com.dataiku.dip.webapps.plugins.CustomWebAppMeta;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class PluginIntercomController
extends DIPInternalControllerBase {
    @Autowired
    TransactionService transactionService;
    @Autowired
    IPluginsRegistryService pluginsRegistryService;
    @Autowired
    PublicAPIKeyAuthService publicAPIKeyAuthService;
    @Autowired
    TicketAuthService ticketAuthService;
    @Autowired
    PermissionsService permissionsService;
    @Autowired
    WebAppsService webAppsService;
    @Autowired
    AuthCtxCreationService authCtxCreationService;
    @Autowired
    MLPluginsService mlPluginsService;

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/plugins/get-lib-folders"})
    public void getLibFolders(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();
             APITicketService.TicketUsage tu = this.ticketAuthService.getAndUseMandTicket(req);){
            if (!tu.getAuthCtx().isSafeCodeAllowed()) {
                throw new SecurityException("You are not allowed to use code-related functions");
            }
        }
        InstalledPluginDesc installedDesc = this.pluginsRegistryService.getInstalledDesc(pluginId);
        if (installedDesc == null) {
            throw new CodedException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_INSTALLED, "Plugin " + pluginId + " not found");
        }
        PluginIntercomController.writeJSON((HttpServletResponse)resp, (Object)new PluginsController.LibFolders(this.pluginsRegistryService, pluginId));
    }

    @AuditedCall(value={"msgType", "plugins-get-ml-plugin-files", "pluginId", "${pluginId}", "elementId", "${elementId}"})
    @RequestMapping(value={"/api/tintercom/plugins/get-ml-plugin-files"})
    public void getMlPluginFiles(HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String elementId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.mlPluginsService.downloadMlPlugins(pluginId, elementId, resp);
        }
    }

    @AuditedCall(value={"msgType", "plugins-get-used-plugins", "modeling_params", "${modeling_params}"})
    @RequestMapping(value={"/api/tintercom/plugins/get-used-plugins"})
    public void getMlUsedPlugins(HttpServletResponse resp, @RequestParam String modeling_params) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            PreTrainModelingParams modeling = (PreTrainModelingParams)JSON.parse((String)modeling_params, PreTrainModelingParams.class);
            PluginIntercomController.writeJSON((HttpServletResponse)resp, this.mlPluginsService.getUsedPlugins(modeling));
        }
    }

    @AuditedCall(value={"msgType", "plugins-get-plugin-version", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/tintercom/plugins/get-plugin-version"})
    public void getMlPluginVersion(HttpServletResponse resp, @RequestParam String pluginId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            PluginIntercomController.writeJSON((HttpServletResponse)resp, (Object)this.pluginsRegistryService.getDesc((String)pluginId).version);
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/plugins/get-plugin-settings"})
    public void getPluginSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(value="params") String paramsData, @RequestParam(value="elementConfig") String elementConfigData, @RequestParam String pluginId) throws Exception {
        List params = (List)JSON.parse((String)paramsData, (TypeToken)new TypeToken<List<ParamDesc>>(){});
        JsonObject elementConfig = (JsonObject)JSON.parse((String)elementConfigData, JsonObject.class);
        try (APITicketService.TicketUsage tu = this.ticketAuthService.getAndUseMandTicket(req);){
            AuthCtx authCtx = tu.getAuthCtx();
            PluginSettingsResolver.ResolvedSettings pluginSettings = new PluginSettingsResolver(authCtx, projectKey).getPluginSettings(params, elementConfig, pluginId);
            if (pluginSettings.pluginConfig != null && !pluginSettings.pluginConfig.entrySet().isEmpty()) {
                try (Transaction t = this.transactionService.beginRead();){
                    this.permissionsService.checkPluginPrivileges(tu.getAuthCtx(), pluginId, Privileges.PluginLevelPrivilegeType.ADMIN);
                }
            }
            PluginIntercomController.writeJSON((HttpServletResponse)resp, (Object)pluginSettings);
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/plugins/get-resolved-settings"})
    public void getResolvedSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String elementType, @RequestParam(value="elementConfig") String elementConfigData) throws Exception {
        List<ParamDesc> params;
        String pluginId;
        String projectKey;
        AuthCtx authCtx;
        JsonObject elementConfig;
        block23: {
            elementConfig = (JsonObject)JSON.parse((String)elementConfigData, JsonObject.class);
            try (Transaction t = this.transactionService.beginRead();){
                if (req.getHeader("x-dku-apiticket") != null) {
                    try (APITicketService.TicketUsage usage = this.ticketAuthService.getAndUseMandTicket(req);){
                        authCtx = usage.getAuthCtx();
                        if (usage.getTicket().getPayload() instanceof DSSRunnableThread) {
                            if (StringUtils.isBlank((String)elementType)) {
                                throw new DKUSecurityException("Can't get settings for macro without specifying the target component type");
                            }
                            if (!elementType.startsWith("pycluster_")) {
                                throw new DKUSecurityException("Can't get settings for macro for a " + elementType);
                            }
                            PythonPluginClusterHandler.PythonPluginClusterMeta meta = (PythonPluginClusterHandler.PythonPluginClusterMeta)ClusterRegistry.getMeta(elementType);
                            projectKey = null;
                            pluginId = meta.getLoadedDesc().getOwnerPluginId();
                            params = meta.getLoadedDesc().getParams();
                            String runnableType = ((DSSRunnableThread)((Object)usage.getTicket().getPayload())).getRunnableType();
                            String macroPluginId = ((AbstractElementLoadedDesc)DSSRunnableRegistry.getMeta(runnableType).getLoadedDesc()).getOwnerPluginId();
                            if (!StringUtils.equals((String)pluginId, (String)macroPluginId)) {
                                throw new DKUSecurityException("Can't get settings for macro of a different plugin : macro=" + macroPluginId + " element=" + pluginId);
                            }
                            break block23;
                        }
                        if (usage.getTicket().getPayload() instanceof WebAppBackendRunner) {
                            WebApp wa = ((WebAppBackendRunner)usage.getTicket().getPayload()).getWebApp();
                            projectKey = wa.projectKey;
                            String webAppId = wa.id;
                            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                            WebAppMeta meta = WebAppRegistry.getMeta(wa.type);
                            if (!(meta instanceof CustomWebAppMeta)) {
                                throw new IllegalArgumentException("Virtual webapp " + projectKey + "." + webAppId + " is not a plugin webapp");
                            }
                            CustomWebAppMeta cmeta = (CustomWebAppMeta)meta;
                            pluginId = cmeta.getOwnerPluginId();
                            params = cmeta.getLoadedDesc().getParams();
                            break block23;
                        }
                        throw new DKUSecurityException("API Ticket doesn't belong to a webapp or a cluster action (" + String.valueOf(usage.getTicket().getPayload()) + ")");
                    }
                }
                PublicAPIKey key = this.publicAPIKeyAuthService.getKey(req);
                if (!(key instanceof ProjectScopePublicAPIKey)) {
                    throw new DKUSecurityException("API Key isn't project-scoped");
                }
                ProjectScopePublicAPIKey psKey = (ProjectScopePublicAPIKey)key;
                if (StringUtils.isBlank((String)psKey.onBehalf)) {
                    throw new DKUSecurityException("API Key isn't tied to a webapp");
                }
                WebApp wa = this.webAppsService.getOrNullUnsafe_noCode(psKey.projectKey, psKey.onBehalf);
                if (wa == null) {
                    throw new DKUSecurityException("API Key isn't tied to a running webapp");
                }
                authCtx = this.authCtxCreationService.create(wa.creationTag.getLastAuthor());
                projectKey = wa.projectKey;
                String webAppId = wa.id;
                this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                WebAppMeta meta = WebAppRegistry.getMeta(wa.type);
                if (!(meta instanceof CustomWebAppMeta)) {
                    throw new IllegalArgumentException("Virtual webapp " + projectKey + "." + webAppId + " is not a plugin webapp");
                }
                CustomWebAppMeta cmeta = (CustomWebAppMeta)meta;
                pluginId = cmeta.getOwnerPluginId();
                params = cmeta.getLoadedDesc().getParams();
            }
        }
        PluginSettingsResolver.ResolvedSettings pluginSettings = new PluginSettingsResolver(authCtx, projectKey).getPluginSettings(params, elementConfig, pluginId);
        PluginIntercomController.writeJSON((HttpServletResponse)resp, (Object)pluginSettings);
    }
}

