/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.t;

import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.DSSInternalErrorException;
import com.dataiku.dip.remoterun.RemoteRunFileExchangeService;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.TicketAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class RemoteRunFileExchangeIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private TicketAuthService authService;
    @Autowired
    private RemoteRunFileExchangeService containerExecService;
    @Autowired
    private ProjectsService projectService;
    @Autowired
    private TransactionService transactionService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.remoterun.fileexchange");

    @AuditedCall(value={"msgType", "containers-get-execution", "executionId", "${executionId}"})
    @RequestMapping(value={"/api/tintercom/containers/get-execution"})
    public void getExecution(HttpServletRequest req, HttpServletResponse resp, @RequestParam String executionId, @RequestParam(required=false) String version) throws Exception {
        RemoteRunsRegistry.Execution execution = this.getExecution(req, executionId);
        if (!execution.dssVersion.equalsIgnoreCase(version)) {
            logger.warnV("DSS version is %s but container sent %s", new Object[]{execution.dssVersion, version});
        }
        RemoteRunFileExchangeIntercomController.writeJSON((HttpServletResponse)resp, (Object)execution);
    }

    @AuditedCall(value={"msgType", "containers-get-file", "executionId", "${executionId}", "fileKind", "${fileKind}", "path", "${path}"})
    @RequestMapping(value={"/api/tintercom/containers/get-file"})
    public void getFile(HttpServletRequest req, HttpServletResponse resp, @RequestParam String executionId, @RequestParam String fileKind, @RequestParam(required=false) String path, @RequestParam(required=false) String pluginId, @RequestParam(required=false) String codeEnvName, @RequestParam(required=false, defaultValue="true") boolean compress) throws Exception {
        RemoteRunsRegistry.Execution execution = this.getExecution(req, executionId);
        this.containerExecService.downloadFile(execution, RemoteRunFileExchangeService.FileKind.valueOf(fileKind), path, pluginId, codeEnvName, compress, resp);
    }

    @AuditedCall(value={"msgType", "containers-get-lab-file", "executionId", "${executionId}", "fileKind", "${fileKind}", "path", "${path}"})
    @RequestMapping(value={"/api/tintercom/containers/get-lab-file"})
    public void getLabMLFile(HttpServletRequest req, HttpServletResponse resp, @RequestParam String executionId, @RequestParam String fileKind, @RequestParam String path, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId) throws Exception {
        RemoteRunsRegistry.Execution execution = this.getExecution(req, executionId);
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction ignored = this.transactionService.beginRead();){
            this.projectService.checkPerm(execution.authCtx, loc.analysisProjectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        this.containerExecService.downloadMLFile(execution, RemoteRunFileExchangeService.FileKind.valueOf(fileKind), path, loc, resp);
    }

    @AuditedCall(value={"msgType", "containers-get-sm-file", "executionId", "${executionId}", "fileKind", "${fileKind}", "path", "${path}"})
    @RequestMapping(value={"/api/tintercom/containers/get-sm-file"})
    public void getSavedModelMLFile(HttpServletRequest req, HttpServletResponse resp, @RequestParam String executionId, @RequestParam String fileKind, @RequestParam String path, @RequestParam String projectKey, @RequestParam String savedModelId) throws Exception {
        RemoteRunsRegistry.Execution execution = this.getExecution(req, executionId);
        try (Transaction ignored = this.transactionService.beginRead();){
            this.projectService.failIfNoSavedModelReadUseAccess(execution.authCtx, new AnyLoc(projectKey, savedModelId), execution.projectKey);
        }
        this.containerExecService.downloadMLFile(execution, RemoteRunFileExchangeService.FileKind.valueOf(fileKind), path, projectKey, savedModelId, resp);
    }

    @AuditedCall(value={"msgType", "containers-get-local-hf-file", "executionId", "${executionId}", "fileKind", "${fileKind}", "path", "${path}"})
    @RequestMapping(value={"/api/tintercom/containers/get-local-hf-file"})
    public void getSavedModelHFFile(HttpServletRequest req, HttpServletResponse resp, @RequestParam String executionId, @RequestParam String fileKind, @RequestParam String path, @RequestParam String projectKey, @RequestParam String savedModelId) throws Exception {
        RemoteRunsRegistry.Execution execution = this.getExecution(req, executionId);
        try (Transaction ignored = this.transactionService.beginRead();){
            this.projectService.failIfNoSavedModelReadUseAccess(execution.authCtx, new AnyLoc(projectKey, savedModelId), execution.projectKey);
        }
        this.containerExecService.downloadHFFile(execution, RemoteRunFileExchangeService.FileKind.valueOf(fileKind), path, projectKey, savedModelId, resp);
    }

    @AuditedCall(value={"msgType", "containers-put-sm-file", "executionId", "${executionId}", "fileKind", "${fileKind}", "path", "${path}"})
    @RequestMapping(value={"/api/tintercom/containers/put-sm-file"})
    public void putSavedModelMLFile(HttpServletRequest req, HttpServletResponse resp, @RequestParam String executionId, @RequestParam String fileKind, @RequestParam String path, @RequestParam String projectKey, @RequestParam String savedModelId, @RequestParam(required=false, defaultValue="false") boolean expand) throws Exception {
        RemoteRunsRegistry.Execution execution = this.getExecution(req, executionId);
        try (Transaction ignored = this.transactionService.beginRead();){
            this.projectService.checkPerm(execution.authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        this.containerExecService.processMLFileUpload(execution, RemoteRunFileExchangeService.FileKind.valueOf(fileKind), path, projectKey, savedModelId, (InputStream)req.getInputStream(), expand);
        RemoteRunFileExchangeIntercomController.writeEmptyJSONObj((HttpServletResponse)resp);
    }

    @AuditedCall(value={"msgType", "containers-delete-sm-file", "executionId", "${executionId}", "fileKind", "${fileKind}", "path", "${path}"})
    @RequestMapping(value={"/api/tintercom/containers/delete-sm-file"})
    public void deleteMLFile(HttpServletRequest req, HttpServletResponse resp, @RequestParam String executionId, @RequestParam String fileKind, @RequestParam String path, @RequestParam String projectKey, @RequestParam String savedModelId) throws Exception {
        RemoteRunsRegistry.Execution execution = this.getExecution(req, executionId);
        this.containerExecService.processMLFileDelete(execution, RemoteRunFileExchangeService.FileKind.valueOf(fileKind), path, projectKey, savedModelId);
        RemoteRunFileExchangeIntercomController.writeEmptyJSONObj((HttpServletResponse)resp);
    }

    @AuditedCall(value={"msgType", "containers-delete-file", "executionId", "${executionId}", "fileKind", "${fileKind}", "path", "${path}"})
    @RequestMapping(value={"/api/tintercom/containers/delete-file"})
    public void deleteFile(HttpServletRequest req, HttpServletResponse resp, @RequestParam String executionId, @RequestParam String fileKind, @RequestParam String path) throws Exception {
        RemoteRunsRegistry.Execution execution = this.getExecution(req, executionId);
        this.containerExecService.processFileDelete(execution, RemoteRunFileExchangeService.FileKind.valueOf(fileKind), path);
        RemoteRunFileExchangeIntercomController.writeEmptyJSONObj((HttpServletResponse)resp);
    }

    @AuditedCall(value={"msgType", "containers-put-file", "executionId", "${executionId}", "fileKind", "${fileKind}", "path", "${path}"})
    @RequestMapping(value={"/api/tintercom/containers/put-file"})
    public void putFile(HttpServletRequest req, HttpServletResponse resp, @RequestParam String executionId, @RequestParam String fileKind, @RequestParam String path, @RequestParam(required=false, defaultValue="false") Boolean expand) throws Exception {
        RemoteRunsRegistry.Execution execution = this.getExecution(req, executionId);
        this.containerExecService.processFileUpload(execution, RemoteRunFileExchangeService.FileKind.valueOf(fileKind), path, (InputStream)req.getInputStream(), (boolean)expand);
        RemoteRunFileExchangeIntercomController.writeEmptyJSONObj((HttpServletResponse)resp);
    }

    @AuditedCall(value={"msgType", "containers-put-file", "executionId", "${executionId}", "fileKind", "${fileKind}", "path", "${path}"})
    @RequestMapping(value={"/api/tintercom/containers/put-file-multipart"})
    public void putFileMultipart(HttpServletRequest req, HttpServletResponse resp, @RequestParam String executionId, @RequestParam String fileKind, @RequestParam String path, @RequestParam(required=false, defaultValue="false") Boolean expand, @RequestParam(value="file") MultipartFile file) throws Exception {
        RemoteRunsRegistry.Execution execution = this.getExecution(req, executionId);
        this.containerExecService.processFileUpload(execution, RemoteRunFileExchangeService.FileKind.valueOf(fileKind), path, file, (boolean)expand);
        RemoteRunFileExchangeIntercomController.writeEmptyJSONObj((HttpServletResponse)resp);
    }

    private RemoteRunsRegistry.Execution getExecution(HttpServletRequest req, @RequestParam String executionId) throws IOException, DKUSecurityException {
        RemoteRunsRegistry.Execution execution = RemoteRunsRegistry.get(executionId);
        if (execution == null) {
            throw new DSSInternalErrorException("Unknown execution context: " + executionId);
        }
        if (!this.authService.getMandTicketAuthCtx(req).getIdentifier().equals(execution.authCtx.getIdentifier())) {
            throw new SecurityException("Wrong authentication ID, expected " + String.valueOf(execution.authCtx) + " but got " + String.valueOf(this.authService.getMandTicketAuthCtx(req)));
        }
        execution.authCtx = execution.authCtx.refresh();
        return execution;
    }
}

