/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.emails;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.server.notifications.VariableLookup;
import com.dataiku.dip.server.notifications.emails.MessageContentBuilder;
import com.dataiku.dip.server.notifications.emails.TemplatedContent;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Year;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookup;

public class WelcomeEmailBuilder {
    private final VariableLookup lookup;
    private final StringSubstitutor substitutor;

    public WelcomeEmailBuilder(VariablesService variablesService) {
        GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        String productLongName = generalSettings.whiteLabeling != null ? generalSettings.whiteLabeling.productLongName : "Dataiku";
        String studioExternalUrl = generalSettings.studioExternalUrl;
        this.lookup = new VariableLookup();
        this.lookup.setVariablesContext(variablesService.getForGlobal());
        this.lookup.addVariable("currentYear", String.valueOf(Year.now().getValue()));
        this.lookup.addVariable("studioExternalUrl", StringUtils.isBlank((String)studioExternalUrl) ? null : studioExternalUrl);
        this.lookup.addVariable("productLongName", StringUtils.isBlank((String)productLongName) ? null : productLongName);
        this.substitutor = new StringSubstitutor((StringLookup)this.lookup);
    }

    public UserSettingsService.EmailNotificationsSettings createWelcomeEmailParams(GeneralSettingsDAO.GeneralSettings generalSettings) {
        GeneralSettingsDAO.WelcomeEmailSettings welcomeEmailSettings = generalSettings.welcomeEmailSettings;
        UserSettingsService.EmailNotificationsSettings params = new UserSettingsService.EmailNotificationsSettings();
        params.enabled = true;
        params.isTemplatedContent = true;
        String productLongName = generalSettings.whiteLabeling != null ? generalSettings.whiteLabeling.productLongName : "Dataiku";
        params.subject = this.makeSubject(welcomeEmailSettings, productLongName);
        params.sendAsHTML = true;
        if (!welcomeEmailSettings.useDefaultTemplate) {
            params.sendAsHTML = welcomeEmailSettings.sendAsHTML;
        }
        return params;
    }

    public Multipart makeEmailContent(UserSettingsService.EmailNotificationsSettings params, String body) throws MessagingException, TemplateException, IOException {
        if (params.isTemplatedContent) {
            return this.makeTemplatedEmailContent(params, body);
        }
        return this.makeStandardEmailContent(body);
    }

    public String createWelcomeEmailBody(GeneralSettingsDAO.WelcomeEmailSettings welcomeEmailSettings) throws IOException {
        if (welcomeEmailSettings.useDefaultTemplate) {
            File defaultEmailTemplate = DKUApp.getResourceFile((String[])new String[]{"notifications", "default-welcome-email.ftl"});
            return FileUtils.readFileToString((File)defaultEmailTemplate, (Charset)StandardCharsets.UTF_8);
        }
        return welcomeEmailSettings.message;
    }

    public String getRecipient(String userLogin, String userEmail) {
        if (!StringUtils.isBlank((String)userEmail)) {
            return userEmail;
        }
        if (userLogin.contains("@")) {
            return userLogin;
        }
        throw new IllegalArgumentException("Invalid or missing email address");
    }

    private String makeSubject(GeneralSettingsDAO.WelcomeEmailSettings welcomeEmailSettings, String productLongName) {
        String subject = String.format("Welcome to %s!", productLongName);
        if (!welcomeEmailSettings.useDefaultTemplate && StringUtils.isNotBlank((String)welcomeEmailSettings.subject)) {
            subject = this.substitutor.replace(welcomeEmailSettings.subject);
        }
        return subject;
    }

    private Multipart makeTemplatedEmailContent(UserSettingsService.EmailNotificationsSettings params, String body) throws MessagingException, TemplateException, IOException {
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        TemplatedContent templatedContent = new TemplatedContent();
        templatedContent.message = body;
        String messageBody = new MessageContentBuilder(this.lookup).buildWithFreemarker(templatedContent);
        messageBodyPart.setText(messageBody, "utf-8", params.sendAsHTML ? "html" : "plain");
        multipart.addBodyPart((BodyPart)messageBodyPart);
        return multipart;
    }

    private Multipart makeStandardEmailContent(String body) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setText(body, "utf-8", "html");
        multipart.addBodyPart((BodyPart)messageBodyPart);
        return multipart;
    }
}

