/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetSelectionToMemTable;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.SampleBuilder;
import com.dataiku.dip.shaker.model.ShakerSamplingUtils;
import com.dataiku.dip.shaker.server.SampleMetadata;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import org.apache.commons.codec.digest.DigestUtils;

public final class PreviewSampleHelper {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.shaker.preview");

    public static SampleBuilder.SampleMeta findNonPreviewSampleForPreview(AuthCtx authCtx, Dataset dataset, String previewSampleId, DatasetSelectionToMemTable previewSelection) {
        try {
            ShakerSamplingUtils.SampleIdDecomposition previewSampleIdDecomposition = ShakerSamplingUtils.decomposeSampleId(previewSampleId);
            if (previewSampleIdDecomposition == null) {
                return null;
            }
            String nonPreviewSampleId = SampleBuilder.sampleId(authCtx, dataset, false);
            if (nonPreviewSampleId == null) {
                return null;
            }
            ShakerSamplingUtils.SampleIdDecomposition nonPreviewSampleIdDecomposition = ShakerSamplingUtils.decomposeSampleId(nonPreviewSampleId);
            if (nonPreviewSampleIdDecomposition == null) {
                return null;
            }
            boolean isCompatibleNonSelectionSignatures = PreviewSampleHelper.isNonPreviewCompatibleWithPreviewNonSelectionSignatures(nonPreviewSampleIdDecomposition, previewSampleIdDecomposition);
            if (!isCompatibleNonSelectionSignatures) {
                return null;
            }
            SampleMetadata nonPreviewSampleMetadata = SampleBuilder.getSampleMetadata(SampleBuilder.metadataFile(authCtx, dataset, nonPreviewSampleId, false));
            if (nonPreviewSampleMetadata == null) {
                return null;
            }
            boolean isCompatibleSelection = PreviewSampleHelper.isNonPreviewCompatibleWithPreviewSelection(nonPreviewSampleIdDecomposition.selectionSignature, nonPreviewSampleMetadata, previewSampleIdDecomposition.selectionSignature, previewSelection);
            if (!isCompatibleSelection) {
                return null;
            }
            File nonPreviewSampleFile = SampleBuilder.sampleFile(authCtx, dataset, nonPreviewSampleId, false);
            if (!nonPreviewSampleFile.isFile()) {
                return null;
            }
            SampleBuilder.SampleMeta nonPreviewSampleMeta = new SampleBuilder.SampleMeta();
            nonPreviewSampleMeta.id = nonPreviewSampleId;
            nonPreviewSampleMeta.computeTime = nonPreviewSampleFile.lastModified();
            nonPreviewSampleMeta.metadata = nonPreviewSampleMetadata;
            nonPreviewSampleMeta.warnings = SampleBuilder.getSampleWarning(SampleBuilder.warningFile(authCtx, dataset, nonPreviewSampleId, false));
            return nonPreviewSampleMeta;
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to find a non-preview sample for preview request", (Throwable)e);
            return null;
        }
    }

    @VisibleForTesting
    static boolean isNonPreviewCompatibleWithPreviewNonSelectionSignatures(ShakerSamplingUtils.SampleIdDecomposition nonPreviewSampleIdDecomposition, ShakerSamplingUtils.SampleIdDecomposition previewSampleIdDecomposition) {
        return !(!nonPreviewSampleIdDecomposition.basicSignature.equals(previewSampleIdDecomposition.basicSignature) || !previewSampleIdDecomposition.contentSignature.equals("NA") && !nonPreviewSampleIdDecomposition.contentSignature.equals(previewSampleIdDecomposition.contentSignature) || !previewSampleIdDecomposition.refreshTrigger.equals("0") && !nonPreviewSampleIdDecomposition.refreshTrigger.equals(previewSampleIdDecomposition.refreshTrigger) || !nonPreviewSampleIdDecomposition.stepsSignature.equals(previewSampleIdDecomposition.stepsSignature) || nonPreviewSampleIdDecomposition.meaningsSignature != null);
    }

    @VisibleForTesting
    static boolean isNonPreviewCompatibleWithPreviewSelection(String nonPreviewSelectionSignature, SampleMetadata nonPreviewSampleMetadata, String previewSelectionSignature, DatasetSelectionToMemTable previewSelection) {
        if (nonPreviewSelectionSignature.equals(previewSelectionSignature)) {
            return true;
        }
        switch (previewSelection.samplingMethod) {
            case FULL: {
                boolean isSufficient = nonPreviewSampleMetadata.sampleIsWholeDataset;
                break;
            }
            case HEAD_SEQUENTIAL: {
                boolean isSufficient = nonPreviewSampleMetadata.sampleIsWholeDataset || nonPreviewSampleMetadata.samplingMethod == SamplingParam.SamplingMethod.HEAD_SEQUENTIAL && nonPreviewSampleMetadata.maxRecords >= previewSelection.maxRecords && previewSelection.maxRecords > 0L;
                break;
            }
            default: {
                boolean isSufficient = false;
            }
        }
        if (!(isSufficient &= !nonPreviewSampleMetadata.memoryLimitReached || nonPreviewSampleMetadata.sampleRecordCount >= previewSelection.maxRecords && previewSelection.maxRecords > 0L)) {
            return false;
        }
        DatasetSelectionToMemTable previewSelectionForged = (DatasetSelectionToMemTable)((Object)JSON.deepCopy((Object)((Object)previewSelection)));
        previewSelectionForged.maxRecords = nonPreviewSampleMetadata.maxRecords;
        previewSelectionForged.samplingMethod = nonPreviewSampleMetadata.samplingMethod;
        previewSelectionForged.maxStoredBytes = nonPreviewSampleMetadata.memoryLimitInMB > 0L ? nonPreviewSampleMetadata.memoryLimitInMB * 1024L * 1024L : -1L;
        String previewSelectionSignatureForged = DigestUtils.md5Hex((String)JSON.json((Object)((Object)previewSelectionForged)));
        return nonPreviewSelectionSignature.equals(previewSelectionSignatureForged);
    }

    public static SampleMetadata buildPreviewSampleMetadataFromNonPreview(SampleMetadata nonPreviewSampleMetadata, DatasetSelectionToMemTable previewSelection, int previewSampleRowCount) {
        SampleMetadata previewSampleMetadata = new SampleMetadata();
        previewSampleMetadata.samplingMethod = previewSelection.samplingMethod;
        previewSampleMetadata.maxRecords = previewSelection.maxRecords;
        previewSampleMetadata.targetRatio = previewSelection.targetRatio;
        previewSampleMetadata.hasFilter = previewSelection.hasFilter();
        previewSampleMetadata.partitionCount = previewSelection.getRequestedPartitionCount();
        previewSampleMetadata.sampleIsWholeDataset = nonPreviewSampleMetadata.sampleIsWholeDataset && (long)previewSampleRowCount == nonPreviewSampleMetadata.datasetRecordCount;
        previewSampleMetadata.sampleRecordCount = previewSampleRowCount;
        previewSampleMetadata.datasetRecordCount = nonPreviewSampleMetadata.datasetRecordCount;
        previewSampleMetadata.recordCountIsApproximate = nonPreviewSampleMetadata.recordCountIsApproximate;
        return previewSampleMetadata;
    }

    private PreviewSampleHelper() {
    }
}

