/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.filtering;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.AppliesToProcessor;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class ColumnsSelector {
    public static final ProcessorMeta<StreamImpl, Parameter> META = new AppliesToProcessor.AppliesToProcessorMeta<StreamImpl, Parameter>(){

        @Override
        public String getName() {
            return "ColumnsSelector";
        }

        @Override
        public String getDocPage() {
            return "columns-select";
        }

        @Override
        public Category getCategory() {
            return Category.FILTER;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.FILTER});
        }

        @Override
        public String getHelp(String lang) {
            return this.translate(lang, "SHAKER.PROCESSOR.ColumnSelector.HELP", "Select one or more columns and either keep or remove them.\n# Options\n**Column**\nApply the matching condition to the following:\n* A single column\n* An explicit list of columns\n* All columns matching a regex pattern\n* All columns\n");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        protected Object selfReport(Parameter param) {
            return AppliesToProcessor.selfReport(param);
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            return new ProcessorMeta.ProcessorCapabilitiesSummary().withCan(ProcessorCapabilities.SQL_TRANSLATABLE, ProcessorCapabilities.NATIVE_SPARK_IMPL);
        }

        @Override
        public String getNativeSparkClassname() {
            return "com.dataiku.dip.shaker.processors.filtering.ColumnsSelectorNS";
        }

        @Override
        public ProcessorDesc describe(String language) {
            String description = this.translate(language, "SHAKER.PROCESSOR.ColumnSelector.DESCRIPTION", 1.actionVerb("Delete") + "/" + 1.actionVerb("Keep") + " columns by name");
            String keepLabel = this.translate(language, "SHAKER.PROCESSOR.ColumnSelector.KEEP", "Keep");
            String removeLabel = this.translate(language, "SHAKER.PROCESSOR.ColumnSelector.REMOVE", "Remove");
            return ProcessorDesc.withGenericForm(this.getName(), description).withBool("keep", "", keepLabel, removeLabel);
        }

        @Override
        public StreamImpl build(Parameter parameter) {
            return new StreamImpl(parameter);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams param, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SQLTranslator((Parameter)param);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter selectorParam = (Parameter)pss.params;
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                Set<String> availableColumns = previousDatasetPairLineage.getOutputColumns();
                Set<String> impactedColumns = selectorParam.getImpactedColumns(availableColumns);
                Set<String> allRemovedColumns = selectorParam.keep ? availableColumns.stream().filter(column -> !impactedColumns.contains(column)).collect(Collectors.toSet()) : new HashSet<String>(impactedColumns);
                for (String removedColumn : allRemovedColumns) {
                    updatedDatasetPairLineage.removeRelationsOnColumn(removedColumn);
                }
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };

    static class StreamImpl
    extends AppliesToProcessor {
        private final Parameter params;
        private Set<String> cnames = new HashSet<String>();

        public StreamImpl(Parameter params) {
            this.params = params;
        }

        @Override
        public void columnsUpdated() {
            for (Column c2 : this.columns) {
                this.cnames.add(c2.getName());
            }
        }

        @Override
        public void processRowForColumns(Row row, Iterable<Column> columns) {
            if (!this.params.keep) {
                for (Column c2 : columns) {
                    row.delete(c2);
                }
            } else {
                for (Column c3 : this.getColumnFactory().columns()) {
                    if (this.cnames.contains(c3.getName())) continue;
                    row.delete(c3);
                }
            }
        }

        public void postProcess() {
            block3: {
                block2: {
                    if (this.params.keep) break block2;
                    if (this.columns == null) break block3;
                    for (Column c2 : this.columns) {
                        this.getColumnFactory().deleteColumn(c2.getName());
                    }
                    break block3;
                }
                for (Column c3 : this.getColumnFactory().columns()) {
                    if (this.cnames.contains(c3.getName())) continue;
                    this.getColumnFactory().deleteColumn(c3.getName());
                }
            }
        }

        @Override
        public AppliesToProcessor.AppliesToParams getParams() {
            return this.params;
        }
    }

    private static class SQLTranslator
    implements ProcessorSQLTranslator {
        private final Parameter params;

        private SQLTranslator(Parameter params) {
            this.params = params;
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema input) {
            LinkedHashSet<String> columnsToDelete;
            LinkedHashSet<String> columns = new LinkedHashSet<String>(input.getAppliesToColumns(this.params));
            LinkedHashSet<String> columnsToKeep = this.params.keep ? columns : input.getCurrentColumsBut(columns);
            Iterable<String> iterable = columnsToDelete = this.params.keep ? input.getCurrentColumsBut(columns) : columns;
            if (input.isAnyCreatedOrModifiedByCurrentQuery(columnsToKeep)) {
                input = input.makeSubquery();
            }
            input.clearSelected();
            for (String column : columnsToKeep) {
                input.select(input.col(column), column);
            }
            for (String column : columnsToDelete) {
                input.deleteColumn(column);
            }
            return input;
        }
    }

    public static class Parameter
    extends AppliesToProcessor.AppliesToParams {
        private static final long serialVersionUID = -1L;
        public boolean keep = false;
    }
}

