/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.udf;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.shaker.processors.udf.AbstractPythonUDF;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyUnicode;

public class JythonUDFUtils {
    public static String formatPyException(PyException e) {
        return String.valueOf(e.type) + " : " + String.valueOf(e.value) + ". " + (e.traceback != null ? e.traceback.dumpStack() : "");
    }

    public static String formatObjet(PyObject result) {
        if (result == null || result.equals((Object)Py.None)) {
            return null;
        }
        if (result instanceof PyUnicode) {
            return result.toString();
        }
        if (result instanceof PyString) {
            PyString s = (PyString)result;
            try {
                return s.decode("utf-8").toString();
            }
            catch (Exception e) {
                return s.toString();
            }
        }
        return result.__repr__().toString();
    }

    public static Row formatRow(ColumnFactory cf, RowFactory rf, PyDictionary rowDic) {
        Row newRow = rf.row();
        for (Object rowItemObj : rowDic.items()) {
            PyTuple rowKV = (PyTuple)rowItemObj;
            String key = rowKV.pyget(0).toString();
            PyObject value = rowKV.pyget(1);
            Column column = cf.column(key, Processor.ProcessorRole.OUTPUT_COLUMN);
            newRow.put(column, JythonUDFUtils.formatObjet(value));
        }
        return newRow;
    }

    public static String objToStr(Object result) {
        String objStr = result == null ? null : (result instanceof String ? (String)result : (result instanceof JsonPrimitive ? ((JsonPrimitive)result).getAsString() : JSON.json((Object)result)));
        return objStr;
    }

    public static Row deltaToRow(ColumnFactory cf, RowFactory rf, Row row, Object result) {
        AbstractPythonUDF.RowDelta delta;
        Row ret = rf.row();
        if (result == null) {
            return ret;
        }
        AbstractPythonUDF.RowDelta rowDelta = delta = result instanceof AbstractPythonUDF.RowDelta ? (AbstractPythonUDF.RowDelta)result : (AbstractPythonUDF.RowDelta)JSON.parse((String)JSON.json((Object)result), AbstractPythonUDF.RowDelta.class);
        if (delta.__dku_added_columns != null && delta.__dku_deleted_columns != null) {
            HashSet added = Sets.newHashSet();
            for (Column c2 : cf.columns()) {
                if (delta.__dku_deleted_columns.contains(c2.getName())) continue;
                if (delta.__dku_added_columns.has(c2.getName())) {
                    ret.put(c2, JythonUDFUtils.objToStr(delta.__dku_added_columns.get(c2.getName())));
                    added.add(c2.getName());
                    continue;
                }
                ret.put(c2, row.get(c2));
            }
            for (Map.Entry e : delta.__dku_added_columns.entrySet()) {
                if (added.contains(e.getKey())) continue;
                Column column = cf.column((String)e.getKey(), Processor.ProcessorRole.OUTPUT_COLUMN);
                ret.put(column, JythonUDFUtils.objToStr(e.getValue()));
            }
        } else {
            JsonObject dict = result instanceof JsonObject ? (JsonObject)result : (JsonObject)JSON.parse((String)JSON.json((Object)result), JsonObject.class);
            for (Map.Entry e : dict.entrySet()) {
                Column column = cf.column((String)e.getKey(), Processor.ProcessorRole.OUTPUT_COLUMN);
                ret.put(column, JythonUDFUtils.objToStr(e.getValue()));
            }
        }
        return ret;
    }

    public static Row jsonToRow(ColumnFactory cf, RowFactory rf, Object result) {
        Row ret = rf.row();
        if (result == null) {
            return ret;
        }
        JsonObject dict = result instanceof JsonObject ? (JsonObject)result : (JsonObject)JSON.parse((String)JSON.json((Object)result), JsonObject.class);
        for (Map.Entry e : dict.entrySet()) {
            Column column = cf.column((String)e.getKey(), Processor.ProcessorRole.OUTPUT_COLUMN);
            ret.put(column, JythonUDFUtils.objToStr(e.getValue()));
        }
        return ret;
    }

    public static List<Object> unvectorizeToList(Object result) throws Exception {
        List results;
        if (result instanceof Object[]) {
            results = Arrays.asList((Object[])result);
        } else if (result instanceof List) {
            results = (List)result;
        } else if (result instanceof JsonArray) {
            results = Lists.newArrayList();
            Iterator it = ((JsonArray)result).iterator();
            while (it.hasNext()) {
                results.add(it.next());
            }
        } else {
            throw new Exception("Vectorised code did not return a vector, but a " + result.getClass().getCanonicalName());
        }
        return results;
    }
}

