/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.server;

import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.formats.FormatCodes;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.pivot.backend.model.FilterFacet;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.recipes.ShakerRecipeService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.shaker.SampleBuilder;
import com.dataiku.dip.shaker.analysis.NumericalVariableAnalysis;
import com.dataiku.dip.shaker.analysis.NumericalVariableAnalyzer;
import com.dataiku.dip.shaker.facet.AlphanumFacet;
import com.dataiku.dip.shaker.facet.AlphanumFacetBuilder;
import com.dataiku.dip.shaker.facet.ArrayFacet;
import com.dataiku.dip.shaker.facet.ArrayFacetBuilder;
import com.dataiku.dip.shaker.facet.BoundingBoxFaceter;
import com.dataiku.dip.shaker.facet.CountMap;
import com.dataiku.dip.shaker.facet.FacetUtils;
import com.dataiku.dip.shaker.facet.JSONArrayFaceter;
import com.dataiku.dip.shaker.facet.NamedEntityFaceter;
import com.dataiku.dip.shaker.facet.TextFacet;
import com.dataiku.dip.shaker.facet.TextFacetBuilder;
import com.dataiku.dip.shaker.filter.AlphanumFaceter;
import com.dataiku.dip.shaker.filter.Faceter;
import com.dataiku.dip.shaker.filter.FilterRequest;
import com.dataiku.dip.shaker.filter.FilteringExecutor;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.processors.expr.TextSimplifier;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.shaker.server.ScriptTableCache;
import com.dataiku.dip.shaker.server.TableColoringService;
import com.dataiku.dip.shaker.server.TableSortingService;
import com.dataiku.dip.shaker.services.TypeInferrer2;
import com.dataiku.dip.shaker.types.JSONArrayMeaning;
import com.dataiku.dip.shaker.types.MeaningDetector;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataService {
    @Autowired
    private FutureService futureService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private SampleBuilder sampleBuilder;
    @Autowired
    private TableColoringService coloringService;
    @Autowired
    private TableSortingService sortingService;
    @Autowired
    private PubSubService pubSubService;
    @Autowired
    private TranslationService translationService;
    private TypeInferrer2 inferer;
    private ScriptTableCache cache = new ScriptTableCache();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.shaker.data");

    @PostConstruct
    public void onLoad() {
        logger.trace(() -> "Init data service");
        this.inferer = new TypeInferrer2();
        this.pubSubService.subscribe("debug-clear-shaker-table-cache", (DSSEventListener)new DSSEventListener<BackendEvent>(){

            public void on(BackendEvent evt) {
                logger.info((Object)"Clearing shaker table cache");
                DataService.this.cache.removeAll();
            }
        });
        logger.trace(() -> "Done init data service");
    }

    public void invalidateCache(DatasetLocUtils.DatasetLoc dataset) {
        this.cache.removeForDatasetForAllUsers(dataset.getProjectKey(), dataset.getName());
    }

    public void invalidateCacheForProject(String projectKey) {
        this.cache.removeForProjectForAllUsers(projectKey);
    }

    public void invalidateAllMemoryCache() {
        this.cache.removeAll();
    }

    /*
     * Unable to fully structure code
     */
    private MemScriptRunner.TableWithReport compute(Dataset input, SerializedShakerScript dataView, String requestedSampleId, AuthCtx user, boolean isForPreview, boolean inMemory) throws Exception {
        block23: {
            if (requestedSampleId != null && requestedSampleId.isEmpty()) {
                requestedSampleId = null;
            }
            if (DataService.logger.isTraceEnabled()) {
                DataService.logger.trace((Object)("Compute with input recipe schema " + JSON.pretty((Object)dataView.recipeSchema)));
            }
            before = System.currentTimeMillis();
            runner = new MemScriptRunner(dataView, input, requestedSampleId, this.sampleBuilder, user, isForPreview, inMemory);
            initDone = System.currentTimeMillis();
            ret = runner.run();
            runDone = System.currentTimeMillis();
            tctx = DSSMetrics.timeCtx((String)"dku.shaker.typeinference.process");
            try {
                detectionState = FutureProgress.pushAutoCloseableState((String)this.translationService.translate("DATA_SERVICE.STATUS.DETECTING_TYPES", "Detecting types", new Object[0]));
                try {
                    DSSMetrics.registry().histogram("dku.shaker.typeinference.nbRows").update(ret.table.nrows());
                    DSSMetrics.registry().histogram("dku.shaker.typeinference.nbCols").update(ret.table.ncols());
                    infererCacheKey = input.getFullName();
                    if (dataView.origin == null) {
                        this.inferer.processFullAuto(infererCacheKey, ret.table);
                        break block23;
                    }
                    switch (5.$SwitchMap$com$dataiku$dip$shaker$model$SerializedShakerScript$ShakerOrigin[dataView.origin.ordinal()]) {
                        case 1: {
                            this.inferer.processForAnalysis(infererCacheKey, ret.table, dataView.analysisColumnData);
                            ** break;
lbl24:
                            // 1 sources

                            break;
                        }
                        case 2: {
                            this.inferer.processForExplore(infererCacheKey, ret.table, input.getSchema());
                            ** break;
lbl28:
                            // 1 sources

                            break;
                        }
                        case 3: {
                            this.inferer.processForRecipe(infererCacheKey, ret.table, dataView.recipeSchema);
                            ** break;
lbl32:
                            // 1 sources

                            break;
                        }
                        ** default:
lbl34:
                        // 1 sources

                        break;
                    }
                }
                finally {
                    if (detectionState != null) {
                        detectionState.close();
                    }
                }
            }
            finally {
                if (tctx != null) {
                    tctx.close();
                }
            }
        }
        if (dataView.recipeSchema != null) {
            if (!DataService.$assertionsDisabled && dataView.recipeSchema.outputDatasetType == null) {
                throw new AssertionError();
            }
            ret.newRecipeSchema = new ShakerRecipeSchema();
            ret.newRecipeSchema.outputDatasetType = dataView.recipeSchema.outputDatasetType;
            for (MemColumn mc : ret.table.columnsList) {
                ShakerRecipeService.fixupImpossibleStorageTypes(dataView.recipeSchema.outputDatasetType, mc);
                ret.newRecipeSchema.columns.put(mc.getName(), mc.recipeSchemaColumn);
                ret.newRecipeSchema.columnsOrder.add(mc.getName());
            }
        }
        FutureProgress.updateState((double)5.0);
        inferDone = System.currentTimeMillis();
        DataService.logger.info((Object)("DataService done, initTime=" + (initDone - before) + " runTime=" + (runDone - initDone) + " inferTime=" + (inferDone - runDone)));
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    private MemScriptRunner.TableWithReport compute(StreamingEndpoint input, SerializedShakerScript dataView, String requestedSampleId, AuthCtx user) throws Exception {
        block23: {
            if (requestedSampleId != null && requestedSampleId.isEmpty()) {
                requestedSampleId = null;
            }
            if (DataService.logger.isTraceEnabled()) {
                DataService.logger.trace((Object)("Compute with input recipe schema " + JSON.pretty((Object)dataView.recipeSchema)));
            }
            before = System.currentTimeMillis();
            runner = new MemScriptRunner(dataView, input, requestedSampleId, this.sampleBuilder, user);
            initDone = System.currentTimeMillis();
            ret = runner.run();
            runDone = System.currentTimeMillis();
            tctx = DSSMetrics.timeCtx((String)"dku.shaker.typeinference.process");
            try {
                detectionState = FutureProgress.pushAutoCloseableState((String)"Detecting types");
                try {
                    DSSMetrics.registry().histogram("dku.shaker.typeinference.nbRows").update(ret.table.nrows());
                    DSSMetrics.registry().histogram("dku.shaker.typeinference.nbCols").update(ret.table.ncols());
                    infererCacheKey = input.getFullId();
                    if (dataView.origin == null) {
                        this.inferer.processFullAuto(infererCacheKey, ret.table);
                        break block23;
                    }
                    switch (5.$SwitchMap$com$dataiku$dip$shaker$model$SerializedShakerScript$ShakerOrigin[dataView.origin.ordinal()]) {
                        case 1: {
                            this.inferer.processForAnalysis(infererCacheKey, ret.table, dataView.analysisColumnData);
                            ** break;
lbl24:
                            // 1 sources

                            break;
                        }
                        case 2: {
                            this.inferer.processForExplore(infererCacheKey, ret.table, input.schema);
                            ** break;
lbl28:
                            // 1 sources

                            break;
                        }
                        case 3: {
                            this.inferer.processForRecipe(infererCacheKey, ret.table, dataView.recipeSchema);
                            break;
                        }
                        ** default:
lbl33:
                        // 1 sources

                        break;
                    }
                }
                finally {
                    if (detectionState != null) {
                        detectionState.close();
                    }
                }
            }
            finally {
                if (tctx != null) {
                    tctx.close();
                }
            }
        }
        if (dataView.recipeSchema != null) {
            if (!DataService.$assertionsDisabled && dataView.recipeSchema.outputDatasetType == null) {
                throw new AssertionError();
            }
            ret.newRecipeSchema = new ShakerRecipeSchema();
            ret.newRecipeSchema.outputDatasetType = dataView.recipeSchema.outputDatasetType;
            for (MemColumn mc : ret.table.columnsList) {
                ShakerRecipeService.fixupImpossibleStorageTypes(dataView.recipeSchema.outputDatasetType, mc);
                ret.newRecipeSchema.columns.put(mc.getName(), mc.recipeSchemaColumn);
                ret.newRecipeSchema.columnsOrder.add(mc.getName());
            }
        }
        FutureProgress.updateState((double)5.0);
        inferDone = System.currentTimeMillis();
        DataService.logger.info((Object)("DataService done, initTime=" + (initDone - before) + " runTime=" + (runDone - initDone) + " inferTime=" + (inferDone - runDone)));
        return ret;
    }

    public MemScriptRunner.TableWithReport get_NOTRANSACTION(Dataset dataset, SerializedShakerScript dataView, String requestedSampleId, FilterRequest filters, boolean allowCache, AuthCtx user, boolean isForPreview) throws Exception {
        return this.get_NOTRANSACTION(dataset, dataView, requestedSampleId, filters, allowCache, user, isForPreview, false);
    }

    public MemScriptRunner.TableWithReport get_NOTRANSACTION(Dataset dataset, SerializedShakerScript dataView, String requestedSampleId, FilterRequest filters, boolean allowCache, AuthCtx user) throws Exception {
        return this.get_NOTRANSACTION(dataset, dataView, requestedSampleId, filters, allowCache, user, false, false);
    }

    public MemScriptRunner.TableWithReport get_NOTRANSACTION(Dataset dataset, SerializedShakerScript dataView, String requestedSampleId, FilterRequest filters, boolean allowCache, AuthCtx user, boolean isForPreview, boolean inMemory) throws Exception {
        if (dataset == null) {
            throw ErrorContext.iae((String)"Dataset not specified");
        }
        TransactionContext.assertNoAttachedTransaction();
        try (FutureProgress.AutocloseableFutureProgressState state = FutureProgress.pushAutoCloseableState((String)this.translationService.translate("DATA_SERVICE.STATUS.COMPUTING", "Computing", new Object[0]), (double)5.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            dataView.expand(this.variablesService.getForProject(dataView.getProjectKey(dataset)));
            MemScriptRunner.TableWithReport table = null;
            if (allowCache) {
                String lookupSample = requestedSampleId;
                if (lookupSample == null) {
                    logger.info((Object)"Need to compute sampleId before checking memory cache");
                    MemScriptRunner runner = new MemScriptRunner(dataView, dataset, null, this.sampleBuilder, user, isForPreview, inMemory);
                    lookupSample = runner.getRequiredSampleId();
                }
                table = this.cache.get(user, dataset, dataView, lookupSample);
            }
            if (table == null) {
                logger.info((Object)"Memory cache miss");
                this.cache.removeForDatasetForUser(user, dataset.getProjectKey(), dataset.getName());
                table = this.compute(dataset, dataView, requestedSampleId, user, isForPreview, inMemory);
                if (table.newRecipeSchema != null) {
                    dataView.recipeSchema = table.newRecipeSchema;
                }
                this.cache.put(user, dataset, dataView, table.usedSample.id, table);
            }
            if (dataView.sorting != null) {
                this.sortingService.prepareSorting(dataView.sorting, table.table);
            }
            if (filters != null) {
                try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.shaker.filtering.process");){
                    String updatedFiltersSignature = JSON.json((Object)filters);
                    if (!updatedFiltersSignature.equals(table.filtersSignature)) {
                        FilteringExecutor executor = new FilteringExecutor(filters);
                        executor.execute(table.table);
                        table.filters = executor.getFilterResult();
                        table.facets = executor.getFaceting();
                    }
                }
            }
            if (dataView.coloring != null) {
                this.coloringService.prepareColoring(dataView.coloring, table.table);
            }
            MemScriptRunner.TableWithReport tableWithReport = table;
            return tableWithReport;
        }
    }

    public MemScriptRunner.TableWithReport get_NOTRANSACTION(StreamingEndpoint streamingEndpoint, SerializedShakerScript dataView, String requestedSampleId, FilterRequest filters, boolean allowCache, AuthCtx user) throws Exception {
        if (streamingEndpoint == null) {
            throw ErrorContext.iae((String)"Streaming endpoint not specified");
        }
        TransactionContext.assertNoAttachedTransaction();
        try (FutureProgress.AutocloseableFutureProgressState state = FutureProgress.pushAutoCloseableState((String)this.translationService.translate("DATA_SERVICE.STATUS.COMPUTING", "Computing", new Object[0]), (double)5.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            dataView.expand(this.variablesService.getForProject(dataView.getProjectKey(streamingEndpoint)));
            MemScriptRunner.TableWithReport table = null;
            if (allowCache) {
                String lookupSample = requestedSampleId;
                if (lookupSample == null) {
                    logger.info((Object)"Need to compute sampleId before checking memory cache");
                    MemScriptRunner runner = new MemScriptRunner(dataView, streamingEndpoint, null, this.sampleBuilder, user);
                    lookupSample = runner.getRequiredSampleId();
                }
                table = this.cache.get(user, streamingEndpoint, dataView, lookupSample);
            }
            if (table == null) {
                logger.info((Object)"Memory cache miss");
                this.cache.removeForStreamingEndpointForUser(user, streamingEndpoint.getProjectKey(), streamingEndpoint.getId());
                table = this.compute(streamingEndpoint, dataView, requestedSampleId, user);
                if (table.newRecipeSchema != null) {
                    dataView.recipeSchema = table.newRecipeSchema;
                }
                this.cache.put(user, streamingEndpoint, dataView, table.usedSample.id, table);
            }
            if (dataView.sorting != null) {
                this.sortingService.prepareSorting(dataView.sorting, table.table);
            }
            if (filters != null) {
                try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.shaker.filtering.process");){
                    String updatedFiltersSignature = JSON.json((Object)filters);
                    if (!updatedFiltersSignature.equals(table.filtersSignature)) {
                        FilteringExecutor executor = new FilteringExecutor(filters);
                        executor.execute(table.table);
                        table.filters = executor.getFilterResult();
                        table.facets = executor.getFaceting();
                    }
                }
            }
            if (dataView.coloring != null) {
                this.coloringService.prepareColoring(dataView.coloring, table.table);
            }
            MemScriptRunner.TableWithReport tableWithReport = table;
            return tableWithReport;
        }
    }

    public ColumnDetailedAnalysis getDetailedColumnAnalysis_NT(AuthCtx user, String requestedSampleId, Dataset ds, SerializedShakerScript ss, String column, int alphanumMaxResults, boolean forceTimePeriodAnalysis) throws Exception {
        MemTable table = this.get_NOTRANSACTION((Dataset)ds, (SerializedShakerScript)ss.deepCopy(), (String)requestedSampleId, null, (boolean)true, (AuthCtx)user).table;
        MemColumn cd = table.getColumn(column);
        if (cd == null) {
            throw new IllegalArgumentException("The column " + column + " does not exist (anymore) on this dataset.");
        }
        boolean enableTimePeriodAnalysis = forceTimePeriodAnalysis || cd.selectedType.type.isTemporal();
        return this.getDetailedColumnAnalysis_NT(cd, alphanumMaxResults, table, enableTimePeriodAnalysis);
    }

    public ColumnDetailedAnalysis getDetailedColumnAnalysis_NT(AuthCtx user, String requestedSampleId, StreamingEndpoint se, SerializedShakerScript ss, String column, int alphanumMaxResults, boolean forceTimePeriodAnalysis) throws Exception {
        MemTable table = this.get_NOTRANSACTION((StreamingEndpoint)se, (SerializedShakerScript)ss.deepCopy(), (String)requestedSampleId, null, (boolean)true, (AuthCtx)user).table;
        MemColumn cd = table.getColumn(column);
        if (cd == null) {
            throw new IllegalArgumentException("The column " + column + " does not exist (anymore) on this dataset.");
        }
        boolean enableTimePeriodAnalysis = forceTimePeriodAnalysis || cd.selectedType.type.isTemporal();
        return this.getDetailedColumnAnalysis_NT(cd, alphanumMaxResults, table, enableTimePeriodAnalysis);
    }

    private ColumnDetailedAnalysis getDetailedColumnAnalysis_NT(MemColumn cd, int alphanumMaxResults, MemTable table, boolean enableTimePeriodAnalysis) {
        TransactionContext.assertNoAttachedTransaction();
        ColumnDetailedAnalysis ret = new ColumnDetailedAnalysis();
        FacetUtils.Sort facetSort = FacetUtils.Sort.COUNT;
        ret.alphanumFacet = new AlphanumFacetBuilder().build(table, facetSort, alphanumMaxResults, cd);
        if (cd.selectedType != null && cd.selectedType.type.getClass() == JSONArrayMeaning.class) {
            ret.arrayFacet = new ArrayFacetBuilder().build(table, facetSort, alphanumMaxResults, cd);
        }
        if (cd.selectedType != null && cd.selectedType.type.isDouble()) {
            NumericalVariableAnalyzer analyzer = new NumericalVariableAnalyzer(40);
            analyzer.niceBounds = false;
            analyzer.analyse(table, cd.getName(), null);
            analyzer.enableTimePeriodAnalysis = enableTimePeriodAnalysis;
            analyzer.compute();
            ret.numericalAnalysis = analyzer.getOut();
        }
        return ret;
    }

    public Map<String, List<String>> getTopNDistinctValues_NT(AuthCtx user, String requestedSampleId, Dataset ds, SerializedShakerScript ss, List<String> columns, int n) throws Exception {
        HashMap<String, List<String>> res = new HashMap<String, List<String>>();
        MemTable table = this.get_NOTRANSACTION((Dataset)ds, (SerializedShakerScript)ss.deepCopy(), (String)requestedSampleId, null, (boolean)true, (AuthCtx)user).table;
        for (String column : columns) {
            MemColumn col = table.getColumn(column);
            if (col == null) {
                res.put(column, Collections.emptyList());
            }
            CountMap<String> counts = new CountMap<String>();
            for (MemRow row : table.rows) {
                String val;
                if (row.isDeleted() || !StringUtils.isNotBlank((CharSequence)(val = row.get(col)))) continue;
                counts.inc(val);
            }
            res.put(column, counts.getMap().entrySet().stream().sorted(Comparator.comparing(e -> -((MutableInt)e.getValue()).toInteger().intValue())).limit(n).map(Map.Entry::getKey).collect(Collectors.toList()));
        }
        return res;
    }

    public Collection<String> getDistinctValues_NT(AuthCtx user, String requestedSampleId, Dataset ds, SerializedShakerScript ss, List<String> columns, int maxValueCount) throws Exception {
        MemTable table = this.get_NOTRANSACTION((Dataset)ds, (SerializedShakerScript)ss.deepCopy(), (String)requestedSampleId, null, (boolean)true, (AuthCtx)user).table;
        HashSet<String> distinctValues = new HashSet<String>();
        List memColumns = columns.stream().map(table::getColumn).filter(Objects::nonNull).collect(Collectors.toList());
        block0: for (MemRow row : table.rows) {
            if (row.isDeleted()) continue;
            for (MemColumn col : memColumns) {
                boolean isNew;
                String val = row.get(col);
                if (!StringUtils.isNotBlank((CharSequence)val) || !(isNew = distinctValues.add(val)) || distinctValues.size() < maxValueCount) continue;
                break block0;
            }
        }
        return distinctValues;
    }

    public TextAnalysis getTextAnalysis(AuthCtx user, String requestedSampleId, Dataset ds, SerializedShakerScript ss, String column, TextSimplifier.Parameter simplificationParameters) throws Exception {
        MemTable table = this.get_NOTRANSACTION((Dataset)ds, (SerializedShakerScript)ss.deepCopy(), (String)requestedSampleId, null, (boolean)true, (AuthCtx)user).table;
        MemColumn cd = table.column(column);
        TextAnalysis analysis = new TextAnalysis();
        analysis.facet = new TextFacetBuilder(simplificationParameters).build(table, cd, 200);
        return analysis;
    }

    public static FuturePayload buildFuturePayload(Dataset dataset, String[] columns) {
        FuturePayload fp = new FuturePayload();
        fp.action = "columns_analyze";
        fp.targets.add(DSSFuturePayloadUtils.forDataset(dataset).withPart("colums_analyses"));
        fp.displayName = "Analyzing " + columns.length + " columns";
        fp.withExtra("columnCount", (Object)columns.length);
        return fp;
    }

    public static FuturePayload buildFuturePayload(StreamingEndpoint streamingEndpoint, String[] columns) {
        FuturePayload fp = new FuturePayload();
        fp.action = "columns_analyze";
        fp.targets.add(DSSFuturePayloadUtils.forStreamingEndpoint(streamingEndpoint).withPart("colums_analyses"));
        fp.displayName = "Analyzing " + columns.length + " columns";
        fp.withExtra("columnCount", (Object)columns.length);
        return fp;
    }

    public FutureResponse<Map<String, Object>> startMultiColumnAnalysis(AuthCtx user, String requestedSampleId, Dataset ds, SerializedShakerScript ss, String[] columns, String compute, Integer histogram) throws Exception {
        MultiColumnAnalysisTask task = new MultiColumnAnalysisTask((DSSAuthCtx)user, requestedSampleId, ds, ss, columns, compute, histogram);
        return this.futureService.runFuture(task, 100L, new TypeToken<FutureResponse<Map<String, Object>>>(){});
    }

    public FutureResponse<Map<String, Object>> startMultiColumnAnalysis(AuthCtx user, String requestedSampleId, StreamingEndpoint se, SerializedShakerScript ss, String[] columns, String compute, Integer histogram) throws Exception {
        MultiColumnAnalysisTask task = new MultiColumnAnalysisTask((DSSAuthCtx)user, requestedSampleId, se, ss, columns, compute, histogram);
        return this.futureService.runFuture(task, 100L, new TypeToken<FutureResponse<Map<String, Object>>>(){});
    }

    public FutureResponse<List<String>> autoDetectCategoriesFromAnnotations(AuthCtx user, Dataset dataset, SerializedShakerScript script, String annotationColumn, CategoryBasedAnnotationType annotationType) throws Exception {
        AutoDetectCategoriesFromAnnotations task = new AutoDetectCategoriesFromAnnotations((DSSAuthCtx)user, dataset, script, annotationColumn, annotationType);
        return this.futureService.runFuture(task, 100L, new TypeToken<FutureResponse<List<String>>>(){});
    }

    public static class ShakerRecipeSchema {
        public String outputDatasetType;
        public Map<String, ShakerRecipeSchemaColumn> columns = new HashMap<String, ShakerRecipeSchemaColumn>();
        public List<String> columnsOrder = new ArrayList<String>();
    }

    public static class ShakerRecipeSchemaColumn {
        public boolean persistent;
        public boolean deleted;
        public SchemaColumn column;
        public Map<String, Boolean> storableAs = new HashMap<String, Boolean>();
    }

    public static class ColumnDetailedAnalysis {
        public AlphanumFacet alphanumFacet;
        public NumericalVariableAnalysis numericalAnalysis;
        public ArrayFacet arrayFacet;
        public FullSampleColumnDetailedAnalysis fullSampleAnalysis;
    }

    public static class TextAnalysis {
        TextFacet facet;
    }

    private class MultiColumnAnalysisTask
    extends FutureThread<Map<String, Object>> {
        final String requestedSampleId;
        final Dataset ds;
        final StreamingEndpoint se;
        final SerializedShakerScript ss;
        private final FuturePayload futurePayload;
        final String[] columns;
        final String compute;
        final int bins;
        final Map<String, Object> results;

        MultiColumnAnalysisTask(DSSAuthCtx user, String requestedSampleId, Dataset ds, SerializedShakerScript ss, String[] columns, @Nullable String compute, Integer histogram) {
            super(user);
            this.requestedSampleId = requestedSampleId;
            this.ds = ds;
            this.se = null;
            this.ss = ss;
            this.columns = columns;
            this.compute = compute;
            if (!"*".equals(compute)) {
                histogram = 1;
            }
            this.bins = Math.min(40, Math.max(1, histogram == null ? 1 : histogram));
            this.results = new HashMap<String, Object>(columns.length);
            this.futurePayload = DataService.buildFuturePayload(ds, columns);
        }

        MultiColumnAnalysisTask(DSSAuthCtx user, String requestedSampleId, StreamingEndpoint se, SerializedShakerScript ss, String[] columns, @Nullable String compute, Integer histogram) {
            super(user);
            this.requestedSampleId = requestedSampleId;
            this.ds = null;
            this.se = se;
            this.ss = ss;
            this.columns = columns;
            this.compute = compute;
            if (!"*".equals(compute)) {
                histogram = 1;
            }
            this.bins = Math.min(40, Math.max(1, histogram == null ? 1 : histogram));
            this.results = new HashMap<String, Object>(columns.length);
            this.futurePayload = DataService.buildFuturePayload(se, columns);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public double getDangerosity() {
            return 0.3;
        }

        public Map<String, Object> getResult() {
            return this.results;
        }

        public void execute() throws Exception {
            MemTable table = this.ds != null ? DataService.this.get_NOTRANSACTION((Dataset)this.ds, (SerializedShakerScript)this.ss.deepCopy(), (String)this.requestedSampleId, null, (boolean)true, (AuthCtx)this.owner).table : DataService.this.get_NOTRANSACTION((StreamingEndpoint)this.se, (SerializedShakerScript)this.ss.deepCopy(), (String)this.requestedSampleId, null, (boolean)true, (AuthCtx)this.owner).table;
            for (String column : this.columns) {
                if (this.aborted) break;
                HashMap<String, Object> result = null;
                MemColumn col = table.column(column);
                if (col.selectedType == null) continue;
                MeaningDetector type = col.selectedType.type;
                if (type.isDouble() || type.isLong()) {
                    NumericalVariableAnalyzer analyzer = new NumericalVariableAnalyzer(this.bins);
                    analyzer.niceBounds = false;
                    analyzer.analyse(table, column, null);
                    analyzer.compute();
                    if (analyzer.getOut() != null) {
                        switch (this.compute) {
                            case "min": {
                                result = analyzer.getOut().min;
                                break;
                            }
                            case "max": {
                                result = analyzer.getOut().max;
                                break;
                            }
                            case "mode": {
                                result = analyzer.getOut().mode;
                                break;
                            }
                            case "median": {
                                result = analyzer.getOut().median;
                                break;
                            }
                            case "mean": 
                            case "average": {
                                result = analyzer.getOut().mean;
                                break;
                            }
                            case "sum": {
                                result = analyzer.getOut().sum;
                                break;
                            }
                            case "stddev": {
                                result = analyzer.getOut().stddev;
                                break;
                            }
                            case "cardinality": {
                                result = analyzer.getOut().cardinality;
                                break;
                            }
                            case "*": {
                                result = analyzer.getOut();
                            }
                        }
                    }
                    if (type.isLong() && ("min".equals(this.compute) || "max".equals(this.compute) || "mode".equals(this.compute))) {
                        assert (result != null);
                        result = ((Double)((Object)result)).intValue();
                    }
                } else {
                    AlphanumFacet facet = new AlphanumFacetBuilder().build(table, FacetUtils.Sort.COUNT, this.bins + 1, col);
                    String mode = facet.values.length > 0 ? facet.values[facet.values[0].equals("") && facet.values.length > 1 ? 1 : 0] : "";
                    switch (this.compute) {
                        case "mode": {
                            result = mode;
                            break;
                        }
                        case "cardinality": {
                            result = facet.totalNbValues;
                            break;
                        }
                        case "*": {
                            HashMap<String, Object> map = new HashMap<String, Object>(this.bins > 1 ? 2 : 3);
                            map.put("mode", mode);
                            map.put("cardinality", facet.totalNbValues);
                            if (this.bins > 1) {
                                map.put("facets", facet);
                            }
                            result = map;
                        }
                    }
                }
                if (result == null) continue;
                this.results.put(column, result);
            }
        }
    }

    private class AutoDetectCategoriesFromAnnotations
    extends FutureThread<List<String>> {
        private final int FAILED_PARSING_THRESHOLD_PERCENT = 80;
        private final FuturePayload futurePayload;
        private final Dataset dataset;
        private final SerializedShakerScript serializedShakerScript;
        private final String annotationColumn;
        private final CategoryBasedAnnotationType annotationType;
        List<String> categories;

        public AutoDetectCategoriesFromAnnotations(DSSAuthCtx user, Dataset dataset, SerializedShakerScript serializedShakerScript, String annotationColumn, CategoryBasedAnnotationType annotationType) {
            super(user);
            this.FAILED_PARSING_THRESHOLD_PERCENT = 80;
            this.dataset = dataset;
            this.serializedShakerScript = serializedShakerScript.deepCopy();
            this.annotationColumn = annotationColumn;
            this.annotationType = annotationType;
            this.serializedShakerScript.contextProjectKey = dataset.getProjectKey();
            this.futurePayload = this.buildFuturePayload(dataset);
        }

        private FuturePayload buildFuturePayload(Dataset dataset) {
            FuturePayload fp = new FuturePayload();
            fp.action = "columns_analyze";
            fp.targets.add(DSSFuturePayloadUtils.forDataset(dataset).withPart("auto-detect-classes-from-annotations"));
            fp.displayName = "Auto detecting classes from annotations";
            return fp;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public List<String> getResult() {
            return this.categories;
        }

        public void execute() throws Exception {
            MemTable table = DataService.this.get_NOTRANSACTION((Dataset)this.dataset, (SerializedShakerScript)this.serializedShakerScript.deepCopy(), null, null, (boolean)true, (AuthCtx)this.owner).table;
            switch (this.annotationType) {
                case IMAGE_CLASSIFICATION: 
                case RECORD_CLASSIFICATION: 
                case TEXT_CLASSIFICATION: {
                    this.categories = this.detectSimpleClassificationCategories(table);
                    break;
                }
                case OBJECT_DETECTION: {
                    this.categories = this.detectObjectDetectionCategories(table);
                    break;
                }
                case NAMED_ENTITY_EXTRACTION: {
                    this.categories = this.detectNamedEntityCategories(table);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported annotation type " + String.valueOf((Object)this.annotationType));
                }
            }
        }

        private List<String> detectCategoryFromJSONArrayFaceter(MemTable table, JSONArrayFaceter<?> faceter, List<String> mandatoryFields) throws CodedException {
            MemColumn targetCol = table.column(this.annotationColumn);
            if (targetCol.selectedType.type.getClass() != JSONArrayMeaning.class) {
                throw new IllegalStateException("Column " + this.annotationColumn + " must be of type JSONArray");
            }
            List<String> categories = this.computeCategoriesFromFacet(faceter, table);
            long skippedPercent = Math.round(100.0 * (double)faceter.getNumSkippedRows() / (double)table.nrows());
            if (skippedPercent > 80L) {
                Object mandatoryFieldsStr = "";
                if (mandatoryFields.size() > 0) {
                    mandatoryFieldsStr = (String)mandatoryFieldsStr + " with ";
                    mandatoryFieldsStr = (String)mandatoryFieldsStr + String.join((CharSequence)", ", mandatoryFields);
                }
                throw new CodedException((InfoMessage.MessageCode)FormatCodes.ERR_FORMAT_BOUNDING_BOXES, "Too many rows with bad format (" + skippedPercent + "%) for column " + this.annotationColumn + ", must be a json array with objects" + (String)mandatoryFieldsStr);
            }
            return categories;
        }

        private List<String> detectObjectDetectionCategories(MemTable table) throws CodedException {
            BoundingBoxFaceter faceter = new BoundingBoxFaceter(this.annotationColumn);
            return this.detectCategoryFromJSONArrayFaceter(table, faceter, Arrays.asList("bbox", "category"));
        }

        private List<String> detectNamedEntityCategories(MemTable table) throws CodedException {
            NamedEntityFaceter faceter = new NamedEntityFaceter(this.annotationColumn);
            return this.detectCategoryFromJSONArrayFaceter(table, faceter, Arrays.asList("category", "text", "beginningIndex", "endIndex"));
        }

        private List<String> detectSimpleClassificationCategories(MemTable table) {
            AlphanumFaceter faceter = new AlphanumFaceter(this.annotationColumn, AlphanumFaceter.Sort.COUNT, -1);
            return this.computeCategoriesFromFacet(faceter, table);
        }

        private List<String> computeCategoriesFromFacet(Faceter faceter, MemTable table) {
            FilterFacet filterFacet = faceter.observeAndCompute(table);
            return filterFacet.values.stream().map(category -> category.label).collect(Collectors.toList());
        }
    }

    public static enum CategoryBasedAnnotationType {
        TEXT_CLASSIFICATION,
        RECORD_CLASSIFICATION,
        IMAGE_CLASSIFICATION,
        OBJECT_DETECTION,
        NAMED_ENTITY_EXTRACTION;

    }

    public static class FullSampleColumnDetailedAnalysis {
        public long lastBuild;
        public FullSampleColumnCategoricalAnalysis categorical;
        public FullSampleColumnNumericAnalysis numeric;
    }

    public static class FullSampleColumnCategoricalAnalysis {
        public FullSampleColumnStatistic<String> min;
        public FullSampleColumnStatistic<String> mode;
        public FullSampleColumnStatistic<String> max;
        public FullSampleColumnStatistic<Long> count;
        public FullSampleColumnStatistic<Long> countDistinct;
        public FullSampleColumnStatistic<Long> countMissing;
        public FullSampleColumnStatistic<Long> countInvalid;
        public FullSampleColumnStatistic<List<String>> top10;
        public FullSampleColumnStatistic<List<List<?>>> top10WithCounts;
    }

    public static class FullSampleColumnNumericAnalysis {
        public FullSampleColumnStatistic<Double> sum;
        public FullSampleColumnStatistic<Double> min;
        public FullSampleColumnStatistic<Double> mean;
        public FullSampleColumnStatistic<Double> stddev;
        public FullSampleColumnStatistic<Double> max;
        public FullSampleColumnStatistic<Double> median;
        public FullSampleColumnStatistic<Double> iqr;
        public FullSampleColumnStatistic<Double> p25;
        public FullSampleColumnStatistic<Double> p75;
        public FullSampleColumnStatistic<List<List<?>>> histogram;
    }

    public static class FullSampleColumnStatistic<T> {
        public final T value;
        public final boolean current;
        public final String reason;

        public FullSampleColumnStatistic(T value, boolean current, String reason) {
            this.value = value;
            this.current = current;
            this.reason = reason;
        }
    }
}

