/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints.httpsse;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimpleConsumer;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimplePuller;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimplePusher;
import com.dataiku.dip.streaming.endpoints.httpsse.HTTPSSESimplePuller;
import com.dataiku.dip.streaming.endpoints.httpsse.HTTPSSEStreamingEndpointParams;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;

public class HTTPSSESimplePusher
implements StreamingEndpointSimplePusher {
    private final HTTPSSESimplePuller puller;
    private volatile boolean interrupted;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.streaming.endpoints.httpsse.pusher");

    public HTTPSSESimplePusher(HTTPSSEStreamingEndpointParams params) {
        this.puller = new HTTPSSESimplePuller(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(StreamingEndpointSimpleConsumer consumer, String previousState, ColumnFactory cf, RowFactory rf, Schema schema) throws Exception {
        this.puller.init(cf, rf, schema, (JsonElement)(previousState == null ? null : new JsonPrimitive(previousState)));
        try {
            while (!this.interrupted) {
                StreamingEndpointSimplePuller.RowsPulled pulled = this.puller.next();
                for (Row row : pulled.rows) {
                    consumer.onRow(row);
                }
                consumer.onNewState(pulled.state == null ? null : pulled.state.getAsString());
            }
        }
        finally {
            this.puller.close();
        }
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
        try {
            this.puller.close();
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to close HTTPSSE puller", (Throwable)e);
        }
    }
}

