/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints.sqs;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.SQSConnection;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.streaming.endpoints.RowWithTimestamp;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimplePuller;
import com.dataiku.dip.streaming.endpoints.sqs.SQSFormatDeserializer;
import com.dataiku.dip.streaming.endpoints.sqs.SQSFormatsFactory;
import com.dataiku.dip.streaming.endpoints.sqs.SQSStreamingEndpointParams;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.core.exception.AbortedException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sqs.SqsClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequestEntry;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sqs.model.GetQueueUrlResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sqs.model.Message;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SQSSimplePuller
implements StreamingEndpointSimplePuller {
    @Autowired
    private ConnectionsDAO connectionsDAO;
    private final AuthCtx authCtx;
    private final SQSStreamingEndpointParams params;
    private final boolean nonConsuming;
    private volatile boolean closed;
    private ColumnFactory cf;
    private SqsClient client;
    private String queueUrl;
    private SQSFormatDeserializer deserializer;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.streaming.endpoints.sqs.puller");

    public SQSSimplePuller(AuthCtx authCtx, SQSStreamingEndpointParams params, boolean nonConsuming) {
        this.nonConsuming = nonConsuming;
        SpringUtils.getInstance().autowire((Object)this);
        this.authCtx = authCtx;
        this.params = params;
    }

    @Override
    public void init(ColumnFactory cf, RowFactory rf, Schema readSchema, JsonElement previousState) throws Exception {
        this.cf = cf;
        SQSConnection conn = (SQSConnection)this.connectionsDAO.getConnection(this.authCtx, this.params.connection);
        this.client = conn.getSQSClient(this.authCtx);
        logger.info((Object)"Finding queue url");
        GetQueueUrlResponse getRes = this.client.getQueueUrl(builder -> builder.queueName(this.params.queueName));
        this.queueUrl = getRes.queueUrl();
        if (this.queueUrl == null) {
            throw new Exception("Unable to find queue with given credentials");
        }
        logger.info((Object)"Ready to dequeue");
        this.deserializer = SQSFormatsFactory.getDeserializer(this.params);
        this.deserializer.init(cf, rf, null);
    }

    @Override
    public void setLimit(JsonElement limit) {
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.client != null) {
            this.client.close();
        }
    }

    @Override
    public StreamingEndpointSimplePuller.RowsPulled next() throws Exception {
        ReceiveMessageResponse res;
        StreamingEndpointSimplePuller.RowsPulled pulled = new StreamingEndpointSimplePuller.RowsPulled();
        pulled.rows = Lists.newArrayList();
        ReceiveMessageRequest.Builder requestBuilder = ReceiveMessageRequest.builder().waitTimeSeconds(Integer.valueOf(20)).queueUrl(this.queueUrl).maxNumberOfMessages(Integer.valueOf(10));
        if (this.params.queueName.endsWith(".fifo")) {
            requestBuilder.messageSystemAttributeNames(new MessageSystemAttributeName[]{MessageSystemAttributeName.SENT_TIMESTAMP, MessageSystemAttributeName.MESSAGE_GROUP_ID});
        } else {
            requestBuilder.messageSystemAttributeNames(new MessageSystemAttributeName[]{MessageSystemAttributeName.SENT_TIMESTAMP});
        }
        try {
            res = this.client.receiveMessage((ReceiveMessageRequest)requestBuilder.build());
        }
        catch (AbortedException e) {
            logger.warn((Object)"SQS polling was aborted", (Throwable)e);
            return pulled;
        }
        String lastMessageId = null;
        final ArrayList deletes = Lists.newArrayList();
        if (res.hasMessages()) {
            for (Message msg : res.messages()) {
                String tsStr;
                Row row = this.deserializer.deserialize(msg.body());
                if (this.params.queueName.endsWith(".fifo")) {
                    row.put(this.cf.column(this.params.messageGroupIdColumn), (String)msg.attributes().getOrDefault(MessageSystemAttributeName.MESSAGE_GROUP_ID, null));
                }
                if (row instanceof RowWithTimestamp && StringUtils.isNotBlank((String)(tsStr = (String)msg.attributes().getOrDefault(MessageSystemAttributeName.SENT_TIMESTAMP, null)))) {
                    try {
                        long ts = Long.parseLong(tsStr);
                        ((RowWithTimestamp)row).putTimestamp(ts);
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Unable to parse timestamp " + tsStr + ", not setting it"), (Throwable)e);
                    }
                }
                pulled.rows.add(row);
                deletes.add((DeleteMessageBatchRequestEntry)DeleteMessageBatchRequestEntry.builder().id(msg.messageId()).receiptHandle(msg.receiptHandle()).build());
                lastMessageId = msg.messageId();
            }
        }
        pulled.state = lastMessageId == null ? null : new JsonPrimitive(lastMessageId);
        pulled.ack = !this.nonConsuming ? new Runnable(){

            @Override
            public void run() {
                if (deletes.isEmpty()) {
                    return;
                }
                try {
                    SQSSimplePuller.this.client.deleteMessageBatch(builder -> builder.queueUrl(SQSSimplePuller.this.queueUrl).entries((Collection)deletes));
                }
                catch (Exception e) {
                    ArrayList msgIds = Lists.newArrayList();
                    for (DeleteMessageBatchRequestEntry delete : deletes) {
                        msgIds.add(delete.id());
                    }
                    logger.warn((Object)("Unable to delete messages " + JSON.json((Object)msgIds) + ", will process again"), (Throwable)e);
                }
            }
        } : null;
        return pulled;
    }
}

