/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.timelines;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.HeadWithVersioningInfo;
import com.dataiku.dip.db.AbstractDSSDBService;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.sql.queries.CreateIndexQueryBuilder;
import com.dataiku.dip.sql.queries.CreateTableQueryBuilder;
import com.dataiku.dip.timelines.AbstractTimelinesService;
import com.dataiku.dip.timelines.ITimelinesDBService;
import com.dataiku.dip.timelines.ProjectTimeline;
import com.dataiku.dip.timelines.ProjectTimelineBehavior;
import com.dataiku.dip.timelines.TimelineItem;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import java.io.File;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SingleTimelinesInternalDB
extends AbstractDSSDBService
implements ITimelinesDBService {
    private static final int SCHEMA_VERSION = 1;
    private Map<String, ProjectTimelineBehavior> timelines = new ConcurrentHashMap<String, ProjectTimelineBehavior>();
    private DefaultTimelinesDAO defaultTimelinesDAO = new DefaultTimelinesDAO();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.timelines");

    private static File getFakeProjectDAOFile() {
        return new File(ApplicationConfigurator.getBaseFolderF(), "timelines/any");
    }

    SingleTimelinesInternalDB() throws CodedSQLException {
        super(SingleTimelinesInternalDB.getFakeProjectDAOFile(), "timeline", "timeline", 1, false);
        this.create();
    }

    @Override
    protected void initDB(int currentSchemaVersion, DSSDBConnection conn) {
        block8: {
            try {
                if (currentSchemaVersion != 0) break block8;
                try (Statement st2 = conn.createStatement();){
                    CreateTableQueryBuilder.createTable(this.resolveTable("TIMELINE_ITEM")).addColumns(ProjectTimelineBehavior.timelineColumns).execute(st2, this.getDialect());
                    CreateIndexQueryBuilder.createAnonymousIndex(this.resolveTable("TIMELINE_ITEM")).addColumns("PROJECT_KEY").execute(st2, this.getDialect());
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed to init single timeline.", (Throwable)e);
            }
        }
    }

    @Override
    public DSSDBConnection acquireConnection(String projectKey, boolean isReadOnly) throws CodedSQLException {
        return this.acquireConnection(isReadOnly);
    }

    @Override
    public DSSDBConnection acquireConnection(String projectKey) throws CodedSQLException {
        return this.acquireConnection(projectKey, false);
    }

    @Override
    public void createProject(String projectKey) throws CodedSQLException {
        this.defaultTimelinesDAO.createProject(projectKey);
    }

    @Override
    public void changeObjectId(String projectKey, ITaggingService.TaggableType objectType, String oldId, String newId) throws CodedSQLException {
        this.defaultTimelinesDAO.changeObjectId(projectKey, objectType, oldId, newId);
    }

    @Override
    public void deleteForProject(String projectKey) {
        this.defaultTimelinesDAO.deleteForProject(projectKey);
    }

    @Override
    public void clearForProject(String projectKey) throws CodedSQLException {
        this.defaultTimelinesDAO.clearForProject(projectKey);
    }

    @Override
    public void flagDeletedUser(List<String> projectKeys, String user) {
        this.defaultTimelinesDAO.flagDeletedUser(projectKeys, user);
    }

    @Override
    public void deleteObject(ITaggingService.TaggableType objectType, String projectKey, String objectId) {
        this.defaultTimelinesDAO.deleteObject(objectType, projectKey, objectId);
    }

    @Override
    public List<String> getContributorsForObject(ITaggingService.TaggableType objectType, String projectKey, String objectId) {
        return this.defaultTimelinesDAO.getContributorsForObject(objectType, projectKey, objectId);
    }

    @Override
    public List<String> getContributorsForWiki(String projectKey) {
        return this.defaultTimelinesDAO.getContributorsForWiki(projectKey);
    }

    @Override
    public List<String> getContributors(String projectKey) throws CodedSQLException {
        return this.defaultTimelinesDAO.getContributors(projectKey);
    }

    @Override
    public Map<TaggableObjectsService.TaggableObjectRef, List<TimelineItem>> getRecentTimelineItems(List<String> projects, long since) {
        return this.defaultTimelinesDAO.getRecentTimelineItems(projects, since);
    }

    @Override
    public Map<TaggableObjectsService.TaggableObjectRef, HeadWithVersioningInfo> getCreationAndUpdateInfoForAllObjects(List<String> projectKeys) {
        return this.defaultTimelinesDAO.getCreationAndUpdateInfoForAllObjects(projectKeys);
    }

    @Override
    public Map<TaggableObjectsService.TaggableObjectRef, Collection<String>> getContributorsForAllObjects(List<String> projectKeys) {
        return this.defaultTimelinesDAO.getContributorsForAllObjects(projectKeys);
    }

    @Override
    public void insert(TimelineItem ti) throws CodedSQLException {
        this.defaultTimelinesDAO.insert(ti);
    }

    @Override
    public void update(TimelineItem ti) throws CodedSQLException {
        this.defaultTimelinesDAO.update(ti);
    }

    @Override
    public TimelinesService.TimelineWithVersioning getForProject(String projectKey, int from, int limit) throws CodedSQLException {
        return this.defaultTimelinesDAO.getForProject(projectKey, from, limit);
    }

    @Override
    public ProjectTimeline getForProjectExport(String projectKey) throws CodedSQLException {
        return this.defaultTimelinesDAO.getForProjectExport(projectKey);
    }

    @Override
    public TimelinesService.TimelineWithVersioning getForWiki(String projectKey, int from, int limit) throws CodedSQLException {
        return this.defaultTimelinesDAO.getForWiki(projectKey, from, limit);
    }

    @Override
    public List<TimelineItem> getForObject(ITaggingService.TaggableType objectType, String projectKey, String objectId, int from, int limit) throws CodedSQLException {
        return this.defaultTimelinesDAO.getForObject(objectType, projectKey, objectId, from, limit);
    }

    @Override
    public TimelineItem getFirstForObjectNoCache(ITaggingService.TaggableType objectType, String projectKey, String objectId) throws CodedSQLException {
        return this.defaultTimelinesDAO.getFirstForObjectNoCache(objectType, projectKey, objectId);
    }

    @Override
    public TimelineItem getFirstForObject(ITaggingService.TaggableType objectType, String projectKey, String objectId) throws CodedSQLException {
        return this.defaultTimelinesDAO.getFirstForObject(objectType, projectKey, objectId);
    }

    @Override
    public TimelineItem getLatestForObject(ITaggingService.TaggableType objectType, String projectKey, String objectId) throws CodedSQLException {
        return this.defaultTimelinesDAO.getLatestForObject(objectType, projectKey, objectId);
    }

    @Override
    public Pair<TimelineItem, TimelineItem> getLatestForProjectAndLatestForProjectAndUser(String projectKey, String user) throws CodedSQLException {
        return this.defaultTimelinesDAO.getLatestForProjectAndLatestForProjectAndUser(projectKey, user);
    }

    @Override
    public ProjectTimelineBehavior getDao(String projectKey) throws CodedSQLException {
        return this.defaultTimelinesDAO.getDao(projectKey);
    }

    private class DefaultTimelinesDAO
    extends AbstractTimelinesService {
        private DefaultTimelinesDAO() {
        }

        @Override
        public DSSDBConnection acquireConnection(String projectKey, boolean isReadOnly) throws CodedSQLException {
            return SingleTimelinesInternalDB.this.acquireConnection(isReadOnly);
        }

        @Override
        public void createProject(String projectKey) throws CodedSQLException {
            if (SingleTimelinesInternalDB.this.timelines.containsKey(projectKey)) {
                logger.warnV("Project timeline DAO already created for %s", new Object[]{projectKey});
                return;
            }
            ProjectTimelineBehavior behavior = new ProjectTimelineBehavior(projectKey, SingleTimelinesInternalDB.this.resolveTable("TIMELINE_ITEM"), SingleTimelinesInternalDB.this.getDialect());
            try (DSSDBConnection conn = super.acquireConnection(projectKey);){
                behavior.fetchInitialUIData(conn);
            }
            SingleTimelinesInternalDB.this.timelines.put(projectKey, behavior);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deleteForProject(String projectKey) {
            try (DSSDBConnection conn = super.acquireConnection(projectKey);){
                this.getDao(projectKey).delete(conn);
            }
            catch (Exception e) {
                logger.errorV((Throwable)e, "Failed to delete project timeline for %s", new Object[]{projectKey});
            }
            finally {
                SingleTimelinesInternalDB.this.timelines.remove(projectKey);
            }
        }

        @Override
        public ProjectTimelineBehavior getDao(String projectKey) throws CodedSQLException {
            if (!SingleTimelinesInternalDB.this.timelines.containsKey(projectKey)) {
                logger.debugV("Creating DAO for project timeline %s", new Object[]{projectKey});
                this.createProject(projectKey);
            }
            return SingleTimelinesInternalDB.this.timelines.get(projectKey);
        }
    }
}

