/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.variables;

import com.dataiku.common.stereotype.SecuritySensitive;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.IsolationLevel;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.DynamicLevelsStack;
import com.dataiku.dip.variables.HierarchicalVariablesContext;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesLevelHelper;
import com.dataiku.dip.variables.VariablesService;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@SecuritySensitive
public class BackendVariablesService
extends VariablesService {
    @Autowired
    private TransactionService ts;
    @Autowired
    private ScenarioRunContext scenarioRunContext;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.variables");

    @Override
    public VariablesContext getForGlobal() {
        try {
            HierarchicalVariablesContext hvc = new HierarchicalVariablesContext();
            this.addGlobalLevels(hvc);
            hvc.addLevel(this.scenarioRunContext.getVariablesObject());
            DynamicLevelsStack.fill(hvc);
            logger.trace(() -> "Returning variables getForGlobal -> " + JSON.json(hvc.getAllVariables()));
            return hvc;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read variables", e);
        }
    }

    @Override
    public VariablesContext getForGlobalAndUserLogin(AuthCtx authCtx) {
        try {
            HierarchicalVariablesContext hvc = (HierarchicalVariablesContext)this.getForGlobal();
            hvc.addLevel(VariablesLevelHelper.getNonEditableByUserUserLoginForUser(authCtx));
            logger.trace(() -> "Returning variables getForGlobalAndUserLogin -> " + JSON.json(hvc.getAllVariables()));
            return hvc;
        }
        catch (DKUSecurityException e) {
            throw new RuntimeException("Failed to read variables", e);
        }
    }

    @Override
    public VariablesContext getForProject(String projectKey) {
        if (StringUtils.isBlank((String)projectKey)) {
            throw new IllegalArgumentException("projectKey is empty");
        }
        try {
            HierarchicalVariablesContext hvc = new HierarchicalVariablesContext();
            this.addGlobalLevels(hvc);
            this.addProjectLevels(hvc, projectKey);
            this.addScenarioJobActivityLevels(hvc);
            DynamicLevelsStack.fill(hvc);
            logger.trace(() -> "Returning variables getForProject -> " + JSON.json(hvc.getAllVariables()));
            return hvc;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read variables", e);
        }
    }

    @Override
    public VariablesContext getForProjectAndUserLogin(String projectKey, AuthCtx authCtx) {
        try {
            HierarchicalVariablesContext hvc = (HierarchicalVariablesContext)this.getForProject(projectKey);
            hvc.addLevel(VariablesLevelHelper.getNonEditableByUserUserLoginForUser(authCtx));
            logger.trace(() -> "Returning variables getForProjectAndUserLogin -> " + JSON.json(hvc.getAllVariables()));
            return hvc;
        }
        catch (DKUSecurityException e) {
            throw new RuntimeException("Failed to read variables", e);
        }
    }

    @Override
    public VariablesContext getForConnectionAndUser(DSSConnection connection, AuthCtx authCtx) {
        try {
            HierarchicalVariablesContext hvc = new HierarchicalVariablesContext();
            this.addGlobalLevels(hvc);
            hvc.addLevel(VariablesLevelHelper.getForConnection(connection, authCtx));
            this.addScenarioJobActivityLevels(hvc);
            DynamicLevelsStack.fill(hvc);
            hvc.addLevel(VariablesLevelHelper.getEditableByUserForUser(authCtx));
            hvc.addLevel(VariablesLevelHelper.getNonEditableByUserForUser(authCtx));
            logger.trace(() -> "Returning variables getForConnectionAndUser -> " + JSON.json(hvc.getAllVariables()));
            return hvc;
        }
        catch (DKUSecurityException e) {
            throw new RuntimeException("Failed to read variables", e);
        }
    }

    @Override
    public VariablesContext getForConnectionAndProjectAndUser(DSSConnection connection, AuthCtx authCtx, String projectKey) {
        try {
            HierarchicalVariablesContext hvc = new HierarchicalVariablesContext();
            this.addGlobalLevels(hvc);
            hvc.addLevel(VariablesLevelHelper.getForConnection(connection, authCtx));
            this.addProjectLevels(hvc, projectKey);
            this.addScenarioJobActivityLevels(hvc);
            DynamicLevelsStack.fill(hvc);
            hvc.addLevel(VariablesLevelHelper.getEditableByUserForUser(authCtx));
            hvc.addLevel(VariablesLevelHelper.getNonEditableByUserForUser(authCtx));
            logger.trace(() -> "Returning variables getForConnectionAndProjectAndUser -> " + JSON.json(hvc.getAllVariables()));
            return hvc;
        }
        catch (DKUSecurityException e) {
            throw new RuntimeException("Failed to read variables", e);
        }
    }

    @Override
    public VariablesContext getForProjectAndUser(AuthCtx authCtx, String projectKey) {
        try {
            HierarchicalVariablesContext hvc = new HierarchicalVariablesContext();
            this.addGlobalLevels(hvc);
            this.addProjectLevels(hvc, projectKey);
            this.addScenarioJobActivityLevels(hvc);
            DynamicLevelsStack.fill(hvc);
            if (authCtx != null) {
                hvc.addLevel(VariablesLevelHelper.getEditableByUserForUser(authCtx));
                hvc.addLevel(VariablesLevelHelper.getNonEditableByUserForUser(authCtx));
            }
            logger.trace(() -> "Returning variables getForEverything -> " + JSON.json(hvc.getAllVariables()));
            return hvc;
        }
        catch (DKUSecurityException e) {
            throw new RuntimeException("Failed to read variables", e);
        }
    }

    private void addGlobalLevels(HierarchicalVariablesContext hvc) {
        JsonObject jo = new JsonObject();
        jo.addProperty("dip.home", DKUApp.getBaseFolder());
        jo.addProperty("dku.install.dir", DKUApp.getInstallFolder());
        hvc.addLevel(jo);
        try (Transaction t = this.ts.retrieveOrBeginRead(IsolationLevel.YOLO);){
            BackendVariablesService.addLevel(hvc, (TransactionRef)t, "variables.json");
            BackendVariablesService.addLevel(hvc, (TransactionRef)t, "localvariables.json");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read variables", e);
        }
    }

    private void addProjectLevels(HierarchicalVariablesContext hvc, String projectKey) {
        if (projectKey != null) {
            JsonObject jo = new JsonObject();
            jo.addProperty("projectKey", projectKey);
            hvc.addLevel(jo);
            try (Transaction t = this.ts.retrieveOrBeginRead(IsolationLevel.YOLO);){
                BackendVariablesService.addLevel(hvc, (TransactionRef)t, "projects/" + projectKey + "/variables.json");
                BackendVariablesService.addLevel(hvc, (TransactionRef)t, "projects/" + projectKey + "/localvariables.json");
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read variables", e);
            }
        }
    }

    private void addScenarioJobActivityLevels(HierarchicalVariablesContext hvc) {
        hvc.addLevel(this.scenarioRunContext.getVariablesObject());
        hvc.addLevel(JobContext.getVariablesObject());
        JobActivity ja = JobContext.getCurrentActivityObj();
        if (ja != null && ja.getActivitySpecificVariables() != null) {
            hvc.addLevel(ja.getActivitySpecificVariables());
        }
    }
}

