/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.grel.controls;

import com.dataiku.dip.i18n.LocalizedString;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.controls.IsTest;

public class IsNonBlank
extends IsTest {
    @Override
    protected LocalizedString getDescription() {
        return new LocalizedString("GREL.FUNCTION.IsNonBlank.DOCUMENTATION", "Returns whether <code>o</code> is non-null or a not-empty string. It returns false when value is null or empty (\"\").<br/>It considers a string made of blank spaces as NonBlank; it considers an expression with an error as blank");
    }

    @Override
    protected boolean test(Object o) {
        return ExpressionUtils.isNonBlankData(o);
    }

    @Override
    public Documentation getDocumentation() {
        return super.getDocumentation().withExample(Example.with("\"\"").returns("false")).withExample(Example.with("\" \"").returns("true")).withExample(Example.with("abs(\"a\")").returns("false"));
    }
}

