/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.controllers;

import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.lambda.auth.AuthVerificationService;
import com.dataiku.lambda.controllers.LambdaControllerUtils;
import com.dataiku.lambda.endpoints.sqlquery.SQLQueryEndpointHandler;
import com.dataiku.lambda.server.LambdaAPIControllerBase;
import com.dataiku.lambda.services.ServiceManager;
import com.dataiku.lambda.services.ServicesService;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.log4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class SQLEndpointsController
extends LambdaAPIControllerBase {
    @Autowired
    private ServicesService serviceService;
    @Autowired
    private AuthVerificationService authService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/public/api/v1/{serviceId}/{endpointId}/query"}, method={RequestMethod.GET})
    public void queryGET(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId, @PathVariable String endpointId) throws Exception {
        try (ErrorContext.ACNDC c1 = ErrorContext.pushWithNDC((String)("svc:" + serviceId));
             ErrorContext.ACNDC c2 = ErrorContext.pushWithNDC((String)("ep:" + endpointId));){
            MDC.put((String)"serviceId", (Object)serviceId);
            MDC.put((String)"endpointId", (Object)endpointId);
            ServiceManager manager = this.serviceService.getServiceManagerCheck(serviceId);
            this.authService.checkAuth(manager.getServiceId(), manager.getConfig(), req);
            JsonObject obj = LambdaControllerUtils.makeObjectFromReqParams(req.getParameterMap());
            ServiceManager.RefcountedEndpoint re = manager.acquireEndpoint(endpointId, null);
            try {
                SQLQueryEndpointHandler reh = (SQLQueryEndpointHandler)re.getHandler();
                SQLEndpointsController.writeJSON(resp, reh.run(obj, re));
            }
            finally {
                manager.releaseEndpoint(re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/public/api/v1/{serviceId}/{endpointId}/query"}, method={RequestMethod.POST})
    public void queryPOST(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId, @PathVariable String endpointId) throws Exception {
        try (ErrorContext.ACNDC c1 = ErrorContext.pushWithNDC((String)("svc:" + serviceId));
             ErrorContext.ACNDC c2 = ErrorContext.pushWithNDC((String)("ep:" + endpointId));){
            MDC.put((String)"serviceId", (Object)serviceId);
            MDC.put((String)"endpointId", (Object)endpointId);
            JsonObject body = (JsonObject)this.getRequestBodyAsOrNull(req, JsonObject.class);
            if (body == null) {
                body = new JsonObject();
            }
            ServiceManager manager = this.serviceService.getServiceManagerCheck(serviceId);
            this.authService.checkAuth(manager.getServiceId(), manager.getConfig(), req);
            ServiceManager.RefcountedEndpoint re = manager.acquireEndpoint(endpointId, null);
            try {
                SQLQueryEndpointHandler reh = (SQLQueryEndpointHandler)re.getHandler();
                SQLEndpointsController.writeJSON(resp, reh.run(body, re));
            }
            finally {
                manager.releaseEndpoint(re);
            }
        }
    }
}

