(function() {
    'use strict';
    const app = angular.module('dataiku.homepage');

    app.component('homepageEmptyState', { // homepage-empty-state
        templateUrl: 'static/dataiku/homepage/empty-states/homepage-empty-state/homepage-empty-state.html',
        bindings: {
            animationData: '@'
        },
        transclude: true,
        controller: function($element, $timeout) {
            let animation;
            const ctrl = this;
            const stopOnLastFrame = () => animation && animation.goToAndStop(animation.totalFrames, true);

            ctrl.updateAnimationObject = (a) => {
                animation = a;
                stopOnLastFrame();
            }

            ctrl.startAnimation = () => {
                animation && animation.play();
            }

            ctrl.pauseAnimation = () => {
                stopOnLastFrame();
            }

            // if mouse is already over the element as it's created, ng-mouseenter doesn't get triggered. this takes care of initial state.
            $timeout(() => {
                if ($element.is(':hover')) {
                    ctrl.startAnimation()
                }
            }, 100);
        }
    })

})();
