(function() {
'use strict';

const app = angular.module('dataiku.notebooks.search', ['dataiku.services', 'dataiku.filters']);


app.controller('SearchNotebookController', function (
        $scope, $state, $timeout, $q, $stateParams, $rootScope,
        WT1, Logger, DataikuAPI, TopNav, NotebooksUtils) {

	/* *********************** Basic CRUD ********************* */

    $scope.loadNotebook = function() {
    	const summaryPromise = DataikuAPI.searchNotebooks.getSummary($stateParams.projectKey, $stateParams.notebookId).then(({data}) => {
            $scope.notebookParams = data.object;
            $scope.objectInterest = data.interest;
            $scope.objectTimeline = data.timeline;

            TopNav.setItem(TopNav.ITEM_SEARCH_NOTEBOOK, $scope.notebookParams.id, {
                name : $scope.notebookParams.name
            });
            TopNav.setPageTitle($scope.notebookParams.name + " - SEARCH");

            WT1.event("search-notebook-load", {language: $scope.notebookParams.language});
        });
        const connectionPromise = DataikuAPI.searchNotebooks.listConnections();

        return $q.all([summaryPromise, connectionPromise]).then(([_, {data}]) => {
            $scope.connectionDetails = null;
            $scope.connectionFailed = false;
            for (let i = 0; i < data.nconns.length; i++) {
                if (data.nconns[i].name == $scope.notebookParams.connection) {
                    $scope.connectionDetails = data.nconns[i];
                    break;
                }
            }
            if(!$scope.connectionDetails) {
                $scope.connectionFailed = true;
            }
            if($scope.connectionDetails) {
                $scope.$broadcast('notebookLoaded');
            }
        })
    	.catch(setErrorInScope.bind($scope));
    };

    $scope.refreshTimeline = function(projectKey) {
        DataikuAPI.timelines.getForObject(projectKey || $stateParams.projectKey, "SEARCH_NOTEBOOK", $stateParams.notebookId).success(function(data) {
            $scope.objectTimeline = data;
        }).error(setErrorInScope.bind($scope));
    };

    $scope.copyNotebook = () => {
        NotebooksUtils.copySqlOrSearchNotebook($stateParams.projectKey, "SEARCH", $stateParams.notebookId, $scope.notebookParams.name, $scope);
    };

	const saveParams = function() {
		DataikuAPI.searchNotebooks.save($scope.notebookParams).success(function(data) {
			if (data && data.versionTag) {
				$scope.notebookParams.versionTag = data.versionTag;
			}
			$scope.refreshTimeline();
	   	}).error(setErrorInScope.bind($scope));
	};

    /* Auto save */
    let saveParamsTimer;
    $scope.$watch("notebookParams", function(nv, ov) {
        if ($scope.canWriteProject() && nv && ov) {
            Logger.info("Search Notebook params updated");
            const beforeCopy = angular.copy(ov);
            const afterCopy = angular.copy(nv);
            beforeCopy.versionTag = null;
            afterCopy.versionTag = null;
            if (angular.equals(beforeCopy, afterCopy)) {
                Logger.debug("Only the version tag was modifed, ignoring")
                return;
            }
            $timeout.cancel(saveParamsTimer);
            saveParamsTimer = $timeout(saveParams, 1000);
        }
    }, true);
	/* *********************** Initialization code **************** */

    TopNav.setLocation(TopNav.TOP_NOTEBOOKS, 'notebooks', TopNav.TABS_SEARCH_NOTEBOOK, "query");
    TopNav.setItem(TopNav.ITEM_SEARCH_NOTEBOOK, $stateParams.notebookId);

    $scope.uiState = {};

	$scope.loadNotebook();

    $scope.$watch("notebookLocalState.leftPaneTab", function() {
        $scope.$broadcast("reflow");
    });
});

})();
