(function() {
    "use strict";

    /**
     * <opals-home-banner-container />
     */
    const opalsHomeBannerContainer = {
        bindings: {
            onBannerToggle: '=',
            forceHide: '<?',
        },
        templateUrl: "/static/dataiku/opals/opals-home-banner-container/opals-home-banner-container.component.html",
        controller: function opalsHomeBannerContainerController($scope, $element, LocalStorage, HomeBannerService, OpalsService, OpalsMessageService, WT1) {

            this.homeBannerUrl = "";
            this.frameId = "home-banner-frame";
            this.availability = "pending";

            this.$onInit = function() {
                HomeBannerService.registerHomeBannerController(this);
                if (this.forceHide) {
                    this.showBanner = false;
                    OpalsMessageService.sendHomeBannerState(OpalsMessageService.HOME_BANNER_STATE.CLOSE); // required to register frame with Opals even if component is hidden
                } else {
                    if (LocalStorage.get("dss.opalsHomeBanner.shown") === false) {
                        this.showBanner = false;
                        HomeBannerService.hideHomeBanner(true);
                        OpalsMessageService.sendHomeBannerState(OpalsMessageService.HOME_BANNER_STATE.CLOSE);
                    } else {
                        this.showBanner = true;
                        HomeBannerService.showHomeBanner(true);
                        OpalsMessageService.sendHomeBannerState(OpalsMessageService.HOME_BANNER_STATE.OPEN);
                    }
                }

                OpalsService.getHomeBannerUrl().then((url) => {
                    this.homeBannerUrl = url;
                });

                OpalsService.isHomeBannerAvailable().then((isAvailable) => {
                    this.availability = isAvailable ? "available" : "unavailable";
                    if (this.availability === "available") {
                        const unregister = $scope.$watch(
                            () => $element.find(`#${this.frameId}`),
                            (newVal) => {
                                if (newVal.length > 0) {
                                    this.iframe = newVal[0];
                                    OpalsService.setHomeBannerFrame(newVal[0]);
                                    unregister();
                                }
                            }
                        );
                    } else {
                        OpalsService.getHomeBannerUrl().then((url) => {
                            WT1.event("opals-help-load-error", { opalsUrl: url.toString() });
                        });
                    }
                });
            };
            this.$onDestroy = function() {
                if (this.iframe) {
                    OpalsService.unregisterHomeBannerFrame(this.iframe);
                }
            }

            this.onMessage = OpalsMessageService.handleMessageEvent;
        },
    };

    angular.module("dataiku.opals").component("opalsHomeBannerContainer", opalsHomeBannerContainer);
})();
