# encoding: utf-8
"""
Executor for containerized execution of python evaluation recipe.
"""

import json
import logging

from dataiku.base.folder_context import build_folder_context
from dataiku.base.utils import ErrorMonitoringWrapper
from dataiku.container.runner import setup_log
from dataiku.container.runner import read_execution
from dataiku.core import dkujson

if __name__ == "__main__":
    setup_log()
    execution = read_execution()
    execution_id = execution['id']

    with ErrorMonitoringWrapper():
        payload = json.loads(execution['payload'])
        evaluation_store_folder_in_datadir = payload.get('evaluationStoreFolder', '')
        execution_dir_folder_context = build_folder_context(execution["executionPath"])

        logging.info("Running evaluation recipe main")
        if execution['type'] == 'RECIPE_PREDICTION_EVAL_PYTHON':
            from dataiku.doctor.evaluation.reg_evaluation_recipe import RegularEvaluateRecipe

            runner = RegularEvaluateRecipe(execution["contextPath"], payload['inputDatasetSmartName'], payload['managedFolderSmartId'],
                                           payload['outputDatasetSmartName'], payload['metricsDatasetSmartName'],
                                           execution_dir_folder_context.read_json('desc.json'),
                                           execution_dir_folder_context.read_json('script.json'),
                                           execution_dir_folder_context.read_json('preparation_output_schema.json'),
                                           execution_dir_folder_context.read_json('conditional_outputs.json'),
                                           execution_dir_folder_context.read_json('rpreprocessing_params.json'),
                                           evaluation_store_folder_in_datadir,
                                           payload['evaluationDatasetType'],
                                           dkujson.loads(payload['apiNodeLogsConfig']),
                                           execution["executionPath"],
                                           payload['inputModel'])
            runner.run()

        elif execution["type"] == "RECIPE_PREDICTION_EVAL_KERAS":
            from dataiku.doctor.evaluation.keras_evaluation_recipe import KerasEvaluateRecipe

            runner = KerasEvaluateRecipe(execution["contextPath"], payload['inputDatasetSmartName'],
                                         # No 'managedFolderId' parameter in the Keras case for legacy reasons
                                         payload['outputDatasetSmartName'], payload['metricsDatasetSmartName'],
                                         execution_dir_folder_context.read_json('desc.json'),
                                         execution_dir_folder_context.read_json('script.json'),
                                         execution_dir_folder_context.read_json('preparation_output_schema.json'),
                                         execution_dir_folder_context.read_json('conditional_outputs.json'),
                                         execution_dir_folder_context.read_json('rpreprocessing_params.json'),
                                         evaluation_store_folder_in_datadir,
                                         payload['evaluationDatasetType'],
                                         dkujson.loads(payload['apiNodeLogsConfig']),
                                         execution["executionPath"],
                                         payload['inputModel'])
            runner.run()

        elif execution["type"] == "RECIPE_PREDICTION_EVAL_MLFLOW":
            from dataiku.external_ml.mlflow.pyfunc_evaluation_recipe import PyfuncEvaluateRecipe

            runner = PyfuncEvaluateRecipe(execution["contextPath"], payload['inputDatasetSmartName'],
                                          # No 'managedFolderId' parameter in the MLflow case
                                          payload['outputDatasetSmartName'], payload['metricsDatasetSmartName'],
                                          execution_dir_folder_context.read_json('desc.json'),
                                          # No 'script' parameter in the MLflow case.
                                          # No 'preparation_output_schema' parameter in the MLflow case.
                                          execution_dir_folder_context.read_json('conditional_outputs.json'),
                                          execution_dir_folder_context.read_json('rpreprocessing_params.json'),
                                          evaluation_store_folder_in_datadir,
                                          payload['evaluationDatasetType'],
                                          dkujson.loads(payload['apiNodeLogsConfig']),
                                          execution["executionPath"],
                                          payload['inputModel'])

            runner.run()

        elif execution['type'] == 'RECIPE_PREDICTION_EVAL_TIMESERIES':
            from dataiku.doctor.timeseries.evaluate.launch_evaluation_recipe import main

            main(execution["contextPath"], payload['inputDatasetSmartName'],
                 payload['outputDatasetSmartName'], payload['metricsDatasetSmartName'],
                 execution_dir_folder_context.read_json('desc.json'),
                 execution_dir_folder_context.read_json('script.json'),
                 execution_dir_folder_context.read_json('preparation_output_schema.json'),
                 evaluation_store_folder_in_datadir,
                 execution["executionPath"], payload["inputModel"])

        elif execution['type'] == 'RECIPE_PREDICTION_EVAL_CAUSAL':
            from dataiku.doctor.causal.evaluate.launch_evaluation_recipe import main

            main(execution["contextPath"], payload['inputDatasetSmartName'],
                 payload['outputDatasetSmartName'], payload['metricsDatasetSmartName'],
                 execution_dir_folder_context.read_json('desc.json'),
                 execution_dir_folder_context.read_json('script.json'),
                 execution_dir_folder_context.read_json('preparation_output_schema.json'),
                 # TODO @causal ML Diagnostics code here (See PR#21119)
                 )
        else:
            raise Exception("Unsupported eval recipe type: %s" % execution['type'])
