import os
import logging
import requests

def get_or_create_api_key(impersonate_user=""):
    logging.getLogger("dsscli").info("Creating an admin key for dsscli")

    with open('%s/run/shared-secret.txt' % os.getenv("DIP_HOME"), 'r') as fp:
        secret = fp.read()
        secret = secret.strip()
    port = int(os.environ["DKU_BACKEND_PORT"])
    http_res = requests.request("GET",
                                "http://127.0.0.1:%s/dip/api/pintercom/api-keys/get-temporary-admin-key" % port,
                                headers={
                                    "X-DKU-IPythonSharedSecret": secret,
                                },
                                params={
                                    "requestedBy": "cli-dsscli",
                                    "label": "Key generated by dsscli",
                                    "dssUserForImpersonation": impersonate_user
                                })
    http_res.raise_for_status()

    return http_res.json()["key"]
