import json
import logging

from .json_writer_common import AzureMLJSONWriter

logger = logging.getLogger(__name__)


class AzureMLJSONWriterInputsShaped(AzureMLJSONWriter):
    NAME = "INPUT_AZUREML_JSON_WRITER"

    def __init__(self, client):
        super(AzureMLJSONWriterInputsShaped, self).__init__(client)

    def build_request_payload(self, input_df):
        payload = {
            "Inputs": {"data": input_df.to_dict("records")},
            "GlobalParameters": {"method": "predict_proba"}
        }
        return json.dumps(payload)
