import json
import logging

from . import DatabricksWriter


logger = logging.getLogger(__name__)


class DatabricksJSONWriter(DatabricksWriter):
    NAME = "INPUT_DATABRICKS_JSON_WRITER_BASE"

    def __init__(self, client):
        super(DatabricksJSONWriter, self).__init__(client)

    def write(self, input_df):
        payload = self.build_request_payload(input_df)
        payload = json.dumps(payload)
        return self.client.call_endpoint(payload, {"Content-Type": 'application/json'})
