import json

from dataiku.external_ml.proxy_model.sagemaker.inputformat import SagemakerJSONWriter
from dataiku.external_ml.proxy_model.sagemaker.inputformat.abstract_sagemaker_writer import AbstractSagemakerWriter


class SagemakerJSONLINESWriter(AbstractSagemakerWriter):
    # Implements the JSONLINES format described at
    # https://docs.aws.amazon.com/sagemaker/latest/dg/cdf-inference.html#common-in-formats
    NAME = "INPUT_SAGEMAKER_JSONLINES"

    def __init__(self, client):
        super(SagemakerJSONLINESWriter, self).__init__(client)
        # Since SM supports both the concise and extended JSON formats for a single JSONL line (see link above),
        # using the concise writer here for simplicity
        self.json_writer = SagemakerJSONWriter(client)

    def build_request_payload(self, input_df):
        payload = input_df.values.tolist()
        payload = [self.json_writer.get_line(row) for row in payload]
        payload = "\n".join([json.dumps(row) for row in payload])
        return payload

    def write(self, input_df):
        return self.client.call_endpoint(self.build_request_payload(input_df), {"ContentType": "application/jsonlines"})
