import logging
from typing import Optional

from dataiku.base.socket_block_link import JavaLink, parse_javalink_args
from dataiku.base.utils import watch_stdin, get_json_friendly_error
from dataiku.core.vector_stores.dku_vector_store import VectorStoreFactory

logger = logging.getLogger("vector_store_clear_server")

def serve(port: int, secret: str, server_cert: Optional[str] = None) -> None:
    link = JavaLink(port, secret, server_cert=server_cert)
    link.connect()

    try:
        command = link.read_json()
        rk = command["retrievableKnowledge"]
        exec_folder = command["folderPath"]

        vector_store = VectorStoreFactory.get_vector_store(rk, exec_folder, VectorStoreFactory.get_connection_details_from_env)
        vector_store.clear()

        link.send_json({'ok': True})
        link.send_string('')

    except:
        logger.exception("Knowledge bank server failed")
        json_err = get_json_friendly_error()
        json_err["type"] = "ERROR"
        link.send_json(json_err)
    finally:
        link.close()


if __name__ == "__main__":
    logging.basicConfig(level=logging.DEBUG,
                        format='[%(asctime)s] [%(process)s/%(threadName)s] [%(levelname)s] [%(name)s] %(message)s')
    watch_stdin()
    port, secret, server_cert = parse_javalink_args()
    serve(port, secret, server_cert=server_cert)
