<#import "/common/user_utils.ftl" as user_utils>
<#macro display feedback>
<#assign status_color>
<@compress single_line=true>
    <#switch feedback.status>
        <#case "APPROVED">
            #69a630
            <#break>
        <#case "MINOR_ISSUE">
            #ea963e
            <#break>
        <#case "REJECTED">
        <#case "MAJOR_ISSUE">
            #bf3638
            <#break>
        <#case "ABANDONED">
            #5c5c5c
            <#break>
        <#default>
            #999999
    </#switch>
</@compress>
</#assign>
<#assign status_icon>
<@compress single_line=true>
    <#switch feedback.status>
        <#case "APPROVED">
            ✓
            <#break>
        <#case "MINOR_ISSUE">
            ⓘ
            <#break>
        <#case "REJECTED">
        <#case "MAJOR_ISSUE">
            ⚠
            <#break>
        <#case "ABANDONED">
            ∅
            <#break>
        <#default>
    </#switch>
</@compress>
</#assign>
<b><@user_utils.display feedback.user /></b>
<span style="padding: 4px 8px; margin-left: 4px; border: none; border-radius: 16px; font-family: 'Source Sans Pro', Helvetica, arial, sans-serif; font-size: 13px; line-height: 16px; background-color:${status_color}; color: #ffffff; text-decoration: none; display: inline-block;">
    ${status_icon} ${feedback.status?lower_case?cap_first?replace("_", " ")}
</span>
<span style="font-size: 11px">on ${feedback.creationDate}</span>
<#if feedback.comment?has_content>
<br />${feedback.comment?truncate(300)}
</#if>
<#if feedback.editionDate??>
<span style="font-size: 11px; color: #888888">(edited)</span>
</#if>
</#macro>

<#macro display_all feedbackResponses>
<#if feedbackResponses?? && feedbackResponses?keys?size gt 0>
    <h3 style="font-size: 16px; margin-bottom: 0px;">Feedback</h3>
    <#list feedbackResponses?values as group_feedback>
    <h4 style="margin-top: 0px; margin-bottom: 0px;">${group_feedback?first.group?truncate(80)}</h4>
    <ul style="margin-top: 0px; margin-bottom: 0px;">
        <#list group_feedback?sort_by("creationDate")?reverse as feedback>
        <li>
            <@display feedback />
        </li>
        </#list>
    </ul>
    </#list>
</#if>
</#macro>
